/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFlowString;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMBrightString {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int IN = 2;
    public static final int OUT = 3;
    protected SKMFlowString[] mFlowStrings;
    protected int mStartCount;
    protected int mBrightStartDir;
    protected int mRedLim;
    protected int mGreenLim;
    protected int mBlueLim;
    protected int mAlphaLim;
    protected boolean mIsRainbow;
    protected boolean mIsRepeatBrighting;
    protected int mRepeatBrightCycle;
    protected int mRepeatBrightCount;
    protected int mRepeatBaseRed;
    protected int mRepeatBaseGreen;
    protected int mRepeatBaseBlue;
    protected int mRepeatBaseAlpha;
    protected int mRepeatRedLim;
    protected int mRepeatGreenLim;
    protected int mRepeatBlueLim;
    protected int mRepeatAlphaLim;

    @Deprecated
    public SKMBrightString(SKMFont font, String str, SKMGraphics g, int x, int y, int startCount, int startDir) {
        this(font, str, x, y, startCount, startDir);
    }

    public SKMBrightString(SKMFont font, String str, int x, int y, int startCount, int startDir) {
        this.mFlowStrings = new SKMFlowString[str.length()];
        SKMGraphics g = SKM.getGraphics();
        g.setFont(font);
        x -= g.stringWidth(str) >> 1;
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            this.mFlowStrings[i] = new SKMFlowString(font, str.substring(i, i + 1), false, x, y);
            this.mFlowStrings[i].gradOK(false);
            switch (startDir) {
                case 0: {
                    this.mFlowStrings[i].cnt = -i * 2;
                    break;
                }
                case 1: {
                    this.mFlowStrings[i].cnt = -(this.mFlowStrings.length - i - 1) * 2;
                    break;
                }
                case 2: {
                    this.mFlowStrings[i].cnt = -Math.abs((this.mFlowStrings.length >> 1) - i) * 2;
                    break;
                }
                case 3: {
                    this.mFlowStrings[i].cnt = -((this.mFlowStrings.length >> 1) - Math.abs((this.mFlowStrings.length >> 1) - i)) * 2;
                }
            }
            g.setFont(font);
            x += g.stringWidth(str.substring(i, i + 1));
        }
        this.mStartCount = startCount;
        this.mAlphaLim = -1;
        this.mRepeatBrightCycle = 120;
        this.mRepeatBrightCount = 5;
        this.mRepeatRedLim = 255;
        this.mRepeatGreenLim = 255;
        this.mRepeatBlueLim = 255;
        this.mRepeatAlphaLim = 255;
    }

    public void gradOK(boolean f) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].gradOK(f);
        }
    }

    public void rainbowOK(boolean f) {
        this.mIsRainbow = f;
    }

    public void shadeOK(boolean f) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].shadeOK(f);
        }
    }

    public SKMFlowString[] getFlowStrings() {
        return this.mFlowStrings;
    }

    public void brightAgain(int startCount) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            switch (this.mBrightStartDir) {
                case 0: {
                    this.mFlowStrings[i].cnt = -i * 2;
                    break;
                }
                case 1: {
                    this.mFlowStrings[i].cnt = -(this.mFlowStrings.length - i - 1) * 2;
                    break;
                }
                case 2: {
                    this.mFlowStrings[i].cnt = -Math.abs((this.mFlowStrings.length >> 1) - i) * 2;
                    break;
                }
                case 3: {
                    this.mFlowStrings[i].cnt = -((this.mFlowStrings.length >> 1) - Math.abs((this.mFlowStrings.length >> 1) - i)) * 2;
                }
            }
            if (this.mIsRepeatBrighting) {
                this.mFlowStrings[i].setRGBLim(this.mRepeatRedLim, this.mRepeatGreenLim, this.mRepeatBlueLim, this.mRepeatAlphaLim);
            } else {
                this.mFlowStrings[i].setRGBLim(255, 255, 255);
            }
            this.mFlowStrings[i].gradOK(false);
        }
        this.mStartCount = startCount;
    }

    public void setRepeatBrighting(boolean f) {
        this.mIsRepeatBrighting = f;
    }

    public void setRepeatBrightingCycle(int cycle) {
        this.mRepeatBrightCycle = cycle;
    }

    public void setRepeatBrightingBrightCount(int count) {
        this.mRepeatBrightCount = count;
    }

    public void setRepeatBrightingColors(int red, int green, int blue, int alpha, int brightRed, int brightGreen, int brightBlue, int brightAlpha) {
        this.mRepeatBaseRed = red;
        this.mRepeatBaseGreen = green;
        this.mRepeatBaseBlue = blue;
        this.mRepeatBaseAlpha = alpha;
        this.mRepeatRedLim = brightRed;
        this.mRepeatGreenLim = brightGreen;
        this.mRepeatBlueLim = brightBlue;
        this.mRepeatAlphaLim = brightAlpha;
        this.setRGB(red, green, blue, alpha);
        this.setRGBLim(red, green, blue, alpha);
    }

    public void setShadeLocation(int x, int y) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setShadeLocation(x, y);
        }
    }

    public void setShadeColor(SKMColor c) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setShadeColor(c);
        }
    }

    public void setXY(int x, int y) {
        if (this.mFlowStrings[0] == null) {
            return;
        }
        int dx = x - this.mFlowStrings[0].x;
        int dy = y - this.mFlowStrings[0].y;
        this.mFlowStrings[0].setXY(x, y);
        for (int i = 1; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].x += dx;
            this.mFlowStrings[i].y += dy;
        }
    }

    public void setSpeedXY(int speedX, int speedY) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setSpeedXY(speedX, speedY);
        }
    }

    public void setSpeedByRadian(int speed, double rad) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setSpeedByRadian(speed, rad);
        }
    }

    public void setSpeedXY(int speedX, int speedY, int maxMoveCount) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setSpeedXY(speedX, speedY, maxMoveCount);
        }
    }

    public void setRGB(int red, int green, int blue) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGB(red, green, blue);
        }
    }

    public void setRGB(int red, int green, int blue, int alpha) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGB(red, green, blue, alpha);
        }
    }

    public void setRGBGrad(int dRed, int dGreen, int dBlue) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGBGrad(dRed, dGreen, dBlue);
        }
    }

    public void setRGBGrad(int dRed, int dGreen, int dBlue, int dAlpha) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGBGrad(dRed, dGreen, dBlue, dAlpha);
        }
    }

    public void setRGBLim(int redLim, int greenLim, int blueLim) {
        this.mRedLim = redLim;
        this.mGreenLim = greenLim;
        this.mBlueLim = blueLim;
    }

    public void setRGBLim(int redLim, int greenLim, int blueLim, int alphaLim) {
        this.mRedLim = redLim;
        this.mGreenLim = greenLim;
        this.mBlueLim = blueLim;
        this.mAlphaLim = alphaLim;
    }

    public void setRGBs(int red, int green, int blue, int redLim, int greenLim, int blueLim, int dRed, int dGreen, int dBlue) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGB(red, green, blue);
            this.mFlowStrings[i].setRGBGrad(dRed, dGreen, dBlue);
        }
        this.setRGBLim(redLim, greenLim, blueLim);
    }

    public void setRGBs(int red, int green, int blue, int alpha, int redLim, int greenLim, int blueLim, int alphaLim, int dRed, int dGreen, int dBlue, int dAlpha) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setRGB(red, green, blue, alpha);
            this.mFlowStrings[i].setRGBGrad(dRed, dGreen, dBlue, dAlpha);
        }
        this.setRGBLim(redLim, greenLim, blueLim, alphaLim);
    }

    public void setRounded(boolean f) {
        for (int i = this.mFlowStrings.length - 1; 0 <= i; --i) {
            this.mFlowStrings[i].setRounded(f);
        }
    }

    public void setRoundColor(SKMColor color) {
        for (int i = this.mFlowStrings.length - 1; 0 <= i; --i) {
            this.mFlowStrings[i].setRoundColor(color);
        }
    }

    public void setRoundOffset(int offset) {
        for (int i = this.mFlowStrings.length - 1; 0 <= i; --i) {
            this.mFlowStrings[i].setRoundOffset(offset);
        }
    }

    public void setFont(SKMFont font) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setFont(font);
        }
    }

    public void setMaxMoveCount(int dCount) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].setMoveMax(dCount);
        }
    }

    public void move() {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            if (this.mIsRainbow) {
                if (this.mFlowStrings[i].cnt == this.mStartCount) {
                    this.mFlowStrings[i].rainbowOK(true);
                }
            } else {
                if (this.mFlowStrings[i].cnt == this.mStartCount) {
                    this.mFlowStrings[i].gradOK(true);
                }
                if (this.mFlowStrings[i].cnt == this.mStartCount + 30) {
                    if (this.mAlphaLim == -1) {
                        this.mFlowStrings[i].setRGBLim(this.mRedLim, this.mGreenLim, this.mBlueLim);
                    } else {
                        this.mFlowStrings[i].setRGBLim(this.mRedLim, this.mGreenLim, this.mBlueLim, this.mAlphaLim);
                    }
                }
            }
            this.mFlowStrings[i].move();
        }
        if (this.mIsRepeatBrighting) {
            int brightStartCount = SKMUtil.toInt(this.mRepeatBrightCycle / 2);
            if (this.mFlowStrings[0].getCount() == brightStartCount) {
                this.setRGBLim(this.mRepeatRedLim, this.mRepeatGreenLim, this.mRepeatBlueLim, this.mRepeatAlphaLim);
            } else if (this.mFlowStrings[0].getCount() == brightStartCount + this.mRepeatBrightCount) {
                this.setRGBLim(this.mRepeatBaseRed, this.mRepeatBaseGreen, this.mRepeatBaseBlue, this.mRepeatBaseAlpha);
            } else if (this.mFlowStrings[0].getCount() == this.mRepeatBrightCycle) {
                this.brightAgain(0);
            }
        }
    }

    public void paint(SKMGraphics g) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].paint(g);
        }
    }
}

