/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.DialogCallback;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMConfirmDialog;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.game.GameView;
import jp.ne.sk_mine.util.andr_applet.game.MyFrameButton;
import jp.ne.sk_mine.util.andr_applet.game.SaveLoadDialog;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;

public class DataManagementPage
extends EventBase {
    protected final SKMColor mTitleColor = new SKMColor(230, 230, 230);
    protected boolean mIsSaveLoadEnabled;
    protected boolean mIsPortrait;
    protected boolean mIsPlatformLimited;
    protected MyFrameButton mSaveButton;
    protected MyFrameButton mLoadButton;
    protected MyFrameButton mResetAllDataButton;
    protected SaveLoadDialog mSaveLoadDialog;

    public DataManagementPage() {
        this(false);
    }

    public DataManagementPage(boolean isPortrait) {
        this.mIsPortrait = isPortrait;
        this.init();
    }

    @Override
    protected void myInit() {
        this.mIsSaveLoadEnabled = true;
        SKMI18N i18nCommon = SKM.getI18NCommon();
        SKMFont menuFont = new SKMFont(14);
        this.mSaveButton = new MyFrameButton(i18nCommon.getString("save"), menuFont);
        this.mSaveButton.setVisible(false);
        this.addUi(this.mSaveButton);
        this.mLoadButton = new MyFrameButton(i18nCommon.getString("load"), menuFont);
        this.mLoadButton.setVisible(false);
        this.addUi(this.mLoadButton);
        this.mResetAllDataButton = new MyFrameButton(i18nCommon.getString("reset_all_data"), menuFont);
        this.mResetAllDataButton.setVisible(false);
        this.addUi(this.mResetAllDataButton);
    }

    public void setSaveLoadEnabled(boolean f) {
        this.mIsSaveLoadEnabled = f;
        this.mSaveButton.setVisible(f);
        this.mLoadButton.setVisible(f);
    }

    public void setPlatformLimited(boolean f) {
        this.mIsPlatformLimited = f;
    }

    @Override
    protected void myUpdateButtonPositions() {
        SKMGraphics g = SKM.getGraphics();
        int margin = 15;
        SKMFont categoryFont = new SKMFont(SKMFont.BOLD, 20);
        g.setFont(categoryFont);
        int settingX = 70;
        int settingY = 70;
        this.mSaveButton.setXY(90, settingY);
        this.mLoadButton.setXY(90 + this.mSaveButton.getWidth() + 30, this.mSaveButton.getY());
        this.mResetAllDataButton.setXY(90, settingY += 140);
    }

    @Override
    public void setActive(boolean f) {
        if (f) {
            this.mDw = SKM.getManager().getBaseDrawWidth();
            this.mDh = SKM.getManager().getBaseDrawHeight();
        }
        super.setActive(f);
        this.mSaveButton.setVisible(f && this.mIsSaveLoadEnabled);
        this.mLoadButton.setVisible(f && this.mIsSaveLoadEnabled);
        this.mResetAllDataButton.setVisible(f);
        if (!this.mIsSaveLoadEnabled) {
            this.mVisibledUis.remove(this.mSaveButton);
            this.mVisibledUis.remove(this.mLoadButton);
            this.mResetAllDataButton.setY(110);
        }
    }

    @Override
    public boolean mousePressed(double mx, double my, int button) {
        if (!this.isActive()) {
            return false;
        }
        GameView manager = SKM.getManager();
        if (this.mSaveButton.isHit(mx, my)) {
            SaveLoadDialog dialog = new SaveLoadDialog(true, manager.getRegisterUserUrl());
            dialog.setPlatformLimited(this.mIsPlatformLimited);
            dialog.setVisible(true);
        } else if (this.mLoadButton.isHit(mx, my)) {
            this.mSaveLoadDialog = new SaveLoadDialog(false, manager.getRegisterUserUrl());
            this.mSaveLoadDialog.setPlatformLimited(this.mIsPlatformLimited);
            this.mSaveLoadDialog.setVisible(true);
        } else if (this.mResetAllDataButton.isHit(mx, my)) {
            SKMI18N i18nCommon = SKM.getI18NCommon();
            SKMConfirmDialog resetConfirmDialog = new SKMConfirmDialog("confirm_reset_all_data", i18nCommon.getString("reset_all_data"), i18nCommon.getString("confirm_reset_all_data"));
            resetConfirmDialog.setCallback(new DialogCallback(){

                @Override
                public void okPressed() {
                    SKM.getManager().resetAllData();
                    SKM.getManager().applySettings();
                    SKM.getManager().triggerReset();
                }

                @Override
                public void cancelPressed() {
                }
            });
            resetConfirmDialog.setVisible(true);
        }
        return true;
    }

    @Override
    protected void myRun() {
        String loadData;
        if (this.mIsActive && this.mCount == 1) {
            for (int i = this.mUis.size() - 1; 0 <= i; --i) {
                ((SKMUI)this.mUis.get(i)).setVisible(true);
            }
            this.mSaveButton.setVisible(this.mIsSaveLoadEnabled);
            this.mLoadButton.setVisible(this.mIsSaveLoadEnabled);
        }
        if (this.mSaveLoadDialog != null && (loadData = this.mSaveLoadDialog.getLoadedData()) != null) {
            SKM.getBgmPlayer().stop(true);
            SKM.getManager().applySettingDataString(loadData);
            SKM.getManager().reset();
        }
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        g.setColor(SKMColor.BLACK);
        g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
        g.setFont(new SKMFont(SKMFont.BOLD, 28));
        g.setColor(this.mTitleColor);
        g.drawCenteringString(i18nCommon.getString("settings"), this.mDw / 2, 40);
        SKMFont categoryFont = new SKMFont(SKMFont.BOLD, 20);
        g.setColor(SKMColor.WHITE);
        g.setFont(categoryFont);
        int settingX = this.mSaveButton.getX() - 20;
        g.setFont(new SKMFont(14));
        if (this.mIsSaveLoadEnabled) {
            g.drawString(i18nCommon.getString("explanation_save_load"), settingX, this.mSaveButton.getY() + 70);
        }
        if (this.mIsPlatformLimited) {
            g.drawString(i18nCommon.getString("platform_limited_save_load"), settingX, this.mSaveButton.getY() + 100);
        }
    }
}

