/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMLinearGradient;
import jp.ne.sk_mine.util.andr_applet.SKMStringBuilder;
import jp.ne.sk_mine.util.andr_applet.SKMTimer;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.CButton;
import jp.ne.sk_mine.util.andr_applet.game.TurnPageButton;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;
import jp.ne.sk_mine.util.andr_applet.game.event.FlagManager;
import jp.ne.sk_mine.util.andr_applet.game.event.MessageLine;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageEvent
extends EventBase {
    protected static final int PHASE_MESSAGE = 0;
    protected static final int PHASE_OPEN_WINDOW = 1;
    protected static final int PHASE_CLOSE_WINDOW = 2;
    protected static final int PHASE_WAIT_KEY = 3;
    protected static final int PHASE_SLEEP = 4;
    protected static SKMColor sDefaultColor = SKMColor.WHITE;
    protected static SKMColor sDefaultRoundColor = null;
    protected static SKMFont sDefaultFont = new SKMFont(18);
    protected static boolean sIsDefaultLeftOffsetAfterNewlineEnabled = false;
    protected static boolean sIsDefaultCenteringMessageX = false;
    protected static boolean sIsDefaultCenteringMessageY = false;
    protected static boolean sIsDrawWindowFrame = true;
    protected static boolean sIsUseReplacedString = false;
    protected static int sWindowX = 0;
    protected static int sWindowY = 0;
    protected static int sWindowWidth = 800;
    protected static int sWindowHeight = 500;
    protected static int sTextXOffset = 20;
    protected static int sTextRightOffset = 30;
    protected static int sNextButtonCenterX = -1;
    protected static int sNextButtonCenterY = -1;
    protected JSONArray mMessageData;
    protected int mDataIndex;
    protected int mWaitCount;
    protected int mWaitValue;
    protected boolean mIsKeyPressed;
    protected int mWidth;
    protected int mHeight;
    protected int mCurrentWindowW;
    protected int mCurrentWindowH;
    protected int mWindowX;
    protected int mWindowY;
    protected int mTextXOffset;
    protected int mTextYOffset;
    protected boolean mIsMessageDrawing;
    protected boolean mIsShowMessageAtOnce;
    protected boolean mIsLeftMarginAfterNewlineEnabled;
    protected boolean mIsCenteringMessageX;
    protected boolean mIsCenteringMessageY;
    protected boolean mIsDrawWindowFrame;
    protected boolean mIsUseReplacedString;
    protected boolean mIsSkipMode;
    protected int mSleepSec;
    protected int mTextRightOffset;
    protected int mWindowWidth;
    protected int mWindowHeight;
    protected int mNextButtonCenterX;
    protected int mNextButtonCenterY;
    protected long mTimeBeforeSleep;
    protected long mPrevTimeForSleep;
    protected SKMColor mColor;
    protected SKMColor mRoundColor;
    protected SKMFont mFont;
    protected MessageLine mMessageLine;
    protected FlagManager mFlagManager;
    protected TurnPageButton mNextButton;
    protected SKMArray<SKMButton> mOptionButtons;
    protected SKMImage mMessageAreaBackImage;

    public MessageEvent(JSONArray messageData, FlagManager flagManager) {
        this.mMessageData = messageData;
        this.mFlagManager = flagManager;
        this.init();
    }

    public MessageEvent(SKMArray<String> messageKeys) {
        this.mMessageData = new JSONArray(MessageEvent.createSimpleData(messageKeys));
        this.init();
    }

    public static String createSimpleData(SKMArray<String> messageKeys) {
        SKMStringBuilder simpleDataBuf = new SKMStringBuilder("[{\"command\":\"open_window\"},");
        for (int i = 0; i < messageKeys.size(); ++i) {
            simpleDataBuf.append("{\"command\":\"message\",\"key\":\"");
            simpleDataBuf.append(messageKeys.get(i));
            simpleDataBuf.append("\"},{\"command\":\"wait\"},");
        }
        simpleDataBuf.append("{\"command\":\"close_window\"}]");
        return simpleDataBuf.toString();
    }

    public static void setDefaultColor(SKMColor color) {
        sDefaultColor = color;
    }

    public static void setDefaultRoundColor(SKMColor color) {
        sDefaultRoundColor = color;
    }

    public static void setDefaultFont(SKMFont font) {
        sDefaultFont = font;
    }

    public static void setDefaultOffsetLeftAfterNewlineEnabled(boolean f) {
        sIsDefaultLeftOffsetAfterNewlineEnabled = f;
    }

    public static void setDefaultCenteringMessage(boolean isX, boolean isY) {
        sIsDefaultCenteringMessageX = isX;
        sIsDefaultCenteringMessageY = isY;
    }

    public static void setDefaultWindowPosition(int x, int y) {
        sWindowX = x;
        sWindowY = y;
    }

    public static void setDefaultWindowSize(int width, int height) {
        sWindowWidth = width;
        sWindowHeight = height;
    }

    public static void setDefaultMessageOffset(int leftOffset, int rightOffset) {
        sTextXOffset = leftOffset;
        sTextRightOffset = rightOffset;
    }

    public static void setDefaultNextButtonCenterXY(int x, int y) {
        sNextButtonCenterX = x;
        sNextButtonCenterY = y;
    }

    @Override
    protected void myInit() {
        this.setWaitValue(1);
        this.mNextButton = new TurnPageButton();
        this.mNextButton.setVisible(false);
        this.mIsLeftMarginAfterNewlineEnabled = sIsDefaultLeftOffsetAfterNewlineEnabled;
        this.addUi(this.mNextButton);
        this.mIsDrawWindowFrame = sIsDrawWindowFrame;
        this.mIsCenteringMessageX = sIsDefaultCenteringMessageX;
        this.mIsCenteringMessageY = sIsDefaultCenteringMessageY;
        this.mWidth = sWindowWidth;
        this.mHeight = sWindowHeight;
        this.mWindowX = sWindowX;
        this.mWindowY = sWindowY;
        this.mTextXOffset = sTextXOffset;
        this.mTextYOffset = 32;
        this.mTextRightOffset = sTextRightOffset;
        this.mNextButtonCenterX = sNextButtonCenterX;
        this.mNextButtonCenterY = sNextButtonCenterY;
        this.mColor = sDefaultColor;
        this.mRoundColor = sDefaultRoundColor;
        this.mFont = sDefaultFont;
        this.mOptionButtons = new SKMArray();
        this.updateButtonPositions();
    }

    public void setWindowImage(SKMImage image) {
        this.mMessageAreaBackImage = image;
    }

    public void setCenteringMessage(boolean isX, boolean isY) {
        this.mIsCenteringMessageX = isX;
        this.mIsCenteringMessageY = isY;
    }

    public void setDrawWindowFrame(boolean f) {
        this.mIsDrawWindowFrame = f;
    }

    public void setWindowPosition(int x, int y) {
        this.mWindowX = x;
        this.mWindowY = y;
    }

    public void setWindowSize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
    }

    public void setMessageOffset(int leftOffset, int rightOffset) {
        this.mTextXOffset = leftOffset;
        this.mTextRightOffset = rightOffset;
    }

    public void setTextYOffset(int offset) {
        this.mTextYOffset = offset;
    }

    public void setNextButtonCenterXY(int x, int y) {
        this.mNextButtonCenterX = x;
        this.mNextButtonCenterY = y;
    }

    public void setColor(SKMColor color) {
        this.mColor = color;
    }

    public void setRoundColor(SKMColor color) {
        this.mRoundColor = color;
    }

    public void setFont(SKMFont font) {
        this.mFont = font;
    }

    public void setSkipMode(boolean f) {
        this.mIsSkipMode = f;
        if (f) {
            if (this.mPhase == 3) {
                this.mIsKeyPressed = true;
            } else if (this.mPhase == 4) {
                this.mSleepSec = 0;
            }
        }
    }

    @Override
    protected void myUpdateButtonPositions() {
        if (this.mNextButtonCenterX == -1) {
            this.mNextButton.setCenterXY(this.mWindowX + this.mWidth - 70, this.mWindowY + this.mHeight - 26);
        } else {
            this.mNextButton.setCenterXY(this.mNextButtonCenterX, this.mNextButtonCenterY);
        }
        if (this.mOptionButtons.size() != 0) {
            int centerX = this.mWindowX + this.mWidth / 2;
            int buttonY = this.mWindowY + this.mHeight - this.mOptionButtons.get(0).getHeight() / 2 - 20;
            SKMButton.layoutHorizontalCenteringAt(centerX, buttonY, 20, this.mOptionButtons);
        }
    }

    @Override
    protected void mySetPhase(int phase) {
        this.mNextButton.setVisible(phase == 3 && this.mOptionButtons.size() == 0);
    }

    @Override
    public boolean mousePressed(double mx, double my, int button) {
        if (this.mOptionButtons.size() != 0) {
            for (int i = this.mOptionButtons.size() - 1; 0 <= i; --i) {
                SKMButton optionButton = this.mOptionButtons.get(i);
                if (!optionButton.isHit(mx, my)) continue;
                String value = optionButton.getValue();
                if (value != null && this.mFlagManager != null) {
                    String[] tokens = value.split(",");
                    this.mFlagManager.setFlag(Integer.parseInt(tokens[0]), Boolean.parseBoolean(tokens[1]));
                }
                this.mIsKeyPressed = true;
                for (int j = this.mOptionButtons.size() - 1; 0 <= j; --j) {
                    this.removeUi(this.mOptionButtons.get(j));
                }
                this.mOptionButtons.clear();
                return true;
            }
            return false;
        }
        if (this.mNextButton.isVisible()) {
            this.mIsKeyPressed = true;
            return true;
        }
        if (this.mMessageLine != null) {
            int tmpWaitValue = this.mWaitValue;
            this.setWaitValue(0);
            this.run();
            this.setWaitValue(tmpWaitValue);
        }
        return false;
    }

    public boolean isSelecting() {
        return this.mOptionButtons.size() != 0;
    }

    @Override
    protected void myRun() {
        if (this.isFinished()) {
            return;
        }
        if (this.mPhase == 3) {
            if (this.mIsKeyPressed) {
                this.mIsKeyPressed = false;
                this.mMessageLine = null;
                this.setPhase(0);
            } else {
                return;
            }
        }
        if (this.mPhase == 4) {
            if ((long)(this.mSleepSec * 1000) < SKMTimer.getTime() - this.mTimeBeforeSleep) {
                this.mSleepSec = 0;
                this.setPhase(0);
            } else {
                return;
            }
        }
        if (this.mPhase == 1) {
            if (this.mCurrentWindowW < this.mWidth) {
                int d = SKMUtil.toInt(this.mWidth / 8);
                if (d == 0) {
                    d = 1;
                }
                this.mCurrentWindowW += d;
                if (this.mCurrentWindowH < this.mHeight) {
                    int dh = SKMUtil.toInt(this.mHeight / 8);
                    if (dh == 0) {
                        dh = 1;
                    }
                    this.mCurrentWindowH += dh;
                }
            } else {
                this.mCurrentWindowW = this.mWidth;
                this.mCurrentWindowH = this.mHeight;
                this.setPhase(0);
            }
        } else if (this.mPhase == 2) {
            if (0 < this.mCurrentWindowW) {
                int d = SKMUtil.toInt(this.mWidth / 8);
                if (d == 0) {
                    d = 1;
                }
                this.mCurrentWindowW -= d;
                if (0 < this.mCurrentWindowH) {
                    int dh = SKMUtil.toInt(this.mHeight / 8);
                    if (dh == 0) {
                        dh = 1;
                    }
                    this.mCurrentWindowH -= dh;
                }
            } else {
                this.mCurrentWindowW = 0;
                this.mCurrentWindowH = 0;
                this.setPhase(0);
            }
        } else if (this.mPhase == 0) {
            if (!this.mIsShowMessageAtOnce && 0 < this.mWaitCount) {
                --this.mWaitCount;
                if (this.mWaitCount == 0) {
                    this.mWaitCount = this.mWaitValue;
                } else {
                    return;
                }
            }
            if (this.mIsMessageDrawing) {
                if (!this.mMessageLine.update(this.mIsShowMessageAtOnce || this.mWaitValue == 0 || this.mOptionButtons.size() != 0)) {
                    this.mIsMessageDrawing = false;
                }
            } else {
                this.execCommand();
            }
        }
    }

    public void pauseProc() {
        if (this.mPhase == 4) {
            long nowT = SKMTimer.getTime();
            long dt = nowT - this.mPrevTimeForSleep;
            this.mTimeBeforeSleep += dt;
            this.mPrevTimeForSleep = nowT;
        }
    }

    protected String getString(String key) {
        String s = SKM.getI18N().getString(key);
        if (s.equals("")) {
            s = SKM.getI18NCommon().getString(key);
        }
        return s;
    }

    protected void execCommand() {
        JSONObject obj;
        if (this.mMessageData.length() <= this.mDataIndex) {
            this.finish();
            return;
        }
        if ((obj = this.mMessageData.getJSONObject(this.mDataIndex++)).isNull("command")) {
            this.execCommand();
            return;
        }
        String command = obj.getString("command");
        boolean isRecall = false;
        if (command.equals("set_wait_count")) {
            this.setWaitValue(obj.getInt("n"));
            isRecall = true;
        } else if (command.equals("show_at_once")) {
            this.mIsShowMessageAtOnce = obj.getBoolean("f");
            isRecall = true;
        } else if (command.equals("open_window")) {
            this.setPhase(1);
        } else if (command.equals("set_window")) {
            this.mCurrentWindowW = this.mWidth;
            this.mCurrentWindowH = this.mHeight;
        } else if (command.equals("close_window")) {
            this.setPhase(2);
        } else if (command.equals("remove_window")) {
            this.mCurrentWindowW = 0;
            this.mCurrentWindowH = 0;
        } else if (command.equals("message")) {
            String key = obj.getString("key");
            boolean isCenteringMessageX = this.mIsCenteringMessageX;
            boolean isCenteringMessageY = this.mIsCenteringMessageY;
            if (!obj.isNull("centering_x")) {
                isCenteringMessageX = obj.getBoolean("centering_x");
            }
            if (!obj.isNull("centering_y")) {
                isCenteringMessageY = obj.getBoolean("centering_y");
            }
            this.mMessageLine = new MessageLine(this.mIsUseReplacedString ? SKM.getI18N().getReplacedString(key) : SKM.getI18N().getString(key), this.mTextXOffset, this.mTextYOffset, this.mWindowX, this.mWindowY, this.mCurrentWindowW, this.mCurrentWindowH, this.mTextRightOffset, this.mColor, this.mRoundColor, this.mFont, this.mIsLeftMarginAfterNewlineEnabled, isCenteringMessageX, isCenteringMessageY);
            if (!obj.isNull("option_num")) {
                int optionNum = obj.getInt("option_num");
                for (int i = 0; i < optionNum; ++i) {
                    String optionHeader = "option" + (i + 1);
                    String buttonLabel = null;
                    buttonLabel = obj.isNull(optionHeader + "_key") ? "" + (i + 1) : this.getString(obj.getString(optionHeader + "_key"));
                    CButton optionButton = new CButton(buttonLabel, -100, -100);
                    optionButton.setWidth(80);
                    if (!obj.isNull(optionHeader + "_flag") && !obj.isNull(optionHeader + "_value")) {
                        int flagIndex = obj.getInt(optionHeader + "_flag");
                        boolean flagValue = obj.getBoolean(optionHeader + "_value");
                        optionButton.setValue(flagIndex + "," + flagValue);
                    }
                    this.addUi(optionButton);
                    this.mOptionButtons.add(optionButton);
                }
                this.updateButtonPositions();
            }
            this.mIsMessageDrawing = true;
        } else if (command.equals("wait")) {
            if (!this.mIsSkipMode) {
                this.setPhase(3);
            }
        } else if (command.equals("shake_screen")) {
            if (!this.mIsSkipMode) {
                String type = obj.getString("type");
                if (type.equals("v")) {
                    this.mGameManager.setScreenShake(true, 4);
                } else if (type.equals("vd")) {
                    this.mGameManager.setScreenShake(true, 1);
                } else if (type.equals("h")) {
                    this.mGameManager.setScreenShake(true, 3);
                } else if (type.equals("hd")) {
                    this.mGameManager.setScreenShake(true, 0);
                } else if (type.equals("stop")) {
                    this.mGameManager.setScreenShake(false);
                }
            }
        } else if (command.equals("sleep")) {
            if (!this.mIsSkipMode) {
                if (!obj.isNull("sec")) {
                    this.mSleepSec = obj.getInt("sec");
                }
                this.mTimeBeforeSleep = this.mPrevTimeForSleep = SKMTimer.getTime();
                this.setPhase(4);
            }
        } else if (command.equals("if")) {
            int flagId = obj.getInt("n");
            if (this.mFlagManager != null && !this.mFlagManager.getFlag(flagId)) {
                do {
                    ++this.mDataIndex;
                } while (this.mMessageData.length() > this.mDataIndex && !this.mMessageData.getJSONObject(this.mDataIndex).getString("command").equals("endif"));
            }
        } else if (command.equals("not_if")) {
            int flagId = obj.getInt("n");
            if (this.mFlagManager != null && this.mFlagManager.getFlag(flagId)) {
                do {
                    ++this.mDataIndex;
                } while (this.mMessageData.length() > this.mDataIndex && !this.mMessageData.getJSONObject(this.mDataIndex).getString("command").equals("endif"));
            }
        } else if (command.equals("window_position")) {
            int nextButtonDx = this.mNextButtonCenterX - this.mWindowX;
            int nextButtonDy = this.mNextButtonCenterY - this.mWindowY;
            if (obj.has("position")) {
                String position = obj.getString("position");
                if (position.equals("top")) {
                    this.mWindowX = 0;
                    this.mWindowY = 0;
                } else if (position.equals("bottom")) {
                    this.mWindowX = 0;
                    this.mWindowY = this.mGameManager.getBaseDrawHeight() - this.mCurrentWindowH;
                }
            } else {
                if (obj.has("x")) {
                    this.mWindowX = obj.getInt("x");
                }
                if (obj.has("y")) {
                    this.mWindowY = obj.getInt("y");
                }
            }
            this.mNextButtonCenterX = this.mWindowX + nextButtonDx;
            this.mNextButtonCenterY = this.mWindowY + nextButtonDy;
            isRecall = true;
            this.updateButtonPositions();
        } else if (command.equals("window_size")) {
            Object h;
            Object w = obj.get("width");
            if (w instanceof String) {
                if (((String)w).equals("full")) {
                    this.mWidth = this.mGameManager.getBaseDrawWidth();
                }
            } else if (w instanceof Integer) {
                this.mWidth = Integer.parseInt((String)w);
            }
            if ((h = obj.get("height")) instanceof String) {
                if (((String)w).equals("full")) {
                    this.mHeight = this.mGameManager.getBaseDrawHeight();
                }
            } else if (h instanceof Integer) {
                this.mHeight = Integer.parseInt((String)h);
            }
            isRecall = true;
            this.updateButtonPositions();
        } else if (command.equals("play_bgm")) {
            if (!this.mIsSkipMode) {
                boolean isLoop = false;
                if (!obj.isNull("loop")) {
                    isLoop = obj.getBoolean("loop");
                }
                SKM.getBgmPlayer().play(obj.getString("name"), isLoop);
            }
        } else if (command.equals("replay_bgm")) {
            if (!this.mIsSkipMode) {
                SKM.getBgmPlayer().play();
            }
        } else if (command.equals("stop_bgm")) {
            SKM.getBgmPlayer().stop(false);
        } else if (command.equals("play_sound")) {
            if (!this.mIsSkipMode) {
                boolean isLoop = false;
                if (!obj.isNull("loop")) {
                    isLoop = obj.getBoolean("loop");
                }
                this.mGameManager.playSound(obj.getString("name"), isLoop);
            }
        } else if (command.equals("stop_sound")) {
            if (obj.isNull("name")) {
                this.mGameManager.stopAllSounds();
            } else {
                this.mGameManager.stopSound(obj.getString("name"));
            }
        } else if (command.equals("left_margin_after_newline")) {
            this.mIsLeftMarginAfterNewlineEnabled = obj.getBoolean("f");
        } else if (command.equals("finish")) {
            this.finish();
        }
        if (this.execOtherCommand(command, obj)) {
            isRecall = true;
        }
        if (isRecall) {
            this.execCommand();
        }
    }

    protected boolean execOtherCommand(String command, JSONObject obj) {
        return false;
    }

    private final void setWaitValue(int waitValue) {
        this.mWaitCount = this.mWaitValue = waitValue;
        this.mIsShowMessageAtOnce = waitValue == 0;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mIsDrawWindowFrame) {
            this.drawWindow(g, this.mWindowX, this.mWindowY);
        }
        if (this.mMessageLine != null) {
            g.saveTransform();
            g.translate(this.mWindowX, this.mWindowY);
            this.mMessageLine.paint(g);
            g.restoreTransform();
        }
    }

    public boolean isSpeaking() {
        return this.mIsMessageDrawing;
    }

    private final void drawWindow(SKMGraphics g, int x, int y) {
        g.saveTransform();
        g.translate(x + this.mWidth / 2, y + this.mHeight / 2);
        double scale = (double)this.mCurrentWindowW / (double)this.mWidth;
        if (scale != 1.0) {
            g.scale(scale, scale);
        }
        if (this.mMessageAreaBackImage == null) {
            g.translate(-this.mWidth / 2, -this.mHeight / 2);
            this.drawOriginalWindow(g);
        } else {
            g.drawCenteringImage(this.mMessageAreaBackImage, 0, 0);
        }
        g.restoreTransform();
    }

    protected void drawOriginalWindow(SKMGraphics g) {
        g.drawFrame(0, 0, this.mWidth, this.mHeight, 6, 1);
    }

    protected void drawGreenGradationWindow(SKMGraphics g, int x, int y) {
        int offsetX = (this.mWidth - this.mCurrentWindowW) / 2;
        int offsetY = (this.mHeight - this.mCurrentWindowH) / 2;
        int borderW = 5;
        g.setColor(SKMColor.WHITE);
        g.saveStroke();
        g.setStroke(3.0f);
        g.drawRoundRect(x + offsetX + 2, y + offsetY + 2, this.mCurrentWindowW - 4, this.mCurrentWindowH - 4, 8, 8);
        g.restoreStroke();
        g.setGradient(new SKMLinearGradient(0.0f, (float)(y + 3), new SKMColor(0, 160, 0), 0.0f, y + this.mCurrentWindowH - 3, new SKMColor(0, 100, 0)));
        g.fillRoundRect(x + offsetX + 5 - 1, y + offsetY + 5 - 1, this.mCurrentWindowW - 10 + 1, this.mCurrentWindowH - 10 + 1, 8, 8);
        g.setGradient(null);
        g.setColor(new SKMColor(200, 200, 200));
        g.drawRoundRect(x + offsetX, y + offsetY, this.mCurrentWindowW - 1, this.mCurrentWindowH - 1, 8, 8);
        g.drawRoundRect(x + offsetX + 5 - 2, y + offsetY + 5 - 2, this.mCurrentWindowW - 10 + 3, this.mCurrentWindowH - 10 + 3, 8, 8);
    }

    protected void drawTransparentGrayWindow(SKMGraphics g, int x, int y) {
        int offsetX = (this.mWidth - this.mCurrentWindowW) / 2;
        int offsetY = (this.mHeight - this.mCurrentWindowH) / 2;
        int borderW = 5;
        g.setColor(SKMColor.WHITE);
        g.saveStroke();
        g.setStroke(3.0f);
        g.drawRoundRect(x + offsetX + 2, y + offsetY + 2, this.mCurrentWindowW - 4, this.mCurrentWindowH - 4, 8, 8);
        g.restoreStroke();
        g.setColor(new SKMColor(0, 0, 0, 120));
        g.fillRect(x + offsetX + 5, y + offsetY + 5, this.mCurrentWindowW - 10, this.mCurrentWindowH - 10);
        g.setColor(new SKMColor(200, 200, 200));
        g.drawRoundRect(x + offsetX, y + offsetY, this.mCurrentWindowW - 1, this.mCurrentWindowH - 1, 8, 8);
        g.drawRoundRect(x + offsetX + 5 - 2, y + offsetY + 5 - 2, this.mCurrentWindowW - 10 + 3, this.mCurrentWindowH - 10 + 3, 8, 8);
    }
}

