/* escsub.h */
/* edmi - text editor min - */
/* (c)2024 wnc develop / t.w. */
/* The MIT License */
/* org 20240528 */
/* rev 20240727 */
/* macro */

#ifndef ESCSUB_H
#define ESCSUB_H

/* cursor on */
#define ESC_cursor_on() do{ printf("\033[>5l",stdout);fflush(stdout);}while(0)

/* cursor off */
#define ESC_cursor_off() do{ printf("\033[>5h",stdout);fflush(stdout);}while(0)

/* set cursor position x y */
#define ESC_cursor(x,y) do{ printf("\033[%d;%dH",y,x);fflush(stdout);}while(0)

/* ESC[2J clear screen */
#define ESC_cls() do{fputs("\033[2J",stdout); fflush(stdout);}while(0)

/* ESC[s cursor position save */
#define ESC_csave() do{fputs("\033[s",stdout); fflush(stdout);}while(0)

/* ESC[u cursor position load */
#define ESC_cload() do{fputs("\033[u",stdout); fflush(stdout);}while(0)

/* ESC[pnA cursor pos up 1 */
#define ESC_cur_u1() do{fputs("\x1b[1A",stdout);fflush(stdout);}while(0)

/* ESC[pnB cursor pos down 1 */
#define ESC_cur_d1() do{fputs("\x1b[1B",stdout);fflush(stdout);}while(0)

/* ESC[pnC cursor pos right 1 */
#define ESC_cur_r1() do{fputs("\x1b[1C",stdout);fflush(stdout);}while(0)

/* ESC[pnD cursor pos left 1 */
#define ESC_cur_l1() do{fputs("\x1b[1D",stdout);fflush(stdout);}while(0)

/* ESC[0J cursor x y kara saisyuu gyou migihaji delete */
#define ESC_cur_dellast() do{fputs("\n1b[0J",stdout);fflush(stdout);}while(0)

/* ESC[0K cursor x,y kara gyou migi haji delete */
#define ESC_cur_delend() do{fputs("\x1b[0K",stdout);fflush(stdout);}while(0)

/* ESC[2K cursor y hidari haji kara migi haji delete */
#define ESC_cur_delgyo() do{fputs("\x1b[2K",stdout);fflush(stdout);}while(0)

/* ESC[pnL cursor y uegyo kuuhaku 1 line insert */
#define ESC_1lineinsert() do{fputs("\x1b[1L",stdout);fflush(stdout);}while(0)

/* ESC[pnM cursor y kara 1line delete */
#define ESC_1linedel() do{fputs("\x1b[1M",stdout);fflush(stdout);}while(0)

/* ESC[31m moji color red */
#define ESC_fontred() do{fputs("\x1b[31m",stdout);fflush(stdout);}while(0)

/* ESC[36m moji color aqua */
#define ESC_fontaqua() do{fputs("\x1b[36m",stdout);fflush(stdout);}while(0)

/* ESC[m  moji default */
#define ESC_fontdef() do{fputs("\x1b[m",stdout);fflush(stdout);}while(0)

#endif   /* ESCSUB_H */

