/* ed12 */
/* edmi - text editor min - */
/* (c)2024,2025 wnc develop / t.w. */
/* The MIT License */
/* 20240510,0606,0708,0722,0803,0817,0830,0915,1007 */
/* 20250916,0928,1006 */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <i86.h>
#include <dos.h>
#include <stdlib.h>

/* escape code */
#include "escsub.h"

/* main define 20240529 */
#include "maindef.h"
/* main proto 20240602 */
#include "mainprot.h"

#if DEBUG
void debug1out(edit_dat*);
#endif

/* pc-9801 only */
#include "sub98.h"

/* text memory (ed4) */
char textmemall[TEXTMEMSIZ+2];

#define FNAMEMAXSIZ 250
char fname[FNAMEMAXSIZ+2];

#define CGYOSIZ SCRMJIMAX  /* 79 */
char copywork[CGYOSIZ+2];  /* Ctrl+C copy gyo ed10 */

/* edit data and screen data*/
edit_dat ed1;

/* read only flag */
int ed_ro;   /* == 0 r/w  == 1 r only */

/* tab size */
int ed_tab;  /* == 0 tab8 , == 1 tab4 */

char keydat; /* input key */

/* ctrl+c */
void (__interrupt __far *prev_int_23)();
void __interrupt __far int_23()
{
	/* misyori */
}

/* int 24h (add ed12) */
/* int24sub.asm (i24hand_) */
extern void __interrupt __far i24hand(void);
extern void __interrupt __far i24hand2(void);

void (__interrupt __far *prev_int_24)();

extern char i24getv(void);
extern void i24resv(void);

/* dos version (add ed12) */
char dver;

#include "mainact.c" /* mojisyori */

int main(int argc,char *argv[])
{
	char a;

	int f_kanji;

	char ctrl_p_mukouka[]="\x1b[16;\"\xfd\";p";
	char ctrl_n_mukouka[]="\x1b[14;\"\xfd\";p";
	char ctrl_p_modosu[]="\x1b[16;\"\";p";
	char ctrl_n_modosu[]="\x1b[14;\"\";p";

	/* textmemall EOF_CODE clear (ed10) */
	memset(textmemall, EOF_CODE , sizeof(textmemall));

	/* filename 0 clear (ed5) */
	memset(fname, 0 , sizeof(fname));

	/* copygyo work 0 clear (ed10) */
	memset(copywork, 0 , sizeof(copywork));

	/* load */
	FILE *fp;
	int num;

	/* save */
	int wrhand;  /* dos file handle */
	unsigned wrsize;
	char i24retval;
	unsigned fc_ret;

	char *p;

	ed_tab = 0;  /* ==0 tab8 , ==1 tab4 */
	f_kanji =0;  /* ==0 , ==1 dai1byte */
	ed_ro = 0;  /* reset edit flag */

	/* param chk */
	for(int i=1;i<argc;i++)
	{
		p = argv[i];
		if((p[0] == '-') || (p[0] == '/'))
		{
			/* option chk */
			a = p[1];
			if( a >= 'A' && a <= 'Z' ) { a = a | 0x20;} /* tolower */
			switch(a)
			{
				case '4': ed_tab = 1; break;
				case 'r': ed_ro = 1; break; /* ed8 add */
				case '?':
					ed_help();
					return 0;
					break;
			}
		}
		else
		{
			/* file name */
			strncpy(fname,argv[i],(FNAMEMAXSIZ-1));
		}
	}

	/* ----------- */
	/* ctrl+c stop */
	/* ----------- */
	prev_int_23 = _dos_getvect(0x23);
	_dos_setvect(0x23 , int_23 );

	/* ----------- */
	/* int 24h     */
	/* (add ed12)  */
	/* ----------- */
	prev_int_24 = _dos_getvect(0x24);

	/* dos version chk */
	dver = bdos( 0x30 , 0 , 0 );  /* get dos version */

	if(dver >= 3)
	{	/* dos3- */
		_dos_setvect(0x24 , i24hand );

		/* ctrl+p,ctrl+n mukou ka ed11,ed12 dos3- */
		fputs(ctrl_p_mukouka,stdout);  /* ctrl-p -> 0xfd ,PRN */
		fputs(ctrl_n_mukouka,stdout);  /* ctrl-n -> 0xfd ,PRN */
	}
	else
	{	/* dos2.xx ONLY */
		_dos_setvect(0x24 , i24hand2 );
	}


	ESC_cls();  /* screen clear */

	/* ============ */
	/* pc-9801 only */
	/* ============ */
	/* key custom */
	getkeydc();
	setkeydc();
	/* ============ */

	if( fname[0] != 0 )
	{
		if( (fp = fopen(fname,"rb"))!= NULL )
		{
			num = fread( textmemall ,sizeof(char), (TEXTMEMSIZ-1), fp);
			ed1.tusize = num;  /*  */
			fclose(fp);

			if(num >= (TEXTMEMSIZ-1))
			{
				ed_ro = 1;  /* read only */
				/* read only */
				err_put(MES001);
				getch();

				/* saigo chk */
				a = textmemall[(num-1)];
				if(a == CR_CODE)
				{
					textmemall[(num-1)] = EOF_CODE;
					ed1.tusize = (num-1);
				}
			}
		}
		else
		{
			/* read err */
		}
	}

	/* sx screen x , sy screen y */
	/* mx memory x , my memory y */
	ed1.sx=0;ed1.sy=0;
	ed1.oypos=0; /* ed4 */
	ed1.mypos=0; /* ed4 */
	ed1.mxypos=0; /* ed4 */
	ed1.tmem = textmemall;
	ed1.tsize = (TEXTMEMSIZ-1);
	ed1.scexec = SC_ALL;  /* ed5 screen output syori code */

	ed1.tlinecnt = gyocnt(&ed1);  /* ed7 total line count */

	/* tab size (def 8) */
	if( ed_tab == 0 )
	{
		ed1.tab = TAB8SIZ;
	}
	else
	{
		ed1.tab = TAB4SIZ;
	}

	/* oypos = getoypos(oy); */
	ESC_cursor_off();
	scmojioutall(&ed1); /* typedef edit_dat */
	ESC_cursor_on();
	cursor(ed1.sx,ed1.sy);

	/* ------------------------------ */
	/* -------- editor main --------- */
	/* ------------------------------ */
	while(1)
	{
		a = keyin();

		/* esc code */
		if( a == ESC_KEY )
		{
			a = bdos(0x0c,0,0); /* key buffer clear */
			continue;
		}

		/* ctrl+q  editor exit */
		if( a == CTRL_Q)
		{
			/* loop out */
			cursor(0,(SCRGYOMAX-1));
			fputs("\n",stdout);
			fflush(stdout);
			break;
		}

		/* ======================= */
		/* write file
		/* ======================= */
		/* ctrl+s(uwagaki) , ctrl+e(namae tukete hozon) */
		if( ((a == CTRL_E) || (a == CTRL_S)) )  /* 1 */
		{
			int fnamret;
			fnamret = 0;  /* reset */
			fc_ret = 0; /* reset */

			if(ed_ro == 0)  /* kakikomi kanou */ /* 2 */
			{
				if( a == CTRL_E ) { fname[0] = '\0'; } /* kyousei */
				if(fname[0] == '\0')
				{
					/* input filename */
					fnamret = fname_input(fname,FNAMEMAXSIZ);
				}

				if(fnamret==0) /* no err */
				{
					if( _dos_creat( fname, _A_NORMAL, &wrhand) != 0)
					{
						/* open error */
						err_put(MES002);
						getch();
					}
					else
					{
						i24resv();  /* reset i24val */

						_dos_write( wrhand, textmemall ,ed1.tusize,
									 &wrsize);

						fc_ret = _dos_close(wrhand);

						i24retval = i24getv();

						/* ed12 wr err */
						if( (wrsize < ed1.tusize) || (fc_ret != 0))
						{
							err_put(MES003);
							getch();
						}
						else if(i24retval != 0)  /* dos 2 or 3.3 */
						{
							err_put(MES002);
							getch();
						}
					}
				}
				else
				{
					err_put(MES002);
					getch();
				}
			}  /* 2 */
			/* ctrl+e or ctrl+s siyouzumi */
			a = 0;  /* key mukouka */

			/* output all */
			ed1.scexec = SC_ALL; 

		} /* 1 */
		keydat = a; /* backup */

		/* key(editor syori) */
		/* cursor syori fukumu */
		if(ed_ro == 0)
		{
			/* none */
		}
		else
		{
			/* read only */
			switch(a)
			{
				/* cursor key only */
				case EDSCUP:
				case EDSCDOWN:
				case EDSCLEFT:
				case EDSCRIGHT:
				case EDSCRDN:  /* roll down */
				case EDSCRUP:  /* roll up */
				break;

				default:
				a = 0;  /* key mukou */
				ed1.scexec = SC_SONOMAMA; 
				break;
			}
		}

		/* ---------------------- */
		/*   sonotano key syori   */
		/* ---------------------- */
		int frollud;
		frollud = 0;  /* flag , roll up roll down */

		/* ctrl+key */
		switch(a)
		{
			case CTRL_A:  /* 0x01 */
			case CTRL_B:  /* 0x02 */
			/* CTRL_C: 0x03 copy gyo */
			case CTRL_D:  /* 0x04 */
			/* CTRL_E: 0x05 save as */
			case CTRL_F:  /* 0x06 */
			case CTRL_G:  /* 0x07 */
			/* CTRL_H: 0x08 (BS_KEY) */
			/* CTRL_I: 0x09 (TAB_KEY) */
			case CTRL_J:  /* 0x0a */
			/* CTRL_K: 0x0b sakujyo gyo */
			case CTRL_L:  /* 0x0c */
			/* CTRL_M: 0x0d (CR_KEY) */
			case CTRL_N:  /* 0x0e mukouka ed11(prt) -> */
			case CTRL_O:  /* 0x0f */
			case CTRL_P:  /* 0x10 mukouka ed11(prt) -> 0xfd*/
			/* CTRL_Q: 0x0f quit */
			case CTRL_R:  /* 0x12 */
			/* CTRL_S: 0x13 save */
			/* CTRL_T: 0x14 rollup */
			case CTRL_U:  /* 0x15 */
			/* CTRL_V: 0x16 haritsuke gyo */
			case CTRL_W:  /* 0x17 */
			case CTRL_X:  /* 0x18 */
			/* CTRL_Y: 0x19 rolldown */
			case CTRL_Z:  /* 0x1a */
			case 0xfd: /* mukouka code (ctrl+p,ctrl+n PRN) */
				a = 0;  /* mukou ka */
				ed1.scexec = SC_SONOMAMA; 
				break;
			/*--------------*/
			/* use ctrl+key */
			/*--------------*/
			case CTRL_C:
				copygyou(&ed1,copywork,CGYOSIZ);
				a = 0;  /* mukou ka */
				ed1.scexec = SC_SONOMAMA; 
				break;
			case CTRL_V:
				haritsuke(&ed1,copywork,CGYOSIZ);
				a = 0;  /* mukou ka */
				ed1.scexec = SC_ALL; 
				break;
			case CTRL_K:
				copygyou(&ed1,copywork,CGYOSIZ); /* ed12 add */
				sakujyo(&ed1);
				a = 0;  /* mukou ka */
				ed1.scexec = SC_ALL; 
				break;

			/* ed11 version 20241005 */
			case EDSCRUP: a = EDSCDOWN; frollud =1; break;
			case EDSCRDN: a = EDSCUP; frollud = 1; break;
		}

		if(frollud != 0)
		{
			/* rollup rolldown syori */
			for(int i=0;i<(SCRGYOMAX-1);i++)
			{
				mojisyori(&ed1,a);
			}
			ed1.scexec = SC_ALL;
		}
		else
		{
			/* ============= */
			/* tuujyou syori */
			/* ============= */
			if( a != 0)  /* ed11 */
			{
				mojisyori(&ed1,a);   /* mainact.c */
			}
		}
		/* -------------- */
		/* FEP taisaku    */
		/* (ed6 20240802) */
		/* -------------- */
		if(f_kanji == 0)
		{
			if(chksjis1b(a) != 0)
			{
				f_kanji = 1;  /* dai1byte kanji */
				continue;
			}
		}
		else  /* f_kanji==1 */
		{
			f_kanji = 0;  /* clear flag */
		}

		/* -------------- */
		/* output screen  */
		/* -------------- */
		ESC_cursor_off();
		switch(ed1.scexec)
		{
			case SC_ALL:        scmojioutall(&ed1); break;
			case SC_SYDAKE:     scmojioutsy(&ed1); break;
			case SC_SENTOADD:   scmojioutoy(&ed1); break;
			case SC_SAIGOADD:   scmojioutendy(&ed1); break;
			case SC_CMIGISAI:   scmojioutsyre(&ed1,SC_DELTRUE); break;
			case SC_CMIGISAIND: scmojioutsyre(&ed1,SC_DELFALSE); break;
			case SC_CMIGILAST:  scmojioutsyrlast(&ed1); break;
			case SC_SYINS:      scmojioutsyins(&ed1); break;
			case SC_SYDEL:      scmojioutsydel(&ed1); break;
			case SC_SONOMAMA: /* nanimo shinai */ break;
			default:
			break;
		}

		cursor(ed1.sx,ed1.sy);
		ESC_cursor_on();

		/* debug output */
#if DEBUG
		debug1out(&ed1);
#endif
	} /* editor main loop */

	/* ==================== */
	/* program syuryo syori */
	/* ==================== */

	/* ============== */
	/*  pc-9801 only  */
	/*  (key custom)  */
	/* ============== */
	retkeydc();
	/* ============== */

	if(dver >= 3)
	{	/* dos3- */
		/* ctrl+p,ctrl+n modosu ed11,ed12 */
		puts(ctrl_p_modosu);
		puts(ctrl_n_modosu);
	}

	ESC_cls();  /* screen clear */

	/* ctrl+c recover */
	_dos_setvect( 0x23 , prev_int_23);

	/* int 24h recover */
	_dos_setvect( 0x24 , prev_int_24);

	return 0;  /* return dos */
}

/* ===================================== */
#if DEBUG
void debug1out(edit_dat *wed)
{
	/* debug only */
	ESC_csave();
	int i;
	cursor(0,20);
	printf("k[%x] sx[%d]sy[%d]",keydat,wed->sx,wed->sy);
	cursor(0,21);
	printf("mxyo[%d]myo[%d]oyo[%d]",wed->mxypos,wed->mypos,wed->oypos);
	cursor(0,22);
	for(i=0; i<10;i++) {printf("%X",textmemall[wed->mypos+i]);}
	fflush(stdout);
	ESC_cload();
}
#endif
