/* sub98.c */
/* edmi - text editor min - */
/* (c)2024 wnc develop / t.w. */
/* The MIT License */
/* rev20240803 */

#include <dos.h>
#include <i86.h>

/* local */
#include "sub98.h"
#include "maindef.h"
#include "escsub.h"

/* pc-9801 only */
static char key_u[]={ EDSCUP,0,0,0,0,0 };
static char key_l[]={ EDSCLEFT,0,0,0,0,0 };
static char key_r[]={ EDSCRIGHT,0,0,0,0,0 };
static char key_d[]={ EDSCDOWN,0,0,0,0,0 };
static char key_del[]={ EDSCDEL,0,0,0,0,0 }; /* delete key */
static char key_rup[]={ EDSCRUP,0,0,0,0,0 }; /* roll up */
static char key_rdn[]={ EDSCRDN,0,0,0,0,0 }; /* roll down */

#define PC98KEYDATBUF 386  /* normal mode */
static char pc98kdbuf[(PC98KEYDATBUF+1)];

/* get key default */
/* pc-9801 */
void getkeydc(void)
{
	union REGS r;
	struct SREGS s;
	s.ds = FP_SEG( pc98kdbuf );
	r.w.dx = FP_OFF( pc98kdbuf );
	r.w.ax = 0;  /* normal mode all key */
	r.h.cl = 0x0c;  /* key syutoku */
	int86x(0xdc, &r, &r, &s);
}

/* key set default */
/* pc-9801 */
void retkeydc(void)
{
	union REGS r;
	struct SREGS s;
	s.ds = FP_SEG( pc98kdbuf );
	r.w.dx = FP_OFF( pc98kdbuf );
	r.w.ax = 0;  /* normal mode all key */
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);
}

/* set key custom */
/* pc-9801 */
void setkeydc(void)
{
	/* key_u key_l key_r key_l (6byte)*/

	union REGS r;
	struct SREGS s;
	s.ds = FP_SEG( key_u );
	r.w.dx = FP_OFF( key_u );   /* arrow up */
	r.h.ah = 0;
	r.h.al = 0x19;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_l);    /* arrow left */
	r.h.ah = 0;
	r.h.al = 0x1a;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_r);    /* arrow right */
	r.h.ah = 0;
	r.h.al = 0x1b;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_d);    /* arrow down */
	r.h.ah = 0;
	r.h.al = 0x1c;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_del);  /* delete key */
	r.h.ah = 0;
	r.h.al = 0x18;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_rup);  /* roll up */
	r.h.ah = 0;
	r.h.al = 0x15;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

	r.w.dx = FP_OFF( key_rdn);  /* roll down */
	r.h.ah = 0;
	r.h.al = 0x16;
	r.h.cl = 0x0d;
	int86x(0xdc, &r, &r, &s);

}
