{$MODE DELPHI}
{$APPTYPE CONSOLE}
program MidiToWRD;
//uE8.2ṽCxgEBhEŏoꂽTSVWRDɕϊ
//2025/10/16 Ver. 1.0

//@WMODE  @LOCATE ̃}NR}h1sɂꂾ1߂Ԃv
//悤B̃R}hA1sɂłBR}h؂ɂ͖ԊuA
//' 'A";"gpł悤Bs̍Ō";"tƎ̍sƍ킹1̎
//Ԃ̏vƂȂB

uses Classes, SysUtils;

type
  LyricArrayType = array[1..12] of string; //112܂őΉŏ\낤B
  MeasureDataType = record
                      BeatsPerMeasure: string; //qL̕q
                      NoteValue: string; //qL̕
                      Lyric: LyricArrayType
                    end;

var
  NoHyphen: Boolean; //sɃnCtt邩ǂ
  NecessaryRecords: TStringList;  //TSVKvŝݒo
  MeasureData: array of MeasureDataType; //11s̔z
  MaxMeasure: Integer; //̎̂ŏI
  MaxLyricLen: Integer; //1̎̍őoCg
  TsvFile, WrdFile: TextFile;

function CutField(var Rec: string): string;
  //TSV ̃R[h獶[1tB[h؂ԂB
var
  n: Integer;
begin
  n := Pos(#9, Rec);
  if n = 0 then
  begin
    Result := Rec;
    Rec := '';
    Exit
  end
  else
  begin
    Result := Copy(Rec, 1, n - 1);
    Delete(Rec, 1, n)
  end
end;

procedure ReadParams;
procedure Usage;
begin
  Writeln('gp@: MidiToWRD  <̓^u؂eLXgt@C>  ',
    '<oWRDt@C>  [/nohyphen]');
  Writeln('i"/nohyphen"͍sɃnCttȂIvVłj')
end;
begin
  if not (ParamCount in [2, 3]) or not FileExists(ParamStr(1)) then
  begin
    Usage;
    Halt(1)
  end;
  if ParamCount = 3 then
  begin
    if UpperCase(ParamStr(3)) = '/NOHYPHEN' then
      NoHyphen := True
    else if (ParamStr(3) <> '') then
    begin
      Usage;
      Halt(1)
    end
    else
      NoHyphen := False
  end;
  AssignFile(TsvFile, ParamStr(1));
  AssignFile(WrdFile, ParamStr(2))
end;

procedure SetNecessaryRecords; //KvȃR[h𒊏o
var
  st, f4, f5, f7, Measure, Beat, Tick, Event, Value1: string;
begin
  NecessaryRecords := TStringList.Create;
  Reset(TsvFile);
  while not Eof(TsvFile) do
  begin
    Readln(TsvFile, st);
    CutField(st); //sԍ
    CutField(st); //ׯ
    CutField(st); //::b:ؕb
    f4 := CutField(st); //::è
    Measure := Copy(f4, 1, 5);
    Beat := Copy(f4, 7, 2);
    Tick := Copy(f4, 10, 3);
    f5 := CutField(st); //Ă̎
    Event := f5;
    if (Event = 'qL') or (Event = '̎') or 
      (Event = '÷') and not ((Measure ='00001') and (Tick = '000')) then
      //1ߖڂ̃eBbN0̃eLXgCxg͑sv
    begin
      CutField(st); //
      f7 := CutField(st); //l1
      Value1 := f7;
      if (Event = 'qL') or
        not ((Copy(Value1, 1, 1) = '@') or (Length(Value1) >= 30)) then
        //\tgɂĂ"@"Ŏn܂l̓^Cg\ŎgpĂ邪WRD
        //͍폜B
        //܂"KarMaker - UNREGISTERED VER."Ƃ\tg쐬Ă炵
        //midif[^ɂ"KarMaker - UNREGISTERED VER."Ƃ܂ވُ
        //l݂Ă悤Ȃ̂ł폜B
        NecessaryRecords.Add(Measure + Beat + Copy(Event, 1, 4) + Value1);
      MaxMeasure := StrToInt(Measure)
    end
  end;
  if NecessaryRecords.Count = 0 then
  begin
    NecessaryRecords.Free;
    Writeln('̓t@CႤA̎Ȃ悤łB');
    Halt(1)
  end
end;

procedure SetMeasureData; //ŏIo͂ɎgpMeasureDatazɒl𖄂߂B
var
  BeatsPerMeasure: string; //qL̕q
  NoteValue: string; //qL̕
  Measure, Beat, Event, Value: string;
  st, v: string;
  n, m: Integer;
begin
  SetLength(MeasureData, MaxMeasure + 1);
    //1x[X̂悤Ɏĝ"+ 1"ƂB
  for n := 0 to MaxMeasure do
  begin
    MeasureData[n].BeatsPerMeasure := '';
    MeasureData[n].NoteValue := '';
    for m := 1 to 12 do
      MeasureData[n].Lyric[m] := '';
  end;
  BeatsPerMeasure := '4'; //qLȂꍇ̃ftHgl
  NoteValue := '4'; //qLȂꍇ̃ftHgl
  for n := 0 to NecessaryRecords.Count - 1 do
  begin
    st := NecessaryRecords[n];
    Measure := Copy(st, 1, 5);
    Beat := Copy(st, 6, 2);
    Event := Copy(st, 8, 4);
    Value := Copy(st, 12, MaxInt);
    if Event = 'q' then
    begin
      v := Value;
      BeatsPerMeasure := Copy(v, 1, Pos('/', v) - 1);
      Delete(v, 1, Pos('/', v));
      NoteValue := Copy(v, 1, Pos(' ', v) - 1)
    end
    else
    begin
      MeasureData[StrToInt(Measure)].BeatsPerMeasure := BeatsPerMeasure;
      MeasureData[StrToInt(Measure)].NoteValue := NoteValue;
      MeasureData[StrToInt(Measure)].Lyric[StrToInt(Beat)] :=
        MeasureData[StrToInt(Measure)].Lyric[StrToInt(Beat)] + Value
    end
  end;
  for n := 1 to MaxMeasure do //S̍sɔq𖄂߂ĂB
  begin
    if (n = 1) and (MeasureData[n].BeatsPerMeasure = '') then
      MeasureData[n].BeatsPerMeasure := '4' //qLȂꍇ̃ftHgl
    else if MeasureData[n].BeatsPerMeasure = '' then
      MeasureData[n].BeatsPerMeasure := MeasureData[n - 1].BeatsPerMeasure;
    if (n = 1) and (MeasureData[n].NoteValue = '') then
      MeasureData[n].NoteValue := '4' //qLȂꍇ̃ftHgl
    else if MeasureData[n].NoteValue = '' then
      MeasureData[n].NoteValue := MeasureData[n - 1].NoteValue
  end
end;

procedure SetMaxLyricLen; //1̎̍őoCg𓾂B
var
  LyricLen, n, m: Integer;
begin
  MaxLyricLen := 0;
  for n := 1 to MaxMeasure do
    for m:= 1 to 1 do
    begin
      LyricLen := Length(MeasureData[n].Lyric[m]);
      if LyricLen > MaxLyricLen then MaxLyricLen := LyricLen
    end
end;

function GetNextLyric(CurrentMeasure, CurrentBeat: Integer): string;
  //͔̎̔̉̎
var
  NextMeasure, NextBeat: Integer;
begin
  NextMeasure := CurrentMeasure;
  NextBeat := CurrentBeat + 1;
  Result := '';
  repeat
    if NextBeat > StrToInt(MeasureData[NextMeasure].BeatsPerMeasure) then
    begin
      Inc(NextMeasure);
      if NextMeasure > MaxMeasure then Exit;
      NextBeat := 1
    end;
    Result := MeasureData[NextMeasure].Lyric[NextBeat];
    Inc(NextBeat)
  until Result <> ''
end;

procedure WriteWrd; //MeasureDatagWRDt@Co
const
  Alphabets = ['A'..'Z', 'a'..'z'];
var
  Y, X: Integer;
  NextLyric, st: string;
  n, m: Integer;
begin
  try
    Rewrite(WrdFile);
  except
    Writeln('WRDt@C݂̏ŃG[܂B');
    NecessaryRecords.Free;
    Halt(1)
  end;
  Y := 1;
  X := 1;
  for n := 1 to MaxMeasure do
  begin
    if MeasureData[n].NoteValue <> MeasureData[n - 1].NoteValue then
      //1sڂNoteValueς"@WMODE"ށB
      //1sڂ̎";"tƂȂ̎\܂Ă܂B
    begin
      Write(WrdFile,
        '@WMODE(', 96 div StrToInt(MeasureData[n].NoteValue) - 1, ')');
      if n = 1 then
        Writeln(WrdFile, '')
      else
        Writeln(WrdFile, ';')
    end;
    st := '';
    for m := 1 to StrToInt(MeasureData[n].BeatsPerMeasure) do
    begin
      Writeln(WrdFile, '@LOCATE(', Y, ';', X, ');');
      st := MeasureData[n].Lyric[m];
      X := X + Length(st);
      NextLyric := GetNextLyric(n, m);
      if (X > 80 - MaxLyricLen - 2) and (NextLyric <> '') and (st[Length(st)]
        in Alphabets) and (NextLyric[1] in Alphabets) then
        //pPꂪrŐ؂Ăs"-"tB
        if not NoHyphen then st := st + '-';
      Writeln(WrdFile, st);
      if X > 80 - MaxLyricLen - 2 then
      begin
        Inc(Y);
        if Y = 25 then
        begin
          Writeln(WrdFile, '@SCROLL(1,1,80,5,0);');
          Y := 24
        end;
        X := 1
      end
    end
  end;
  CloseFile(WrdFile)
end;

begin
  ReadParams;
  SetNecessaryRecords;
  SetMeasureData;
  SetMaxLyricLen;
  WriteWrd;
  NecessaryRecords.Free
end.
