/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import jp.ne.sk_mine.util.andr_applet.ReceiveCallback;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMMap;

public class SKMConnectUtil {
    private static final String RESOURCE_STATE_MESSAGE = "jp.ne.sk_mine.util.andr_applet.res.message.message";
    public static final String SMALL_SEPARATOR = ",";
    public static final String PART_SEPARATOR = "\t";
    public static final String LARGE_SEPARATOR = "+";
    public static final String EMPTY_DATA = "-";
    public static final String EMPTY_NAME = " ";
    public static final int ERROR_UNDER_RECORD = 0;
    public static final int ERROR_RANK_OUT = -1;
    public static final int ERROR_CONNECT_DB = -2;
    public static final int ERROR_CONNECTION = -3;
    public static final int ERROR_CERT_FAILED = -4;
    public static final int ERROR_DUP_NAME = -5;
    public static final int ERROR_DECRYPTION = -6;
    public static final int ERROR_DATA_FORMAT = -7;
    public static final int ERROR_NO_DATA = -8;
    public static final int ERROR_INVALID_SESSION = -9;
    public static final int ERROR_INTERNET_CONNECTION = -10;
    public static final int STATE_MY_TIME_UP = -50;
    public static final int STATE_OPPONENT_TIME_UP = -51;
    public static final int STATE_MY_ESCAPE = -52;
    public static final int STATE_OPPONENT_ESCAPE = -53;
    public static final int STATE_MY_TAP_OUT = -54;
    public static final int STATE_OPPONENT_TAP_OUT = -55;
    public static final int RESULT_YOU_WIN = -80;
    public static final int RESULT_YOU_LOSE = -81;
    public static final int RESULT_YOU_DEFAULT_WIN = -82;
    public static final int RESULT_YOU_DEFAULT_LOSE = -83;
    public static final int ERROR_INVALID = -98;
    public static final int NO_ERROR = -99;
    public static final String KEY_COMMAND = "command";
    public static final String KEY_USER_ID = "uid";
    public static final String KEY_PASSWORD = "pwd";
    public static final String KEY_SESSION_ID = "session_id";
    public static final String KEY_NAME = "name";
    public static final int RES_NO = 0;
    public static final int RES_YES = 1;
    public static final int COMMAND_LOGIN = 1;
    public static final int COMMAND_LOGOUT = 2;
    public static final int COMMAND_GET_NAME = 3;
    private int mPort;
    private String mUserId;
    private String mSessionId;
    private String mName;
    private String mProtocol;
    private String mHost;
    private String mPath;
    private String mReceiveDataEncoding = "UTF-8";
    private String mSendDataEncoding = "UTF-8";
    private ReceiveCallback mReceiveCallback;

    public void setReceiveEncoding(String encoding) {
        this.mReceiveDataEncoding = encoding;
    }

    public void setSendEncoding(String encoding) {
        this.mSendDataEncoding = encoding;
    }

    public void setServerInfo(String host, String protocol, int port, String path) {
        this.mHost = host;
        this.mProtocol = protocol;
        this.mPort = port;
        this.mPath = path;
    }

    public void setServerInfo(String url) {
        try {
            URL u = new URL(url);
            this.mHost = u.getHost();
            this.mProtocol = u.getProtocol();
            this.mPort = u.getPort();
            this.mPath = u.getPath();
            if (!this.mPath.startsWith("/")) {
                this.mPath = "/" + this.mPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getMyName() {
        return this.mName;
    }

    public void setMyName(String name) {
        this.mName = name;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public String connectUrl(String data) {
        return this.connectUrl(this.mHost, this.mProtocol, this.mPort, this.mPath, data);
    }

    public void connectUrl(String data, ReceiveCallback callback) {
        this.connectUrl(this.mHost, this.mProtocol, this.mPort, this.mPath, data, callback);
    }

    public String connectUrl(String host, String protocol, int port, String path, String data) {
        return this.connectUrl(host, protocol, port, path, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connectUrl(String host, String protocol, int port, String path, String data, ReceiveCallback callback) {
        this.mReceiveCallback = callback;
        String receiveEncoding = this.mReceiveDataEncoding;
        String sendEncoding = this.mSendDataEncoding;
        String ret = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            URL url = new URL(protocol, host, port, path);
            HttpURLConnection connection = protocol.startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-type", "text/plain");
            out = sendEncoding == null ? new PrintWriter(connection.getOutputStream()) : new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), sendEncoding));
            out.print(data);
            out.flush();
            out.close();
            out = null;
            in = receiveEncoding == null ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream(), receiveEncoding));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    ret = line;
                }
                in.close();
                in = null;
            }
            catch (Exception e) {
                System.err.println("Error in ConnectInfo.connectURL():read");
                e.printStackTrace();
            }
            if (this.mReceiveCallback != null) {
                this.mReceiveCallback.receive(ret);
            }
            String string = ret;
            return string;
        }
        catch (Exception e) {
            System.err.println("Error in ConnectInfo.connectURL()");
            if (ret != null) {
                System.out.println("ret=" + ret);
            }
            e.printStackTrace();
            if (this.mReceiveCallback != null) {
                this.mReceiveCallback.receive(null);
            }
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public String connectUrlByPost(SKMMap<String, String> parameters) {
        return this.connectUrlByPost(this.mHost, this.mProtocol, this.mPort, this.mPath, parameters, null);
    }

    public void connectUrlByPost(SKMMap<String, String> parameters, ReceiveCallback callback) {
        this.connectUrlByPost(this.mHost, this.mProtocol, this.mPort, this.mPath, parameters, callback);
    }

    public String connectUrlByPost(String host, String protocol, int port, String path, SKMMap<String, String> parameters) {
        return this.connectUrlByPost(host, protocol, port, path, parameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connectUrlByPost(String host, String protocol, int port, String path, SKMMap<String, String> parameters, ReceiveCallback callback) {
        this.mReceiveCallback = callback;
        OutputStream out = null;
        String ret = null;
        BufferedReader in = null;
        try {
            StringBuffer paramString = new StringBuffer();
            if (parameters != null) {
                Object[] keys = parameters.getKeys();
                for (int i = 0; i < keys.length; ++i) {
                    if (i != 0) {
                        paramString.append("&");
                    }
                    paramString.append(keys[i]);
                    paramString.append("=");
                    paramString.append(URLEncoder.encode(parameters.get(keys[i].toString()), "UTF-8"));
                }
            }
            URL url = new URL(protocol, host, port, path);
            HttpURLConnection connection = protocol.startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            out = connection.getOutputStream();
            out.write(paramString.toString().getBytes());
            in = this.mReceiveDataEncoding == null ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream(), this.mReceiveDataEncoding));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    ret = line;
                }
                in.close();
                in = null;
            }
            catch (Exception e) {
                System.err.println("Error in ConnectInfo.connectUrlByPost():read");
                e.printStackTrace();
            }
            if (this.mReceiveCallback != null) {
                this.mReceiveCallback.receive(ret);
            }
            String string = ret;
            return string;
        }
        catch (Exception e) {
            System.err.println("Error in ConnectInfo.connectUrlByPost()");
            if (ret != null) {
                System.out.println("ret=" + ret);
            }
            e.printStackTrace();
            if (this.mReceiveCallback != null) {
                this.mReceiveCallback.receive(null);
            }
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getParameterString(Map<String, String> map) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (buf.length() != 0) {
                buf.append("&");
            }
            buf.append((Object)key);
            buf.append("=");
            buf.append((Object)value);
        }
        return buf.toString();
    }

    public static String getUrlEncodedParameterString(Map<String, String> map, String charset) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (buf.length() != 0) {
                buf.append("&");
            }
            try {
                value = URLEncoder.encode(value, charset);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append((Object)key);
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }

    public static SKMMap<String, String> getParameterMap(String string) {
        String[] tokens = string.split("&");
        SKMMap<String, String> map = new SKMMap<String, String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] keyValue = tokens[i].split("=");
            if (keyValue.length != 2) continue;
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public static SKMMap<String, String> getUrlDecodedParameterMap(String string, String charset) {
        String[] tokens = string.split("&");
        SKMMap<String, String> map = new SKMMap<String, String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] keyValue = tokens[i].split("=");
            if (keyValue.length != 2) continue;
            try {
                keyValue[1] = URLDecoder.decode(keyValue[1], charset);
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public static String getStateMessage(int state) {
        SKMI18N i18n = new SKMI18N(RESOURCE_STATE_MESSAGE);
        switch (state) {
            case 0: {
                return i18n.getString("ERROR_UNDER_RECORD");
            }
            case -1: {
                return i18n.getString("ERROR_RANK_OUT");
            }
            case -2: {
                return i18n.getString("ERROR_CONNECT_DB");
            }
            case -3: {
                return i18n.getString("ERROR_CONNECTION");
            }
            case -4: {
                return i18n.getString("ERROR_CERT_FAILED");
            }
            case -5: {
                return i18n.getString("ERROR_DUP_NAME");
            }
            case -6: {
                return i18n.getString("ERROR_DECRYPTION");
            }
            case -7: {
                return i18n.getString("ERROR_DATA_FORMAT");
            }
            case -8: {
                return i18n.getString("ERROR_NO_DATA");
            }
            case -9: {
                return i18n.getString("ERROR_INVALID_SESSION");
            }
            case -10: {
                return i18n.getString("ERROR_INTERNET_CONNECTION");
            }
            case -50: {
                return i18n.getString("STATE_MY_TIME_UP");
            }
            case -51: {
                return i18n.getString("STATE_OPPONENT_TIME_UP");
            }
            case -52: {
                return i18n.getString("STATE_MY_ESCAPE");
            }
            case -53: {
                return i18n.getString("STATE_OPPONENT_ESCAPE");
            }
            case -54: {
                return i18n.getString("STATE_MY_TAP_OUT");
            }
            case -55: {
                return i18n.getString("STATE_OPPONENT_TAP_OUT");
            }
            case -80: {
                return i18n.getString("RESULT_YOU_WIN");
            }
            case -81: {
                return i18n.getString("RESULT_YOU_LOSE");
            }
            case -82: {
                return i18n.getString("RESULT_YOU_DEFAULT_WIN");
            }
            case -83: {
                return i18n.getString("RESULT_YOU_DEFAULT_LOSE");
            }
            case -98: {
                return i18n.getString("ERROR_INVALID");
            }
            case -99: {
                return i18n.getString("NO_ERROR");
            }
        }
        return "";
    }

    public static String getStateTitle(int state) {
        SKMI18N i18n = new SKMI18N(RESOURCE_STATE_MESSAGE);
        switch (state) {
            case 0: {
                return i18n.getString("TITLE_ERROR_UNDER_RECORD");
            }
            case -1: {
                return i18n.getString("TITLE_ERROR_RANK_OUT");
            }
            case -2: {
                return i18n.getString("TITLE_ERROR_CONNECT_DB");
            }
            case -3: {
                return i18n.getString("TITLE_ERROR_CONNECTION");
            }
            case -4: {
                return i18n.getString("TITLE_ERROR_CERT_FAILED");
            }
            case -5: {
                return i18n.getString("TITLE_ERROR_DUP_NAME");
            }
            case -6: {
                return i18n.getString("TITLE_ERROR_DECRYPTION");
            }
            case -7: {
                return i18n.getString("TITLE_ERROR_DATA_FORMAT");
            }
            case -8: {
                return i18n.getString("TITLE_ERROR_NO_DATA");
            }
            case -9: {
                return i18n.getString("TITLE_ERROR_INVALID_SESSION");
            }
            case -10: {
                return i18n.getString("TITLE_ERROR_INTERNET_CONNECTION");
            }
            case -50: {
                return i18n.getString("TITLE_STATE_MY_TIME_UP");
            }
            case -51: {
                return i18n.getString("TITLE_STATE_OPPONENT_TIME_UP");
            }
            case -52: {
                return i18n.getString("TITLE_STATE_MY_ESCAPE");
            }
            case -53: {
                return i18n.getString("TITLE_STATE_OPPONENT_ESCAPE");
            }
            case -54: {
                return i18n.getString("TITLE_STATE_MY_TAP_OUT");
            }
            case -55: {
                return i18n.getString("TITLE_STATE_OPPONENT_TAP_OUT");
            }
            case -80: {
                return i18n.getString("TITLE_RESULT_YOU_WIN");
            }
            case -81: {
                return i18n.getString("TITLE_RESULT_YOU_LOSE");
            }
            case -82: {
                return i18n.getString("TITLE_RESULT_YOU_DEFAULT_WIN");
            }
            case -83: {
                return i18n.getString("TITLE_RESULT_YOU_DEFAULT_LOSE");
            }
            case -98: {
                return i18n.getString("TITLE_ERROR_INVALID");
            }
            case -99: {
                return i18n.getString("TITLE_NO_ERROR");
            }
        }
        return "";
    }

    public static String getParameterString(SKMMap<String, String> map) {
        StringBuilder buf = new StringBuilder();
        Object[] keys = map.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = map.get(key);
            if (buf.length() != 0) {
                buf.append("&");
            }
            buf.append(key);
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }

    public static String getUrlEncodedParameterString(SKMMap<String, String> map, String charset) {
        StringBuilder buf = new StringBuilder();
        Object[] keys = map.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = map.get(key);
            if (buf.length() != 0) {
                buf.append("&");
            }
            try {
                value = URLEncoder.encode(value, charset);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append(key);
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }
}

