/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Component;
import java.awt.Image;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMChangeFilter;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMImageFilter;
import jp.ne.sk_mine.util.andr_applet.SKMSwapFilter;
import jp.ne.sk_mine.util.image.ImageFuncs;
import jp.ne.sk_mine.util.image.ImageLoader;

public final class SKMImageFuncs {
    public static final int REVERSE_HORIZONTAL = 0;
    public static final int REVERSE_VERTICAL = 1;
    public static final int ROTATE_90 = 0;
    public static final int ROTATE_180 = 1;
    public static final int ROTATE_270 = 2;

    public static SKMImage getFilteredImage(SKMImage inImage, SKMImageFilter filter, Component forWaitingImageLoading) {
        SKMImage ret = new SKMImage(ImageFuncs.getFilteredImage(inImage.getImage(), filter.getFilter(), forWaitingImageLoading));
        ret.resize(inImage.getWidth(), inImage.getHeight());
        return ret;
    }

    public static SKMImage getReversedImage(SKMImage image, int reverseDir) {
        SKMImage ret = new SKMImage(ImageFuncs.getReversedImage(image.getImage(), reverseDir));
        ret.resize(image.getWidth(), image.getHeight());
        return ret;
    }

    public static SKMImage getRotatedImage(SKMImage image, int rotate) {
        SKMImage ret = new SKMImage(ImageFuncs.getRotatedImage(image.getImage(), rotate));
        ret.resize(image.getWidth(), image.getHeight());
        return ret;
    }

    public static SKMImage getRotatedImageByRadian(SKMImage image, double rad, SKMColor bgColor, SKMColor transparentColor, Component forCreateImage) {
        SKMImage ret = new SKMImage(ImageFuncs.getRotatedImageByRadian(image.getImage(), rad, bgColor.getColor(), transparentColor.getColor(), forCreateImage));
        ret.resize(image.getWidth(), image.getHeight());
        return ret;
    }

    public static SKMImage getFilteredImage(SKMImage inImage, SKMImageFilter filter) {
        SKMImage ret = new SKMImage(ImageFuncs.getFilteredImage(inImage.getImage(), filter.getFilter(), (Component)SKM.getManager()));
        ret.resize(inImage.getWidth(), inImage.getHeight());
        return ret;
    }

    public static SKMImage[] getFilteredImage(SKMImage[] inImages, SKMImageFilter filter, Component forWaitingImageLoading) {
        Image[] in = new Image[inImages.length];
        for (int i = 0; i < inImages.length; ++i) {
            in[i] = inImages[i].getImage();
        }
        Image[] out = ImageFuncs.getFilteredImage(in, filter.getFilter(), forWaitingImageLoading);
        SKMImage[] ret = new SKMImage[out.length];
        for (int i = 0; i < out.length; ++i) {
            ret[i] = new SKMImage(out[i]);
            ret[i].resize(inImages[i].getWidth(), inImages[i].getHeight());
        }
        return ret;
    }

    public static SKMImage[] getFilteredImage(SKMImage[] inImages, SKMImageFilter filter) {
        Image[] in = new Image[inImages.length];
        for (int i = 0; i < inImages.length; ++i) {
            in[i] = inImages[i].getImage();
        }
        Image[] out = ImageFuncs.getFilteredImage(in, filter.getFilter());
        SKMImage[] ret = new SKMImage[out.length];
        for (int i = 0; i < out.length; ++i) {
            ret[i] = new SKMImage(out[i]);
            ret[i].resize(inImages[i].getWidth(), inImages[i].getHeight());
        }
        return ret;
    }

    public static SKMImage cropImage(SKMImage image, int x, int y, int w, int h) {
        return new SKMImage(ImageLoader.getInstance().cropImage(image.getImage(), x, y, w, h));
    }

    public static SKMImage getSwappedImage(SKMImage inImage, SKMColor[] preColors, SKMColor[] postColors, SKMColor[] defaultColors) {
        if (preColors == null || postColors == null || preColors.length != postColors.length) {
            System.out.println("Error: SKMImageFuncs.getSwappedImage(): invalid arguments.");
            return null;
        }
        block0: for (int i = postColors.length - 1; 0 <= i; --i) {
            for (int j = defaultColors.length - 1; 0 <= j; --j) {
                if (!postColors[i].equals(defaultColors[j])) continue;
                int red = 254;
                if (postColors[i].getRed() != 255) {
                    red = postColors[i].getRed() + 1;
                }
                postColors[i] = new SKMColor(red, postColors[i].getGreen(), postColors[i].getBlue());
                continue block0;
            }
        }
        int[] color1s = new int[preColors.length];
        int[] color2s = new int[postColors.length];
        for (int i = preColors.length - 1; 0 <= i; --i) {
            color1s[i] = preColors[i].getRGB();
            color2s[i] = postColors[i].getRGB();
        }
        return SKMImageFuncs.getFilteredImage(inImage, (SKMImageFilter)new SKMSwapFilter(color1s, color2s));
    }

    public static SKMImage[] getSwappedImages(SKMImage[] inImages, SKMColor[] preColors, SKMColor[] postColors, SKMColor[] defaultColors) {
        SKMImage[] ret = new SKMImage[inImages.length];
        for (int i = inImages.length - 1; 0 <= i; --i) {
            ret[i] = SKMImageFuncs.getSwappedImage(inImages[i], preColors, postColors, defaultColors);
        }
        return ret;
    }

    public static SKMImage getChangedImage(SKMImage inImage, SKMColor[] preColors, SKMColor[] postColors, SKMColor[] defaultColors) {
        if (preColors == null || postColors == null || preColors.length != postColors.length) {
            System.out.println("Error: SKMImageFuncs.getChangedImage(): invalid arguments.");
            return null;
        }
        block0: for (int i = postColors.length - 1; 0 <= i; --i) {
            for (int j = defaultColors.length - 1; 0 <= j; --j) {
                if (!postColors[i].equals(defaultColors[j])) continue;
                int red = 254;
                if (postColors[i].getRed() != 255) {
                    red = postColors[i].getRed() + 1;
                }
                postColors[i] = new SKMColor(red, postColors[i].getGreen(), postColors[i].getBlue());
                continue block0;
            }
        }
        int[] color1s = new int[preColors.length];
        int[] color2s = new int[postColors.length];
        for (int i = preColors.length - 1; 0 <= i; --i) {
            color1s[i] = preColors[i].getRGB();
            color2s[i] = postColors[i].getRGB();
        }
        return SKMImageFuncs.getFilteredImage(inImage, (SKMImageFilter)new SKMChangeFilter(color1s, color2s));
    }

    public static SKMImage[] getChangedImages(SKMImage[] inImages, SKMColor[] preColors, SKMColor[] postColors, SKMColor[] defaultColors) {
        SKMImage[] ret = new SKMImage[inImages.length];
        for (int i = inImages.length - 1; 0 <= i; --i) {
            ret[i] = SKMImageFuncs.getChangedImage(inImages[i], preColors, postColors, defaultColors);
        }
        return ret;
    }

    private SKMImageFuncs() {
    }
}

