/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.ButtonSelectable;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMButtonGroup;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;

public class SKMToggleButton
extends SKMButton
implements ButtonSelectable {
    private boolean mIsSelected;
    private SKMColor mSelectedColor;
    private SKMColor mNotSelectedColor;
    private SKMImage mSelectedImage;
    private SKMImage mNotSelectedImage;
    private SKMButtonGroup mGroup;

    public SKMToggleButton(String text, int x, int y, boolean isCenter, SKMFont font, SKMGraphics g) {
        super(text, x, y, isCenter, font, g);
    }

    public SKMToggleButton(String text, int x, int y, boolean isCenter) {
        this(text, x, y, isCenter, null, isCenter ? SKM.getGraphics() : null);
    }

    public SKMToggleButton(SKMImage notSelectedImage, SKMImage selectedImage) {
        this(notSelectedImage, selectedImage, -100, -100, false);
    }

    public SKMToggleButton(SKMImage notSelectedImage, SKMImage selectedImage, int x, int y, boolean isCenter) {
        super(notSelectedImage, x, y, isCenter);
        this.mNotSelectedImage = notSelectedImage;
        this.mSelectedImage = selectedImage;
    }

    public void setColors(SKMColor notSelected, SKMColor selected) {
        this.mNotSelectedColor = notSelected;
        this.mSelectedColor = selected;
    }

    @Override
    public void setSelected(boolean f) {
        this.mIsSelected = f;
        if (f && this.mGroup != null) {
            this.mGroup.adjustState(this);
        }
    }

    @Override
    public boolean isSelected() {
        return this.mIsSelected;
    }

    @Override
    public void setGroup(SKMButtonGroup group) {
        this.mGroup = group;
    }

    @Override
    public boolean isHit(double x, double y, boolean isPress, boolean isJudgeOnly) {
        boolean ret = super.isHit(x, y, isPress, isJudgeOnly);
        if (isPress && ret) {
            this.setSelected(!this.isSelected());
        }
        return ret;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        this.setTextColor(this.mIsSelected ? this.mSelectedColor : this.mNotSelectedColor);
        if (this.mSelectedImage != null) {
            this.setImage(this.mIsSelected ? this.mSelectedImage : this.mNotSelectedImage);
        }
        super.myPaint(g);
        if (this.mIsSelected && this.mNotSelectedImage != null && this.mSelectedImage == null) {
            this.drawSelectedCover(g);
        }
    }

    protected void drawSelectedCover(SKMGraphics g) {
        if (this.mIsDownOnPressed && this.mIsPressed) {
            this.mY += this.mPressedDY;
        }
        SKMColor coverColor = this.mSelectedColor == null ? new SKMColor(0, 0, 0, 80) : this.mSelectedColor;
        g.setColor(coverColor);
        g.fillRect(this.mX, this.mY, this.mNotSelectedImage.getWidth(), this.mNotSelectedImage.getHeight());
        g.fillRect(this.mX - this.mPadW, this.mY - this.mPadH, this.mWidth + 2 * this.mPadW, this.mHeight + 2 * this.mPadH);
    }
}

