/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;

public class FrameButton
extends SKMButton {
    public static final SKMFont sFont = new SKMFont(SKMFont.SERIF, SKMFont.BOLD, 18);
    public static final SKMColor sMouseOverColor = new SKMColor(240, 170, 120);

    public FrameButton(String text) {
        this(text, 0, 0, sFont);
    }

    public FrameButton(String text, SKMFont font) {
        this(text, 0, 0, font);
    }

    public FrameButton(String text, int centerX, int centerY) {
        this(text, centerX, centerY, sFont);
    }

    public FrameButton(String text, int centerX, int centerY, SKMFont font) {
        super(text, centerX, centerY, true, font, SKM.getGraphics());
        this.setPadSize(20, 10);
        this.setTextColor(SKMColor.BLACK);
        this.setDrawFrame(true);
        this.setFrameColor(this.getTextColor());
        this.setFrameColorOnMouseOver(sMouseOverColor);
    }

    public FrameButton(SKMImage normalImage) {
        this(normalImage, 0, 0);
    }

    public FrameButton(SKMImage normalImage, int centerX, int centerY) {
        super(normalImage, centerX, centerY, true);
        this.setPadSize(0, 0);
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        super.myPaint(g);
        g.setColor(this.mIsMouseOver ? SKMColor.ORANGE : this.getTextColor());
        this.paintRoundFrame(g);
    }
}

