/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.image.RGBImageFilter;

public final class RateFilter
extends RGBImageFilter {
    private final double rRate_;
    private final double gRate_;
    private final double bRate_;

    public RateFilter() {
        this(0.7);
    }

    public RateFilter(double rate) {
        this(rate, rate, rate);
    }

    public RateFilter(double rRate, double gRate, double bRate) {
        this.canFilterIndexColorModel = true;
        if (rRate < 0.0) {
            rRate = 0.0;
        }
        if (gRate < 0.0) {
            gRate = 0.0;
        }
        if (bRate < 0.0) {
            bRate = 0.0;
        }
        this.rRate_ = rRate;
        this.gRate_ = gRate;
        this.bRate_ = bRate;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int a = (rgb & 0xFF000000) >> 24;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        if ((r = (int)(this.rRate_ * (double)r)) > 255) {
            r = 255;
        }
        if ((g = (int)(this.gRate_ * (double)g)) > 255) {
            g = 255;
        }
        if ((b = (int)(this.bRate_ * (double)b)) > 255) {
            b = 255;
        }
        return (a << 24) + (r << 16) + (g << 8) + b;
    }
}

