/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.util.BitSet;
import jp.ne.sk_mine.util.andr_applet.SKMArray;

public class SKMCombination<T> {
    private int mTotal;
    private BitSet mBitSet;
    private T[] mItems;
    private Object[] mArray;

    public SKMCombination(SKMArray<T> items, int number) {
        this(items.toArray(), number);
    }

    public SKMCombination(T[] items, int number) {
        this.mItems = items;
        this.mTotal = items.length;
        this.mArray = new Object[number];
        this.mBitSet = new BitSet(this.mTotal + 1);
        for (int i = 0; i < number; ++i) {
            this.mBitSet.set(i);
        }
    }

    public boolean hasNext() {
        return !this.mBitSet.get(this.mTotal);
    }

    private int findOne(BitSet bitSet) {
        for (int i = 0; i <= this.mTotal; ++i) {
            if (!bitSet.get(i)) continue;
            return i;
        }
        return -1;
    }

    private int increment(BitSet bitSet, int n) {
        int a = 0;
        while (bitSet.get(n)) {
            bitSet.clear(n);
            ++n;
            ++a;
        }
        bitSet.set(n);
        return a;
    }

    public Object[] next() {
        int k = 0;
        for (int i = 0; i <= this.mTotal; ++i) {
            if (!this.mBitSet.get(i)) continue;
            this.mArray[k++] = this.mItems[i];
        }
        int u = this.increment(this.mBitSet, this.findOne(this.mBitSet)) - 1;
        for (int i = 0; i < u; ++i) {
            this.mBitSet.set(i);
        }
        return this.mArray;
    }
}

