/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.GameCharacter;
import jp.ne.sk_mine.util.andr_applet.game.ViewCamera;

public class ImageObject
extends GameCharacter {
    private boolean mIsGroundY;
    private boolean mIsGroundUp;
    private boolean mIsVerticallyReversed;
    private boolean mIsHorizontallyReversed;
    private boolean mIsFar;
    private double mGroundY;
    private double mFarCoef;
    private double mRotRad;
    private double mRotDRad;
    protected SKMImage mImage;

    public ImageObject(double x, double y, boolean isGroundY, SKMImage image) {
        super(x, y, 0);
        this.mIsGroundY = isGroundY;
        this.mImage = image;
        this.mIsNotDieOut = true;
        this.mSizeW = this.mImage.getWidth();
        this.mSizeH = this.mImage.getHeight();
        if (isGroundY) {
            this.mGroundY = y;
            this.setY(y - (double)SKMUtil.toInt(this.mSizeH / 2));
        }
    }

    public void setHorizontallyReversed(boolean f) {
        this.mIsHorizontallyReversed = f;
    }

    public boolean isHorizontallyReversed() {
        return this.mIsHorizontallyReversed;
    }

    public void setVerticallyReversed(boolean f) {
        this.mIsVerticallyReversed = f;
    }

    public boolean isVerticallyReversed() {
        return this.mIsVerticallyReversed;
    }

    public void setGroundUp(boolean f) {
        if (f != this.mIsGroundUp) {
            if (this.mIsGroundUp) {
                this.setY(this.mGroundY - (double)SKMUtil.toInt(this.mSizeH / 2));
            } else {
                this.setY(this.mGroundY + (double)SKMUtil.toInt(this.mSizeH / 2));
            }
        }
        this.mIsGroundUp = f;
    }

    public void setScale(double scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScaleX(double scale) {
        this.mSizeW = SKMUtil.toInt(scale * (double)this.mImage.getWidth());
        this.mSizeH = this.mImage.getHeight();
        this.mImage.resize(this.mSizeW, this.mSizeH);
    }

    public void setScaleY(double scale) {
        this.mSizeW = this.mImage.getWidth();
        this.mSizeH = SKMUtil.toInt(scale * (double)this.mImage.getHeight());
        this.mImage.resize(this.mSizeW, this.mSizeH);
        if (this.mIsGroundY) {
            if (this.mIsGroundUp) {
                this.setY(this.mGroundY + (double)SKMUtil.toInt(this.mSizeH / 2));
            } else {
                this.setY(this.mGroundY - (double)SKMUtil.toInt(this.mSizeH / 2));
            }
        }
    }

    public void setRotRad(double rotRad) {
        this.mRotRad = rotRad;
    }

    public void setRotDRad(double rotDRad) {
        this.mRotDRad = rotDRad;
    }

    public void setAlpha(int alpha) {
        this.mImage.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.mImage.getAlpha();
    }

    public void setFar(boolean f, double farCoef) {
        this.mIsFar = f;
        this.mFarCoef = farCoef;
    }

    @Override
    protected void myMove() {
        this.mRotRad += this.mRotDRad;
    }

    @Override
    public boolean isOut() {
        ViewCamera camera;
        int tmpX = this.mX;
        if (this.mIsFar && (camera = SKM.getManager().getViewCamera()) != null) {
            this.setX((double)this.mX + this.mFarCoef * (camera.getX() - (double)this.mDrawX));
        }
        boolean ret = super.isOut();
        if (this.mIsFar) {
            this.setX(tmpX);
        }
        return ret;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        double rotRad;
        if (this.mIsFar) {
            g.saveTransform();
            ViewCamera camera = SKM.getManager().getViewCamera();
            if (camera != null) {
                g.translate(this.mFarCoef * (camera.getX() - (double)this.mDrawX), 0.0);
            }
        }
        if ((rotRad = this.mRotRad) != 0.0) {
            g.saveTransform();
            g.rotate(rotRad, this.mDrawX, this.mDrawY);
        }
        g.drawCenteringImage(this.mImage, this.mDrawX, this.mDrawY, this.mIsHorizontallyReversed, this.mIsVerticallyReversed);
        if (rotRad != 0.0) {
            g.restoreTransform();
        }
        if (this.mIsFar) {
            g.restoreTransform();
        }
    }
}

