/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SelectCallback;

public class SKMSelectBox
extends SKMUI {
    private static SKMFont sDefaultFont;
    private JComboBox<String> mComboBox;
    private SelectCallback mCallback;

    public static void setDefaultFont(SKMFont font) {
        sDefaultFont = font;
    }

    public SKMSelectBox() {
        this.mComboBox = new JComboBox();
        this.initCommon();
    }

    public SKMSelectBox(String[] items) {
        this.mComboBox = new JComboBox<String>(items);
        this.initCommon();
    }

    public SKMSelectBox(SKMArray<String> array) {
        String[] items = new String[array.size()];
        for (int i = array.size() - 1; 0 <= i; --i) {
            items[i] = array.get(i);
        }
        this.mComboBox = new JComboBox<String>(items);
        this.initCommon();
    }

    private final void initCommon() {
        this.setXY(-100, -100);
        if (sDefaultFont != null) {
            this.mComboBox.setFont(sDefaultFont.getFont());
        }
        this.mComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1 && SKMSelectBox.this.mCallback != null) {
                    SKMSelectBox.this.mCallback.selected((String)SKMSelectBox.this.mComboBox.getSelectedItem(), SKMSelectBox.this.mComboBox.getSelectedIndex());
                }
            }
        });
        this.setImpl(this.mComboBox);
    }

    public void addItem(String item) {
        this.mComboBox.addItem(item);
    }

    public void removeItem(String item) {
        this.mComboBox.removeItem(item);
    }

    public void removeAllItems() {
        this.mComboBox.removeAllItems();
    }

    public int getSelectedIndex() {
        return this.mComboBox.getSelectedIndex();
    }

    public String getSelectedItem() {
        return (String)this.mComboBox.getSelectedItem();
    }

    public void select(int index) {
        this.mComboBox.setSelectedIndex(index);
    }

    public void selectItem(String item) {
        this.mComboBox.setSelectedItem(item);
    }

    public void setCallback(SelectCallback callback) {
        this.mCallback = callback;
    }

    public void setFont(SKMFont font) {
        this.mComboBox.setFont(font.getFont());
    }
}

