/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import jp.ne.sk_mine.util.andr_applet.ButtonCallback;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMMineUtil;
import jp.ne.sk_mine.util.andr_applet.SKMRuntimeFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMWindowFuncs;
import jp.ne.sk_mine.util.ui.ExJTextField;

public class LoginInfoDialog
extends JDialog
implements ActionListener {
    private String mTitle;
    private String mInputUserId;
    private String mInputPassword;
    private ExJTextField mUidTf;
    private JPasswordField mPwdTf;
    private JLabel mMainLabel;
    private JPanel mMainLabelPanel;
    private JButton mOkButton;
    private JButton mRegisterButton;
    private JButton mCancelButton;
    private ButtonCallback mOkButtonCallback;
    private ButtonCallback mCancelButtonCallback;

    public LoginInfoDialog() {
        super((Frame)SKM.getManager().getFrame(), true);
        SKMI18N i18nCommon = SKM.getI18NCommon();
        this.mTitle = i18nCommon.getString("login_button");
        this.setTitle(this.mTitle);
        this.mMainLabelPanel = new JPanel();
        this.mMainLabelPanel.setLayout(new BorderLayout());
        String message = i18nCommon.getString("login_info_label");
        this.mMainLabel = new JLabel(message);
        this.mMainLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mMainLabelPanel.add((Component)this.mMainLabel, "North");
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel(i18nCommon.getString("codename")));
        labelPanel.add(new JLabel(i18nCommon.getString("password")));
        JPanel inputPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.mUidTf = new ExJTextField(SKM.getManager().getStringSetting("user_id", SKM.getManager().getStringSetting("user_id", "")), 16);
        this.mUidTf.addActionListener(this);
        this.mUidTf.setMaxLength(16);
        inputPanel.add(this.mUidTf);
        this.mPwdTf = new JPasswordField(SKMMineUtil.decryptSimple(SKM.getManager().getStringSetting("password", "")), 16);
        this.mPwdTf.setEchoChar('*');
        this.mPwdTf.addActionListener(this);
        inputPanel.add(this.mPwdTf);
        JPanel centerPanel = new JPanel(new FlowLayout());
        centerPanel.add(labelPanel);
        centerPanel.add(inputPanel);
        this.mMainLabelPanel.add((Component)centerPanel, "Center");
        this.mOkButton = new JButton(i18nCommon.getString("login_button"));
        this.mOkButton.addActionListener(this);
        this.mRegisterButton = new JButton(i18nCommon.getString("register_button"));
        this.mRegisterButton.addActionListener(this);
        this.mCancelButton = new JButton(i18nCommon.getString("cancel"));
        this.mCancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.mOkButton);
        buttonPanel.add(this.mRegisterButton);
        buttonPanel.add(this.mCancelButton);
        this.mMainLabelPanel.add((Component)buttonPanel, "South");
        this.resizeFrame();
        SKMWindowFuncs.centering(this, SKM.getManager().getFrame());
    }

    public void setOkButtonCallback(ButtonCallback callback) {
        this.mOkButtonCallback = callback;
    }

    public void setCancelButtonCallback(ButtonCallback callback) {
        this.mCancelButtonCallback = callback;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.mCancelButton) {
            this.dispose();
            if (this.mCancelButtonCallback != null) {
                this.mCancelButtonCallback.pressed();
            }
        } else if (source == this.mUidTf || source == this.mPwdTf || source == this.mOkButton) {
            String uid = this.mUidTf.getText();
            char[] pwdChars = this.mPwdTf.getPassword();
            String pwd = pwdChars == null || pwdChars.length == 0 ? "" : new String(pwdChars);
            SKMI18N i18nCommon = SKM.getI18NCommon();
            if (uid == null || uid.length() == 0) {
                this.mMainLabel.setText(i18nCommon.getString("error_no_codename"));
                this.resizeFrame();
                return;
            }
            if (SKMMineUtil.includesInvalidLetter(uid) || SKMMineUtil.includesInvalidLetter(pwd)) {
                this.mMainLabel.setText(i18nCommon.getString("error_invalid_letter"));
                this.resizeFrame();
                return;
            }
            if (uid.indexOf("ttp://") != -1 || uid.indexOf("ttps://") != -1) {
                this.mMainLabel.setText(i18nCommon.getString("error_include_url"));
                this.resizeFrame();
                return;
            }
            int len = uid.length();
            boolean onlySpace = true;
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < len && i < 16; ++i) {
                char c = uid.charAt(i);
                if (c != ' ') {
                    onlySpace = false;
                }
                tmp.append(c);
            }
            if (onlySpace) {
                this.mMainLabel.setText(i18nCommon.getString("error_space_name"));
                this.resizeFrame();
                return;
            }
            String userId = tmp.toString();
            if (16 < userId.length()) {
                this.mMainLabel.setText(i18nCommon.getString("error_too_long_name"));
                this.resizeFrame();
                return;
            }
            if (16 < pwd.length()) {
                this.mMainLabel.setText(i18nCommon.getString("error_too_long_password"));
                this.resizeFrame();
                return;
            }
            this.mInputUserId = userId;
            this.mInputPassword = pwd;
            SKM.getManager().setSetting("user_id", userId);
            SKM.getManager().setSetting("password", SKMMineUtil.encryptSimple(pwd));
            if (this.mOkButtonCallback != null) {
                this.mOkButtonCallback.pressed();
            }
        } else if (source == this.mRegisterButton) {
            SKMRuntimeFuncs.openBrowser(SKM.getManager().getRegisterUserUrl());
        }
    }

    public String getUserId() {
        return this.mInputUserId;
    }

    public String getPassword() {
        return this.mInputPassword;
    }

    private final void resizeFrame() {
        this.remove(this.mMainLabelPanel);
        this.getContentPane().add((Component)this.mMainLabelPanel, "North");
        this.pack();
    }
}

