/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Color;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMColor {
    public static SKMColor WHITE = new SKMColor(255, 255, 255);
    public static SKMColor BLACK = new SKMColor(0, 0, 0);
    public static SKMColor GRAY = new SKMColor(128, 128, 128);
    public static SKMColor LIGHT_GRAY = new SKMColor(192, 192, 192);
    public static SKMColor DARK_GRAY = new SKMColor(64, 64, 64);
    public static SKMColor RED = new SKMColor(255, 0, 0);
    public static SKMColor YELLOW = new SKMColor(255, 255, 0);
    public static SKMColor GREEN = new SKMColor(0, 255, 0);
    public static SKMColor BLUE = new SKMColor(0, 0, 255);
    public static SKMColor ORANGE = new SKMColor(255, 200, 0);
    public static SKMColor PINK = new SKMColor(255, 175, 175);
    public static SKMColor CYAN = new SKMColor(0, 255, 255);
    private final Color mColor;

    public static SKMColor getAddedColor(SKMColor color, int dRed, int dGreen, int dBlue) {
        int red = color.getRed() + dRed;
        int green = color.getGreen() + dGreen;
        int blue = color.getBlue() + dBlue;
        if (red < 0) {
            red = 0;
        } else if (255 < red) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (255 < green) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (255 < blue) {
            blue = 255;
        }
        return new SKMColor(red, green, blue);
    }

    public static SKMColor getReplacedColor(SKMColor color, int red, int green, int blue, int alpha) {
        if (red == -1) {
            red = color.getRed();
        }
        if (green == -1) {
            green = color.getGreen();
        }
        if (blue == -1) {
            blue = color.getBlue();
        }
        if (alpha == -1) {
            alpha = color.getAlpha();
        }
        return new SKMColor(red, green, blue, alpha);
    }

    public static SKMColor getRateColor(SKMColor color, double redRate, double greenRate, double blueRate) {
        int red = SKMUtil.toInt(redRate * (double)color.getRed());
        if (red < 0) {
            red = 0;
        } else if (255 < red) {
            red = 255;
        }
        int green = SKMUtil.toInt(greenRate * (double)color.getGreen());
        if (green < 0) {
            green = 0;
        } else if (255 < green) {
            green = 255;
        }
        int blue = SKMUtil.toInt(blueRate * (double)color.getBlue());
        if (blue < 0) {
            blue = 0;
        } else if (255 < blue) {
            blue = 255;
        }
        return new SKMColor(red, green, blue, color.getAlpha());
    }

    public static SKMColor getAlphaColor(SKMColor color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        return new SKMColor(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public SKMColor(int red, int green, int blue) {
        this.mColor = new Color(red, green, blue);
    }

    public SKMColor(int red, int green, int blue, int alpha) {
        this.mColor = new Color(red, green, blue, alpha);
    }

    public SKMColor(Color color) {
        this.mColor = color;
    }

    public SKMColor(int color) {
        int red = (color & 0xFF0000) >>> 16;
        int green = (color & 0xFF00) >>> 8;
        int blue = color & 0xFF;
        int alpha = (color & 0xFF000000) >>> 24;
        this.mColor = new Color(red, green, blue, alpha);
    }

    public Color getColor() {
        return this.mColor;
    }

    public int getRed() {
        return this.mColor.getRed();
    }

    public int getGreen() {
        return this.mColor.getGreen();
    }

    public int getBlue() {
        return this.mColor.getBlue();
    }

    public int getAlpha() {
        return this.mColor.getAlpha();
    }

    public int getRGB() {
        return this.mColor.getRGB();
    }

    public SKMColor brighter() {
        int i = this.getRed();
        int j = this.getGreen();
        int k = this.getBlue();
        int l = 3;
        if (i == 0 && j == 0 && k == 0) {
            return new SKMColor(l, l, l);
        }
        if (i > 0 && i < l) {
            i = l;
        }
        if (j > 0 && j < l) {
            j = l;
        }
        if (k > 0 && k < l) {
            k = l;
        }
        return new SKMColor(Math.min((int)((double)i / 0.7), 255), Math.min((int)((double)j / 0.7), 255), Math.min((int)((double)k / 0.7), 255), this.getAlpha());
    }

    public SKMColor darker() {
        return new SKMColor(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0), this.getAlpha());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SKMColor)) {
            return false;
        }
        SKMColor color = (SKMColor)o;
        return this.mColor.getRed() == color.mColor.getRed() && this.mColor.getGreen() == color.mColor.getGreen() && this.mColor.getBlue() == color.mColor.getBlue() && this.mColor.getAlpha() == color.mColor.getAlpha();
    }
}

