/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class SKMFlowString {
    public int x;
    public int y;
    protected double realX;
    protected double realY;
    protected int R;
    protected int G;
    protected int B;
    protected int A;
    protected int RR;
    protected int GG;
    protected int BB;
    protected int AA;
    protected int Rlim;
    protected int Glim;
    protected int Blim;
    protected int Alim;
    protected int move_max;
    public int cnt;
    protected double speed_x;
    protected double speed_y;
    protected Font font;
    protected final String str;
    protected int len;
    protected char[] chr;
    protected int shade_xx = 2;
    protected int shade_yy = 2;
    protected boolean mIsCentering;
    protected boolean tate_FLG;
    protected boolean grad_FLG;
    protected boolean rainbow_FLG;
    protected boolean blink_FLG;
    protected boolean shade_FLG;
    protected Color shade_color;
    protected boolean mIsRounded;
    protected int mRoundOffset;
    protected SKMColor mRoundColor;
    protected boolean blinkChange_FLG;
    protected int blink_lim = 1;

    public SKMFlowString() {
        this(null, null, false, 0, 0);
    }

    public SKMFlowString(SKMFont font, String str, boolean isCentering, int x, int y) {
        this.str = str;
        if (font != null) {
            this.font = font.getFont();
        }
        this.mIsCentering = isCentering;
        this.x = x;
        this.y = y;
        this.realX = x;
        this.realY = y;
        this.move_max = -1;
        this.B = 0;
        this.G = 0;
        this.R = 0;
        this.A = 255;
        this.AA = 15;
        this.BB = 15;
        this.GG = 15;
        this.RR = 15;
        this.Alim = 255;
        this.Blim = 255;
        this.Glim = 255;
        this.Rlim = 255;
        this.grad_FLG = true;
        this.mRoundOffset = 1;
        this.mRoundColor = SKMColor.WHITE;
    }

    public SKMFlowString(SKMFont font, String str, boolean isCentering, int x, int y, double speedX, double speedY, int moveMax) {
        this(font, str, isCentering, x, y);
        this.speed_x = speedX;
        this.speed_y = speedY;
        this.move_max = moveMax;
    }

    public String getString() {
        return this.str;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCount() {
        return this.cnt;
    }

    public int getRed() {
        return this.R;
    }

    public int getGreen() {
        return this.G;
    }

    public int getBlue() {
        return this.B;
    }

    public int getAlpha() {
        return this.A;
    }

    @Deprecated
    public void setXYCenter(int xx, int yy) {
        this.setCenterXY(xx, yy);
    }

    public void setCenterXY(int x, int y) {
        this.x = x;
        this.y = y;
        this.realX = x;
        this.realY = y;
        this.mIsCentering = true;
    }

    public void setCenterX(int x) {
        this.x = x;
        this.realX = x;
        this.mIsCentering = true;
    }

    public void setCenterY(int y) {
        this.y = y;
        this.realY = y;
        this.mIsCentering = true;
    }

    public int getXLength(SKMGraphics g) {
        return this.getXLength(g.getGraphics());
    }

    public int getCenterX(SKMGraphics g) {
        return this.getCenterX(g.getGraphics());
    }

    public int getXLength(Graphics g) {
        FontMetrics fm = this.font != null ? g.getFontMetrics(this.font) : g.getFontMetrics();
        return fm.stringWidth(this.str);
    }

    public int getCenterX(Graphics g) {
        return this.x + (this.getXLength(g) >> 1);
    }

    public int getMoveMax() {
        return this.move_max;
    }

    public void tateOK(boolean flg) {
        this.tate_FLG = flg;
        this.len = this.str.length();
        this.chr = new char[this.len];
        this.str.getChars(0, this.len, this.chr, 0);
    }

    public void gradOK(boolean grad_FLG) {
        this.grad_FLG = grad_FLG;
    }

    public void rainbowOK(boolean rainbow_FLG) {
        this.rainbow_FLG = rainbow_FLG;
        if (rainbow_FLG) {
            this.R = 255;
            this.B = 64;
        }
    }

    public void blinkOK(boolean flg, int blink_lim) {
        this.blink_FLG = true;
        this.blink_lim = blink_lim;
        this.blinkChange_FLG = !flg;
    }

    public void blinkOK(boolean flg) {
        this.blink_FLG = flg;
    }

    public void shadeOK(boolean b) {
        this.shade_FLG = b;
    }

    public void setShadeLocation(int x, int y) {
        this.shade_xx = x;
        this.shade_yy = y;
    }

    public void setShadeColor(SKMColor color) {
        this.shade_color = color.getColor();
    }

    public void setRounded(boolean f) {
        this.mIsRounded = f;
    }

    public void setRoundColor(SKMColor color) {
        this.mRoundColor = color;
    }

    public void setRoundOffset(int offset) {
        this.mRoundOffset = offset;
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
        this.realX = x;
        this.realY = y;
        this.mIsCentering = false;
    }

    public void setX(int x) {
        this.x = x;
        this.realX = x;
        this.mIsCentering = false;
    }

    public void setY(int y) {
        this.y = y;
        this.realY = y;
        this.mIsCentering = false;
    }

    @Deprecated
    public void setSpeed(double spd_x, double spd_y) {
        this.move_max = -1;
        this.speed_x = spd_x;
        this.speed_y = spd_y;
    }

    @Deprecated
    public void setSpeed(double spd_x, double spd_y, int move_max) {
        this.setSpeed(spd_x, spd_y);
        this.setMoveMax(move_max);
    }

    public void setSpeedXY(double speedX, double speedY) {
        this.move_max = -1;
        this.speed_x = speedX;
        this.speed_y = speedY;
    }

    public void setSpeedXY(double spd_x, double spd_y, int move_max) {
        this.setSpeedXY(spd_x, spd_y);
        this.setMoveMax(move_max);
    }

    public void setSpeedX(double speedX) {
        this.move_max = -1;
        this.speed_x = speedX;
    }

    public void setSpeedY(double speedY) {
        this.move_max = -1;
        this.speed_y = speedY;
    }

    public void setSpeedByRadian(double speed, double rad) {
        this.move_max = -1;
        this.speed_x = speed * Math.cos(rad);
        this.speed_y = speed * Math.sin(rad);
    }

    @Deprecated
    public void getSpeed(double spd, double rad) {
        this.speed_x = spd * Math.cos(rad);
        this.speed_y = spd * Math.sin(rad);
    }

    public double getSpeedX() {
        return this.speed_x;
    }

    public double getSpeedY() {
        return this.speed_y;
    }

    public void setColor(SKMColor skmColor) {
        Color color = skmColor.getColor();
        this.setRGB(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public void setRGB(int R, int G, int B) {
        if (0 <= R && R <= 255) {
            this.R = R;
        }
        if (0 <= G && G <= 255) {
            this.G = G;
        }
        if (0 <= B && B <= 255) {
            this.B = B;
        }
    }

    public void setRGB(int R, int G, int B, int A) {
        this.setRGB(R, G, B);
        if (0 <= A && A <= 255) {
            this.A = A;
        }
    }

    public void setRGBGrad(int RR, int GG, int BB) {
        this.RR = RR;
        this.GG = GG;
        this.BB = BB;
    }

    public void setRGBGrad(int RR, int GG, int BB, int AA) {
        this.setRGBGrad(RR, GG, BB);
        this.AA = AA;
    }

    public void setColorLim(SKMColor skmColor) {
        Color color = skmColor.getColor();
        this.setRGBLim(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public void setRGBLim(int Rlim, int Glim, int Blim) {
        if (0 <= Rlim && Rlim <= 255) {
            this.Rlim = Rlim;
            if (this.RR * (Rlim - this.R) < 0) {
                this.RR = -this.RR;
            }
        }
        if (0 <= Glim && Glim <= 255) {
            this.Glim = Glim;
            if (this.GG * (Glim - this.G) < 0) {
                this.GG = -this.GG;
            }
        }
        if (0 <= Blim && Blim <= 255) {
            this.Blim = Blim;
            if (this.BB * (Blim - this.B) < 0) {
                this.BB = -this.BB;
            }
        }
        this.gradOK(true);
    }

    public void setRGBLim(int Rlim, int Glim, int Blim, int Alim) {
        this.setRGBLim(Rlim, Glim, Blim);
        if (0 <= Alim && Alim <= 255) {
            this.Alim = Alim;
            if (this.AA * (Alim - this.A) < 0) {
                this.AA = -this.AA;
            }
        }
    }

    public void setRGBs(int R, int G, int B, int Rlim, int Glim, int Blim, int RR, int GG, int BB) {
        this.setRGB(R, G, B);
        this.setRGBGrad(RR, GG, BB);
        this.setRGBLim(Rlim, Glim, Blim);
    }

    public void setRGBs(int R, int G, int B, int A, int Rlim, int Glim, int Blim, int Alim, int RR, int GG, int BB, int AA) {
        this.setRGB(R, G, B, A);
        this.setRGBGrad(RR, GG, BB, AA);
        this.setRGBLim(Rlim, Glim, Blim, Alim);
    }

    public void setFont(SKMFont font) {
        this.font = font.getFont();
    }

    public SKMFont getFont() {
        return new SKMFont(this.font);
    }

    public void setMoveMax(int a) {
        this.move_max = this.cnt + a;
    }

    public SKMColor getColor() {
        return new SKMColor(new Color(this.R, this.G, this.B, this.A));
    }

    public void move() {
        if (this.move_max < 0 || this.cnt < this.move_max) {
            this.realX += this.speed_x;
            this.realY += this.speed_y;
            this.x = (int)this._round(this.realX);
            this.y = (int)this._round(this.realY);
        }
        if (this.blink_FLG && this.cnt % this.blink_lim == 0) {
            boolean bl = this.blinkChange_FLG = !this.blinkChange_FLG;
        }
        if (this.rainbow_FLG) {
            this.rainbow();
        }
        this.gradColor();
        ++this.cnt;
    }

    protected double _round(double d) {
        return (long)this._floor(d + 0.5);
    }

    protected double _floor(double d) {
        if (d >= 0.0) {
            return (int)d;
        }
        return d * 10.0 % 10.0 == 0.0 ? (double)((int)d) : (double)((int)(d - 1.0));
    }

    public void gradColor() {
        int alpha;
        int blue;
        int green;
        if (!this.grad_FLG) {
            return;
        }
        int red = this.R + this.RR;
        if (red < 0) {
            red = 0;
        } else if (255 < red) {
            red = 255;
        }
        this.R = red;
        if (this.RR * (this.Rlim - this.R) < 0) {
            this.R = this.Rlim;
        }
        if ((green = this.G + this.GG) < 0) {
            green = 0;
        } else if (255 < green) {
            green = 255;
        }
        this.G = green;
        if (this.GG * (this.Glim - this.G) < 0) {
            this.G = this.Glim;
        }
        if ((blue = this.B + this.BB) < 0) {
            blue = 0;
        } else if (255 < blue) {
            blue = 255;
        }
        this.B = blue;
        if (this.BB * (this.Blim - this.B) < 0) {
            this.B = this.Blim;
        }
        if ((alpha = this.A + this.AA) < 0) {
            alpha = 0;
        } else if (255 < alpha) {
            alpha = 255;
        }
        this.A = alpha;
        if (this.AA * (this.Alim - this.A) < 0) {
            this.A = this.Alim;
        }
    }

    public void rainbow() {
        if (this.R == 255 && this.B == 64) {
            this.setRGBLim(255, 255, 0);
        }
        if (this.R == 255 && this.G == 255) {
            this.setRGBLim(64, 255, 0);
        }
        if (this.R == 64 && this.G == 255) {
            this.setRGBLim(0, 255, 128);
        }
        if (this.G == 255 && this.B == 128) {
            this.setRGBLim(0, 64, 255);
        }
        if (this.G == 64 && this.B == 255) {
            this.setRGBLim(255, 0, 255);
        }
        if (this.R == 255 && this.B == 255) {
            this.setRGBLim(255, 0, 64);
        }
    }

    public void paint(SKMGraphics skmg) {
        Graphics2D g = skmg.getGraphics();
        if (this.blink_FLG && !this.blinkChange_FLG) {
            return;
        }
        if (this.font != null) {
            g.setFont(this.font);
        }
        Color c = new Color(this.R, this.G, this.B, this.A);
        if (!this.shade_FLG) {
            g.setColor(c);
        }
        if (this.tate_FLG) {
            int height = g.getFontMetrics().getHeight();
            for (int i = 0; i < this.len; ++i) {
                SKMColor roundColor;
                if (this.shade_FLG) {
                    if (this.shade_color != null) {
                        g.setColor(this.shade_color);
                    } else {
                        g.setColor(c.darker().darker());
                    }
                    if (this.mIsCentering) {
                        skmg.drawCenteringString("" + this.chr[i], this.x + this.shade_xx, this.y + height * i + this.shade_yy);
                    } else {
                        g.drawChars(this.chr, i, 1, this.x + this.shade_xx, this.y + height * i + this.shade_yy);
                    }
                    g.setColor(c);
                }
                if (this.mIsCentering) {
                    if (this.mIsRounded) {
                        roundColor = this.mRoundColor;
                        if (this.A != 255) {
                            roundColor = new SKMColor(roundColor.getRed(), roundColor.getGreen(), roundColor.getBlue(), this.A);
                        }
                        skmg.drawCenteringRoundedString("" + this.chr[i], this.x, this.y + height * i, new SKMColor(this.R, this.G, this.B, this.A), roundColor, this.mRoundOffset);
                        continue;
                    }
                    skmg.drawCenteringString("" + this.chr[i], this.x, this.y + height * i);
                    continue;
                }
                if (this.mIsRounded) {
                    roundColor = this.mRoundColor;
                    if (this.A != 255) {
                        roundColor = new SKMColor(roundColor.getRed(), roundColor.getGreen(), roundColor.getBlue(), this.A);
                    }
                    skmg.drawRoundedString("" + this.chr[i], this.x, this.y + height * i, new SKMColor(this.R, this.G, this.B, this.A), roundColor, this.mRoundOffset);
                    continue;
                }
                g.drawChars(this.chr, i, 1, this.x, this.y + height * i);
            }
        } else {
            if (this.shade_FLG) {
                if (this.shade_color != null) {
                    g.setColor(this.shade_color);
                } else {
                    g.setColor(c.darker().darker());
                }
                if (this.mIsCentering) {
                    skmg.drawCenteringString(this.str, this.x + this.shade_xx, this.y + this.shade_yy);
                } else {
                    ((Graphics)g).drawString(this.str, this.x + this.shade_xx, this.y + this.shade_yy);
                }
                g.setColor(c);
            }
            if (this.mIsCentering) {
                if (this.mIsRounded) {
                    SKMColor roundColor = this.mRoundColor;
                    if (this.A != 255) {
                        roundColor = new SKMColor(roundColor.getRed(), roundColor.getGreen(), roundColor.getBlue(), this.A);
                    }
                    skmg.drawCenteringRoundedString(this.str, this.x, this.y, new SKMColor(this.R, this.G, this.B, this.A), roundColor, this.mRoundOffset);
                } else {
                    skmg.drawCenteringString(this.str, this.x, this.y);
                }
            } else if (this.mIsRounded) {
                SKMColor roundColor = this.mRoundColor;
                if (this.A != 255) {
                    roundColor = new SKMColor(roundColor.getRed(), roundColor.getGreen(), roundColor.getBlue(), this.A);
                }
                skmg.drawRoundedString(this.str, this.x, this.y, new SKMColor(this.R, this.G, this.B, this.A), roundColor, this.mRoundOffset);
            } else {
                ((Graphics)g).drawString(this.str, this.x, this.y);
            }
        }
    }
}

