/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Component;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class SKMUI {
    protected static boolean sIsVisibleDefault = true;
    protected boolean mIsVisible = sIsVisibleDefault;
    protected boolean mIsVisibleInApp = true;
    protected boolean mIsEnabled = true;
    protected boolean mIsPressed;
    protected int mX;
    protected int mY;
    protected int mOffsetX;
    protected int mOffsetY;
    protected int mWidth;
    protected int mHeight;
    protected Component mComponent;

    public static void setDefaultVisibility(boolean f) {
        sIsVisibleDefault = f;
    }

    public static void layoutHorizontalLeft(int leftX, int y, int gapW, SKMUI ... uis) {
        int uiX = leftX;
        for (int i = 0; i < uis.length; ++i) {
            SKMUI ui = uis[i];
            ui.setXY(uiX, y);
            uiX += ui.getWidth() + gapW;
        }
    }

    public static void layoutHorizontalLeft(int leftX, int y, int gapW, SKMArray uis) {
        int uiX = leftX;
        for (int i = 0; i < uis.size(); ++i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setXY(uiX, y);
            uiX += ui.getWidth() + gapW;
        }
    }

    public static void layoutHorizontalRight(int rightX, int y, int gapW, SKMUI ... uis) {
        int uiX = rightX;
        for (int i = uis.length - 1; 0 <= i; --i) {
            SKMUI ui = uis[i];
            ui.setXY(uiX - ui.getWidth(), y);
            uiX -= ui.getWidth() + gapW;
        }
    }

    public static void layoutHorizontalRight(int rightX, int y, int gapW, SKMArray uis) {
        int uiX = rightX;
        for (int i = uis.size() - 1; 0 <= i; --i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setXY(uiX - ui.getWidth(), y);
            uiX -= ui.getWidth() + gapW;
        }
    }

    public static void layoutHorizontalCenteringAt(int x, int y, int gapW, SKMUI ... uis) {
        int len = 0;
        for (int i = uis.length - 1; 0 <= i; --i) {
            len += uis[i].getWidth();
            if (i == 0) continue;
            len += gapW;
        }
        int uiX = x - len / 2;
        for (int i = 0; i < uis.length; ++i) {
            SKMUI ui = uis[i];
            ui.setCenterXY(uiX + ui.getWidth() / 2, y);
            uiX += ui.getWidth() + gapW;
        }
    }

    public static void layoutHorizontalCenteringAt(int x, int y, int gapW, SKMArray uis) {
        int len = 0;
        for (int i = uis.size() - 1; 0 <= i; --i) {
            len += ((SKMUI)uis.get(i)).getWidth();
            if (i == 0) continue;
            len += gapW;
        }
        int uiX = x - len / 2;
        for (int i = 0; i < uis.size(); ++i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setCenterXY(uiX + ui.getWidth() / 2, y);
            uiX += ui.getWidth() + gapW;
        }
    }

    public static void layoutVerticalTop(int x, int topY, int gapH, SKMUI ... uis) {
        int uiY = topY;
        for (int i = 0; i < uis.length; ++i) {
            SKMUI ui = uis[i];
            ui.setXY(x, uiY);
            uiY += ui.getHeight() + gapH;
        }
    }

    public static void layoutVerticalTop(int x, int topY, int gapH, SKMArray uis) {
        int uiY = topY;
        for (int i = 0; i < uis.size(); ++i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setXY(x, uiY);
            uiY += ui.getHeight() + gapH;
        }
    }

    public static void layoutVerticalBottom(int x, int bottomY, int gapH, SKMUI ... uis) {
        int uiY = bottomY;
        for (int i = uis.length - 1; 0 <= i; --i) {
            SKMUI ui = uis[i];
            ui.setXY(x, uiY - ui.getHeight());
            uiY -= ui.getHeight() + gapH;
        }
    }

    public static void layoutVerticalBottom(int x, int bottomY, int gapH, SKMArray uis) {
        int uiY = bottomY;
        for (int i = uis.size() - 1; 0 <= i; --i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setXY(x, uiY - ui.getHeight());
            uiY -= ui.getHeight() + gapH;
        }
    }

    public static void layoutVerticalCenteringAt(int x, int y, int gapH, SKMUI ... uis) {
        int len = 0;
        for (int i = uis.length - 1; 0 <= i; --i) {
            len += uis[i].getHeight();
            if (i == 0) continue;
            len += gapH;
        }
        int uiY = y - len / 2;
        for (int i = 0; i < uis.length; ++i) {
            SKMUI ui = uis[i];
            ui.setCenterXY(x, uiY + ui.getHeight() / 2);
            uiY += ui.getHeight() + gapH;
        }
    }

    public static void layoutVerticalCenteringAt(int x, int y, int gapH, SKMArray uis) {
        int len = 0;
        for (int i = uis.size() - 1; 0 <= i; --i) {
            len += ((SKMUI)uis.get(i)).getHeight();
            if (i == 0) continue;
            len += gapH;
        }
        int uiY = y - len / 2;
        for (int i = 0; i < uis.size(); ++i) {
            SKMUI ui = (SKMUI)uis.get(i);
            if (ui == null) continue;
            ui.setCenterXY(x, uiY + ui.getHeight() / 2);
            uiY += ui.getHeight() + gapH;
        }
    }

    public boolean setVisible(boolean f) {
        boolean ret = f != this.mIsVisible;
        this.mIsVisible = f;
        if (this.mComponent != null) {
            this.mComponent.setVisible(f);
        }
        return ret;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setVisibleInApp(boolean f) {
        this.mIsVisibleInApp = f;
    }

    public boolean isVisibleInApp() {
        return this.mIsVisibleInApp;
    }

    public boolean setEnabled(boolean f) {
        boolean ret = f != this.mIsEnabled;
        this.mIsEnabled = f;
        if (this.mComponent != null) {
            this.mComponent.setEnabled(f);
        }
        return ret;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setX(int x) {
        this.mX = x;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public int getX() {
        return this.mX;
    }

    public void setY(int y) {
        this.mY = y;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public int getY() {
        return this.mY;
    }

    public void setXY(int x, int y) {
        this.mX = x;
        this.mY = y;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public void setCenterXY(int centerX, int centerY) {
        this.setXY(centerX - this.mWidth / 2, centerY - this.mHeight / 2);
    }

    public void setOffsetX(int offsetX) {
        this.mOffsetX = offsetX;
    }

    public void setOffsetY(int offsetY) {
        this.mOffsetY = offsetY;
    }

    public void setOffsetXY(int offsetX, int offsetY) {
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
    }

    public int getOffsetX() {
        return this.mOffsetX;
    }

    public int getOffsetY() {
        return this.mOffsetY;
    }

    public void setWidth(int w) {
        this.mWidth = w;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int h) {
        this.mHeight = h;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setSize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        if (this.mComponent != null) {
            this.mComponent.setBounds(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    public boolean isHit(double mx, double my) {
        return this.isHit(mx, my, true, false);
    }

    public boolean isHit(double mx, double my, boolean isPress) {
        return this.isHit(mx, my, isPress, false);
    }

    public boolean isHit(double mx, double my, boolean isPress, boolean isJudgeOnly) {
        boolean ret;
        if (isPress && !this.mIsVisibleInApp) {
            return false;
        }
        boolean bl = ret = (isJudgeOnly || this.mIsEnabled && this.mIsVisible) && (double)this.mX <= (mx -= (double)this.mOffsetX) && mx <= (double)(this.mX + this.mWidth) && (double)this.mY <= (my -= (double)this.mOffsetY) && my <= (double)(this.mY + this.mHeight);
        if (!isJudgeOnly && isPress) {
            this.setPressed(ret);
        }
        return ret;
    }

    public boolean setPressed(boolean f) {
        boolean ret;
        boolean bl = ret = this.mIsVisible && f != this.mIsPressed;
        if (this.mIsVisible) {
            this.mIsPressed = f;
        }
        return ret;
    }

    public boolean isPressed() {
        return this.mIsPressed;
    }

    public void setBackgroundColor(SKMColor color) {
        if (this.mComponent != null) {
            this.mComponent.setBackground(color.getColor());
        }
    }

    protected void setImpl(Component component) {
        this.mComponent = component;
        this.mComponent.setVisible(this.mIsVisible);
        this.mComponent.setEnabled(this.mIsEnabled);
    }

    public Component getImpl() {
        return this.mComponent;
    }

    public void move() {
    }

    public void paint(SKMGraphics g) {
        if (!this.mIsVisible || !this.mIsVisibleInApp) {
            return;
        }
        this.paintComponent(g);
    }

    public void paintForce(SKMGraphics g) {
        this.paintComponent(g);
    }

    protected void paintComponent(SKMGraphics g) {
        boolean isOffsetSet;
        boolean bl = isOffsetSet = this.mOffsetX != 0 || this.mOffsetY != 0;
        if (isOffsetSet) {
            g.saveTransform();
            g.translate(this.mOffsetX, this.mOffsetY);
        }
        this.myPaint(g);
        if (isOffsetSet) {
            g.restoreTransform();
        }
    }

    protected void myPaint(SKMGraphics g) {
    }
}

