/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMConnectUtil;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMMineUtil;
import jp.ne.sk_mine.util.andr_applet.SKMRTool;
import jp.ne.sk_mine.util.andr_applet.SKMRuntimeFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMWindowFuncs;
import jp.ne.sk_mine.util.ui.ExJTextField;

public class SaveLoadDialog
extends JDialog
implements ActionListener {
    private boolean mIsSave;
    private boolean mIsSending;
    private boolean mIsPlatformLimited;
    private String mTitle;
    private String mRegisterUserUrl;
    private String mLoadedData;
    private ExJTextField mUidTf;
    private JPasswordField mPwdTf;
    private JLabel mMainLabel;
    private JPanel mMainLabelPanel;
    private JButton mOkButton;
    private JButton mRegisterButton;
    private JButton mDeleteAccountButton;
    private JButton mCancelButton;
    private ArrayList<Component> mUiList = new ArrayList();
    private SKMConnectUtil mConnectUtil;
    private SKMI18N mI18NRegisterScore;

    public SaveLoadDialog(boolean isSave, String registerUserUrl) {
        super((Frame)SKM.getManager().getFrame(), true);
        this.mIsSave = isSave;
        this.mRegisterUserUrl = registerUserUrl;
        this.mConnectUtil = new SKMConnectUtil();
        this.mConnectUtil.setServerInfo("https://sorakomi.com/soft/game/common/save_load.php");
        this.mConnectUtil.setSendEncoding("UTF-8");
        this.mI18NRegisterScore = new SKMI18N("jp.ne.sk_mine.util.andr_applet.res.message.message");
        SKMI18N i18nCommon = SKM.getI18NCommon();
        this.mTitle = i18nCommon.getString(isSave ? "title_save" : "title_load");
        this.setTitle(this.mTitle);
        this.mMainLabelPanel = new JPanel();
        this.mMainLabelPanel.setLayout(new BorderLayout());
        String message = i18nCommon.getString(isSave ? "explanation_save" : "explanation_load").replace("\n", "<br>");
        this.mMainLabel = new JLabel("<html>" + message + "</html>");
        this.mMainLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mMainLabelPanel.add((Component)this.mMainLabel, "North");
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel(this.mI18NRegisterScore.getString("codename")));
        labelPanel.add(new JLabel(this.mI18NRegisterScore.getString("password")));
        JPanel inputPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.mUidTf = new ExJTextField(SKM.getManager().getStringSetting("user_id", ""), 16);
        this.mUidTf.addActionListener(this);
        this.mUidTf.setMaxLength(16);
        inputPanel.add(this.mUidTf);
        this.mPwdTf = new JPasswordField(SKMMineUtil.decryptSimple(SKM.getManager().getStringSetting("password", "")), 16);
        this.mPwdTf.setEchoChar('*');
        this.mPwdTf.addActionListener(this);
        inputPanel.add(this.mPwdTf);
        JPanel centerPanel = new JPanel(new FlowLayout());
        centerPanel.add(labelPanel);
        centerPanel.add(inputPanel);
        this.mMainLabelPanel.add((Component)centerPanel, "Center");
        this.mOkButton = new JButton(i18nCommon.getString("ok"));
        this.mOkButton.addActionListener(this);
        this.mRegisterButton = new JButton(this.mI18NRegisterScore.getString("register_button"));
        this.mRegisterButton.addActionListener(this);
        this.mDeleteAccountButton = new JButton(i18nCommon.getString("delete_account_button"));
        this.mDeleteAccountButton.addActionListener(this);
        this.mCancelButton = new JButton(i18nCommon.getString("cancel"));
        this.mCancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.mOkButton);
        buttonPanel.add(this.mRegisterButton);
        buttonPanel.add(this.mDeleteAccountButton);
        buttonPanel.add(this.mCancelButton);
        this.mMainLabelPanel.add((Component)buttonPanel, "South");
        this.addToUiList(this.mUidTf);
        this.addToUiList(this.mPwdTf);
        this.addToUiList(this.mOkButton);
        this.addToUiList(this.mCancelButton);
        this.resizeFrame();
        SKMWindowFuncs.centering(this, SKM.getManager().getFrame());
    }

    public void setPlatformLimited(boolean f) {
        this.mIsPlatformLimited = f;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.mIsSending) {
            return;
        }
        Object source = ae.getSource();
        if (source == this.mCancelButton) {
            this.dispose();
        } else if (source == this.mUidTf || source == this.mPwdTf || source == this.mOkButton) {
            String pwd;
            String uid = this.mUidTf.getText();
            char[] pwdChars = this.mPwdTf.getPassword();
            String string = pwd = pwdChars == null || pwdChars.length == 0 ? "" : new String(pwdChars);
            if (uid == null || uid.length() == 0) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_no_codename"));
                this.resizeFrame();
                return;
            }
            if (SKMMineUtil.includesInvalidLetter(uid) || SKMMineUtil.includesInvalidLetter(pwd)) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_invalid_letter"));
                this.resizeFrame();
                return;
            }
            if (uid.indexOf("ttp://") != -1 || uid.indexOf("ttps://") != -1) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_include_url"));
                this.resizeFrame();
                return;
            }
            int len = uid.length();
            boolean onlySpace = true;
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < len && i < 16; ++i) {
                char c = uid.charAt(i);
                if (c != ' ') {
                    onlySpace = false;
                }
                tmp.append(c);
            }
            if (onlySpace) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_space_name"));
                this.resizeFrame();
                return;
            }
            String userId = tmp.toString();
            if (16 < userId.length()) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_too_long_name"));
                this.resizeFrame();
                return;
            }
            if (16 < pwd.length()) {
                this.mMainLabel.setText(this.mI18NRegisterScore.getString("error_too_long_password"));
                this.resizeFrame();
                return;
            }
            SKM.getManager().setSetting("user_id", userId);
            SKM.getManager().setSetting("password", SKMMineUtil.encryptSimple(pwd));
            this.setTitle(this.mI18NRegisterScore.getString("connecting"));
            this.mIsSending = true;
            final String fUid = userId;
            final String fPwd = pwd;
            new Thread(){

                @Override
                public void run() {
                    SaveLoadDialog.this.setUiEnabled(false);
                    SaveLoadDialog.this.sendData(fUid, fPwd);
                    SaveLoadDialog.this.setUiEnabled(true);
                }
            }.start();
        } else if (source == this.mRegisterButton || source == this.mDeleteAccountButton) {
            SKMRuntimeFuncs.openBrowser(this.mRegisterUserUrl);
        }
    }

    public void sendData(String userId, String password) {
        String retStr = this.mConnectUtil.connectUrl(this.createSendData(userId, password));
        String title = "";
        String message = "";
        if (retStr == null || retStr.equals("")) {
            title = SKMConnectUtil.getStateTitle(-3);
            message = SKMConnectUtil.getStateMessage(-3);
        } else if (this.mIsSave) {
            if (retStr.equals("-99")) {
                this.dispose();
                JOptionPane.showMessageDialog(SKM.getManager(), SKM.getI18NCommon().getString("succeed_save"));
            } else {
                int retCode = Integer.parseInt(retStr);
                title = SKMConnectUtil.getStateTitle(retCode);
                message = SKMConnectUtil.getStateMessage(retCode);
            }
        } else if (retStr.indexOf("{") == -1) {
            int retCode = Integer.parseInt(retStr);
            title = SKMConnectUtil.getStateTitle(retCode);
            message = SKMConnectUtil.getStateMessage(retCode);
        } else {
            this.mLoadedData = retStr;
            this.dispose();
        }
        this.setTitle(title);
        this.mMainLabel.setText(message);
        this.resizeFrame();
        SKMWindowFuncs.centering(this);
        this.mIsSending = false;
        this.mUidTf.requestFocus();
    }

    private final String createSendData(String userId, String password) {
        String cpass = password;
        if (!password.equals("")) {
            int e = 17;
            int n = 37403;
            cpass = SKMRTool.encrypt(password, 17, 37403);
        }
        String data = null;
        try {
            data = URLEncoder.encode(SKM.getManager().getAllSettingDataString(), "UTF-8");
        }
        catch (Exception e) {
            SKM.getManager().logging(e);
            data = "";
        }
        String gameId = SKM.getManager().getAppId();
        StringBuilder buf = new StringBuilder();
        buf.append("com=");
        if (this.mIsSave) {
            buf.append("save");
        } else {
            buf.append("load");
        }
        buf.append("\t");
        buf.append("uid=");
        buf.append(userId);
        buf.append("\t");
        buf.append("pwd=");
        buf.append(cpass);
        buf.append("\t");
        buf.append("game_id=");
        buf.append(gameId);
        buf.append("\t");
        buf.append("data=");
        buf.append(data);
        if (this.mIsPlatformLimited) {
            buf.append("\t");
            buf.append("platform=C");
        }
        return buf.toString();
    }

    public String getLoadedData() {
        return this.mLoadedData;
    }

    private void resizeFrame() {
        this.remove(this.mMainLabelPanel);
        this.getContentPane().add((Component)this.mMainLabelPanel, "North");
        this.pack();
    }

    protected void addToUiList(Component c) {
        this.mUiList.add(c);
    }

    protected void setUiEnabled(boolean f) {
        for (int i = 0; i < this.mUiList.size(); ++i) {
            this.mUiList.get(i).setEnabled(f);
        }
    }
}

