/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.effect;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMRandomTool;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public class BulletHitEffect
extends Effect {
    private int mNum;
    private int mSize;
    private int[] mSpeeds;
    private int[][] mFlushXys;
    private double[] mRads;
    private boolean[] mIsDeads;
    private SKMColor mColor;

    public BulletHitEffect(double x, double y, double rad, int num) {
        this(x, y, rad, num, 20);
    }

    public BulletHitEffect(double x, double y, double rad, int num, int baseSpeed) {
        super(x, y);
        this.mNum = num;
        this.mSize = 10;
        this.mSpeeds = new int[this.mNum];
        this.mFlushXys = new int[2][this.mNum];
        this.mRads = new double[this.mNum];
        this.mIsDeads = new boolean[this.mNum];
        int ix = SKMUtil.toInt(x);
        int iy = SKMUtil.toInt(y);
        int haba = 20;
        SKMRandomTool random = SKM.getRandom();
        for (int i = 0; i < this.mNum; ++i) {
            this.mSpeeds[i] = baseSpeed + random.nextSignInt(3 * baseSpeed / 4);
            this.mRads[i] = rad + (double)random.nextSignInt(20) * (Math.PI / 180);
            this.mFlushXys[0][i] = ix;
            this.mFlushXys[1][i] = iy;
        }
        this.mColor = SKMColor.YELLOW;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setColor(SKMColor color) {
        this.mColor = color;
    }

    @Override
    protected void myMove() {
        int deadNum = 0;
        int i = this.mNum - 1;
        while (0 <= i) {
            int n = i;
            int n2 = this.mSpeeds[n];
            this.mSpeeds[n] = n2 - 1;
            this.setSpeedByRadian(this.mRads[i], n2);
            if (this.mSpeeds[i] <= 0) {
                this.mIsDeads[i] = true;
                ++deadNum;
            }
            int[] nArray = this.mFlushXys[0];
            int n3 = i;
            nArray[n3] = (int)((double)nArray[n3] + this.mSpeedX);
            int[] nArray2 = this.mFlushXys[1];
            int n4 = i--;
            nArray2[n4] = (int)((double)nArray2[n4] + this.mSpeedY);
        }
        if (deadNum == this.mNum) {
            this.kill();
        }
        this.mSpeedY = 0.0;
        this.mSpeedX = 0.0;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        g.setColor(this.mColor);
        for (int i = 0; i < this.mNum; ++i) {
            if (this.mIsDeads[i]) continue;
            g.fillOval(this.mFlushXys[0][i], this.mFlushXys[1][i], this.mSize, this.mSize);
        }
    }
}

