/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.image.RGBImageFilter;

public final class SwapFilter
extends RGBImageFilter {
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    private final int[] rgbAry_ = new int[3];
    private final int[] newRgbAry_ = new int[3];
    private int first_;
    private int second_;
    private int third_;
    private int[] mColor1s;
    private int[] mColor2s;

    public SwapFilter(int first, int second, int third) {
        this.canFilterIndexColorModel = true;
        this.first_ = first;
        this.second_ = second;
        this.third_ = third;
    }

    public SwapFilter(int color1, int color2) {
        this.mColor1s = new int[]{color1};
        this.mColor2s = new int[]{color2};
    }

    public SwapFilter(int[] color1s, int[] color2s) {
        this.mColor1s = color1s;
        this.mColor2s = color2s;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        if (this.mColor1s == null && this.mColor2s == null) {
            int a = (rgb & 0xFF000000) >> 24;
            this.rgbAry_[0] = (rgb & 0xFF0000) >> 16;
            this.rgbAry_[1] = (rgb & 0xFF00) >> 8;
            this.rgbAry_[2] = rgb & 0xFF;
            this.newRgbAry_[0] = this.rgbAry_[this.first_];
            this.newRgbAry_[1] = this.rgbAry_[this.second_];
            this.newRgbAry_[2] = this.rgbAry_[this.third_];
            return (a << 24) + (this.newRgbAry_[0] << 16) + (this.newRgbAry_[1] << 8) + this.newRgbAry_[2];
        }
        int minLen = Math.min(this.mColor1s.length, this.mColor2s.length);
        for (int i = minLen - 1; 0 <= i; --i) {
            if (rgb == this.mColor1s[i]) {
                return this.mColor2s[i];
            }
            if (rgb != this.mColor2s[i]) continue;
            return this.mColor1s[i];
        }
        return rgb;
    }
}

