/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.Mixer;
import jp.ne.sk_mine.util.sound.LineListenerImpl;
import jp.ne.sk_mine.util.sound.PlayThread;
import jp.ne.sk_mine.util.sound.Player;

public class WavePlayer
extends Player {
    private Map<String, String> nameMap_ = new HashMap<String, String>();
    private Map<String, List<Clip>> clipListMap_ = new HashMap<String, List<Clip>>();
    private LineListener lineListener_ = new LineListenerImpl();
    private PlayThread playThread_ = new PlayThread();

    public WavePlayer() {
        this.playThread_.start();
    }

    @Override
    public boolean load(String name, String resourceName) {
        Clip clip = this.getClip(resourceName);
        if (clip == null) {
            return false;
        }
        this._addPlayingClip(name, clip);
        this.nameMap_.put(name, resourceName);
        return true;
    }

    @Override
    public boolean load(String name, String resourceName, int loopStartPos) {
        return this.load(name, resourceName);
    }

    private Clip getClip(String filename) {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(filename);
            AudioInputStream audio = AudioSystem.getAudioInputStream(new BufferedInputStream(in));
            DataLine.Info info = new DataLine.Info(Clip.class, audio.getFormat());
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            for (int i = 1; i < mixerInfo.length; ++i) {
                try {
                    Mixer mixer = AudioSystem.getMixer(mixerInfo[i]);
                    Clip clip = (Clip)mixer.getLine(info);
                    long startTime = System.currentTimeMillis();
                    clip.open(audio);
                    audio.close();
                    long dTime = System.currentTimeMillis() - startTime;
                    if (500L < dTime) {
                        clip.close();
                        clip.flush();
                        clip = null;
                    }
                    return clip;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            audio.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void preload() {
        Iterator<Map.Entry<String, String>> itr = this.nameMap_.entrySet().iterator();
        while (itr.hasNext()) {
            String name = itr.next().getKey();
            this.preload(name);
        }
    }

    @Override
    public void preload(String name) {
        List<Clip> list = this.clipListMap_.get(name);
        if (list == null || list.size() == 0) {
            return;
        }
        Clip clip = list.get(0);
        clip.start();
        clip.stop();
    }

    @Override
    public boolean hasName(String name) {
        return this.nameMap_.containsKey(name);
    }

    @Override
    public void play(final String name, final boolean isLoop, final Player.PlayMode playMode) {
        boolean isRunning;
        if (!this.isPlayable()) {
            return;
        }
        final List<Clip> list = this.clipListMap_.get(name);
        if (list == null || list.size() == 0) {
            return;
        }
        final Clip clip = list.get(0);
        this._removeStoppedSoundFromListExceptFirstOne();
        boolean bl = isRunning = clip.isRunning() || 1 < list.size();
        if (isRunning) {
            if (playMode == Player.PlayMode.SINGLE) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    Clip newClip = WavePlayer.this.getClip((String)WavePlayer.this.nameMap_.get(name));
                    if (newClip == null) {
                        return;
                    }
                    if (isLoop) {
                        newClip.loop(-1);
                    }
                    list.add(0, newClip);
                    clip.addLineListener(WavePlayer.this.lineListener_);
                    if (playMode == Player.PlayMode.STOP_PREVIOUS) {
                        try {
                            for (int i = list.size() - 1; 0 < i; --i) {
                                Clip c = (Clip)list.get(i);
                                if (c == null) continue;
                                c.stop();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    WavePlayer.this.playThread_.addClip(newClip);
                }
            }.start();
        } else {
            clip.setFramePosition(0);
            if (isLoop) {
                clip.loop(-1);
            }
            this.playThread_.addClip(clip);
        }
    }

    public void pause(String name) {
        List<Clip> list = this.clipListMap_.get(name);
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = list.size() - 1; 0 <= i; --i) {
            list.get(i).stop();
        }
    }

    @Override
    public void stop(String name) {
        List<Clip> list = this.clipListMap_.get(name);
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = list.size() - 1; 0 <= i; --i) {
            try {
                Clip clip = list.get(i);
                if (clip == null || !clip.isRunning()) continue;
                clip.stop();
                clip.setFramePosition(0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._removeStoppedSoundFromListExceptFirstOne();
    }

    @Override
    public void stopAll() {
        final WavePlayer player = this;
        new Thread(){

            @Override
            public void run() {
                for (Map.Entry entry : WavePlayer.this.clipListMap_.entrySet()) {
                    player.stop((String)entry.getKey());
                }
            }
        }.start();
    }

    private final void _addPlayingClip(String name, Clip clip) {
        List<Clip> list = this.clipListMap_.get(name);
        if (list == null) {
            list = new ArrayList<Clip>();
            this.clipListMap_.put(name, list);
        }
        if (0 < list.size()) {
            list.get(0).addLineListener(this.lineListener_);
        }
        list.add(0, clip);
    }

    private final void _removeStoppedSoundFromListExceptFirstOne() {
        for (Map.Entry<String, List<Clip>> entry : this.clipListMap_.entrySet()) {
            List<Clip> list = entry.getValue();
            for (int i = list.size() - 1; 0 < i; --i) {
                try {
                    Clip clip = list.get(i);
                    if (clip == null || clip.isRunning()) continue;
                    list.remove(i);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void finalize() {
        for (Map.Entry<String, List<Clip>> entry : this.clipListMap_.entrySet()) {
            List<Clip> list = entry.getValue();
            for (int i = list.size() - 1; 0 <= i; --i) {
                Clip clip = list.get(i);
                if (clip == null) continue;
                clip.removeLineListener(this.lineListener_);
                clip.stop();
                clip.close();
                clip.flush();
            }
        }
        this.playThread_ = null;
    }
}

