/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class LimitDocument
extends PlainDocument {
    private int mMax;
    private JTextComponent mTextComponent;

    public LimitDocument(JTextComponent textComponent) {
        this.mTextComponent = textComponent;
        this.mMax = -1;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (a != null && a.isDefined(StyleConstants.ComposedTextAttribute)) {
            super.insertString(offs, str, a);
            return;
        }
        if (!this.canInsertString(str)) {
            return;
        }
        super.insertString(offs, str, a);
    }

    public int getMaxLength() {
        return this.mMax;
    }

    public void setMaxLength(int max) {
        this.mMax = max;
    }

    private boolean canInsertString(String str) {
        if (this.mMax < 0) {
            return true;
        }
        return this.mMax >= this.mTextComponent.getText().length() + str.length();
    }
}

