/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Image;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.image.ImageLoader;

public final class SKMImageLoader {
    private static SKMImageLoader sInstance;

    public static SKMImageLoader getInstance() {
        if (sInstance == null) {
            sInstance = new SKMImageLoader();
        }
        return sInstance;
    }

    public final SKMImage[][] loadImages(String filename, int x, int y, int w, int h, int xNum, int yNum, SKMImage[][] outImages) {
        if (SKMImage.getBasePath() != null && filename.indexOf(SKMImage.getBasePath()) != 0) {
            filename = SKMImage.getBasePath() + filename;
        }
        Image[][] out = ImageLoader.getInstance().loadImages(filename, x, y, w, h, xNum, yNum, null);
        SKMImage[][] ret = outImages;
        if (ret == null) {
            ret = new SKMImage[out.length][out[0].length];
        }
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[i].length; ++j) {
                ret[i][j] = new SKMImage(out[i][j]);
            }
        }
        return ret;
    }

    public final SKMImage[][] loadImages(String filename, int x, int y, int w, int h, SKMImage[][] images) {
        return this.loadImages(filename, x, y, w, h, -1, -1, images);
    }

    public final SKMImage[][] loadImages(String filename, int x, int y, int w, int h) {
        return this.loadImages(filename, x, y, w, h, -1, -1, null);
    }

    public final SKMImage loadImage(String fileName, int x, int y, int w, int h) {
        Image image;
        String basePath = SKMImage.getBasePath();
        if (basePath != null && fileName.indexOf(basePath) != 0) {
            fileName = basePath + fileName;
        }
        if ((image = ImageLoader.getInstance().loadImage(fileName, x, y, w, h)) == null) {
            return null;
        }
        return new SKMImage(image);
    }

    public void setUseCache(boolean f) {
        ImageLoader.getInstance().setUseCache(f);
    }

    public boolean isUseCache() {
        return ImageLoader.getInstance().isUseCache();
    }
}

