# myWiki

ローカル環境で動作するWiki風のエディタソフトです。

簡単な書式で文字飾りや表を表現できるので、単なるテキストよりもわかりやすい文書をつくることができます。

オンラインのWikiやMarkdownで文書を記述するサイトの下書き用ソフトとしてもご利用いただけます。


## 使い方

1. [Wiki]の[新Wiki作成]でWikiを作成する
2. [Wiki]の[ページ作成]でページを作成する
3. [Wiki]の[ページ編集]でテキストを入力する


## 書式

以下の書式が利用できます。

- Markdown風
- PukiWiki風
- Text


## 動作環境

Windows 11

[Microsoft Edge WebView2](https://developer.microsoft.com/ja-jp/microsoft-edge/webview2/)をインストールするとWindows 10でも利用できるかもしれません。


## Tips

### Mermaid記法の利用

Markdown風では、[設定]の[テンプレート]から「default-mermaid」を選択することでMermaid記法が有効になります。

テンプレートを設定したら以下のように言語に`mermaid`を指定してコードを記述してください。

    ```mermaid
    %%{init:{'themeCSS':"p {padding:0.5em}"}}%%
    
    graph LR
    S(((Start))) -- Select A --> A((A))
    S -- Select B --> B((B))
    ```

★外部JavaScriptライブラリー読み込みのためにインターネット接続が必要になります。

### 数式の記述

[設定]の[テンプレート]から「default-math」を選択することでMathJaxによる数式の記述が可能になります。

`$`で囲むとインラインで、`$$`で囲むとブロックで式を記述できます。Markdown風では以下のように言語に`math`を指定する方法もあります。

    ```math
    \sum_{k=1}^nk=\frac{1}{2}n(n+1)
    ```

★外部JavaScriptライブラリー読み込みのためにインターネット接続が必要になります。

### シンタックスハイライト

Markdown風では、[設定]の[テンプレート]から「default-syntax-highlight」を選択することでShikiによるシンタックスハイライトが有効になります。

テンプレートを設定したら以下のように言語を指定してコードを記述してください。

    ```c
    #include <stdio.h>
    
    int main(void) {
        printf("Hello, World!\n");
        return 0;
    }
    ```

★外部JavaScriptライブラリー読み込みのためにインターネット接続が必要になります。

### Mermaid記法・数式・シンタックスハイライトを同時に使う

[設定]の[テンプレート]から「default-all」を選択してください。

### ダークモードでの利用

下記の手順でダークモード環境での利用を想定した配色になります。

1. [設定]の[スタイル]で「Windows11 Modern Dark」を選択する
2. [設定]の[デザイン]で「dark」を選択する
3. アプリケーションを終了する
4. アプリケーションを起動する

### 折りたたみのショートカット

メニューに表示されていないですが、以下のショートカットが利用できます。

|機能            |ショートカット  |
|----------------|----------------|
|折りたたむ      |Ctrl + Shift + [|
|すべて折りたたむ|Ctrl + Shift + -|
|展開する        |Ctrl + Shift + ]|
|すべて展開する  |Ctrl + Shift + +|


## ライセンス

MITライセンスです。商用利用も含めて無償で利用できます。詳細はLICENSE.txtをご覧ください。


## 作成者

* MASUDA Takashi <https://mas3lab.net/>
