/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.game.Block;
import jp.ne.sk_mine.util.andr_applet.game.GameCharacter;

public class ShotCharacter
extends GameCharacter {
    public static final int DEFAULT_TWIN_DISTANCE = 8;
    public static final int SHOT_SINGLE = 0;
    public static final int SHOT_TWIN = 1;
    public static final int SHOT_THREE_WAY = 2;
    public static final int SHOT_FIVE_WAY = 3;
    public static final int SHOT_ROUND = 4;
    public static final int SHOT_CROSS = 5;
    protected double mBulletSpeed = 6.0;
    protected int mBulletType;
    protected int mMaxBullets;
    protected int mShotFreq = 1;
    protected SKMArray<GameCharacter> mBullets = new SKMArray();
    protected int mShotType;
    protected int mShotOption;
    protected int mBulletOption;

    public ShotCharacter(double x, double y, int type) {
        super(x, y, type);
    }

    @Override
    public void move(SKMArray<Block> blocks) {
        this.moveBullets(blocks);
        super.move(blocks);
    }

    public void moveBullets(SKMArray<Block> blocks) {
        for (int i = this.mBullets.size() - 1; 0 <= i; --i) {
            GameCharacter bullet = this.mBullets.get(i);
            if (bullet == null) continue;
            if (bullet.isDead() || !bullet.mIsNotDieOut && bullet.isOut()) {
                bullet.kill();
                this.mBullets.remove(bullet);
                continue;
            }
            bullet.move(blocks);
        }
    }

    @Override
    public boolean isDead() {
        return super.isDead() && this.mBullets.size() == 0;
    }

    protected boolean canShot(int num) {
        int max = this.getShotMaxByType(this.mBulletType);
        int n = 0;
        for (int i = this.mBullets.size() - 1; 0 <= i; --i) {
            GameCharacter bullet = this.mBullets.get(i);
            if (bullet == null || 0 >= bullet.getEnergy() || bullet.getBulletType() != this.mBulletType) continue;
            ++n;
        }
        return num <= max - n;
    }

    protected int getShotMaxByType(int bulletType) {
        return this.mMaxBullets;
    }

    protected void setShotInfo(int max, int freq) {
        if (max != this.mMaxBullets) {
            this.clearBullets();
        }
        this.mMaxBullets = max;
        this.mShotFreq = freq;
    }

    protected boolean shotByRadian(double rad) {
        return this.shotByRadian(this.mX, this.mY, rad);
    }

    protected boolean shotByDegree(int degree) {
        return this.shotByRadian(this.mX, this.mY, (double)degree * Math.PI / 180.0);
    }

    protected boolean shot(int x, int y) {
        return this.shotByRadian(x, y, this.getRadToMine(x, y));
    }

    protected boolean shot() {
        return this.shotByRadian(this.mX, this.mY, this.getRadToMine(this.mX, this.mY));
    }

    protected boolean gapShot(int x, int y, double rad, int degree) {
        return this.shotByRadian(x, y, rad + (double)SKM.getRandomForRepro().nextSignInt(degree / 2) * Math.PI / 180.0);
    }

    protected boolean gapShot(int x, int y, int degree) {
        return this.gapShot(x, y, this.getRadToMine(x, y), degree);
    }

    protected boolean gapShot(int degree) {
        return this.gapShot(this.mX, this.mY, this.getRadToMine(this.mX, this.mY), degree);
    }

    protected boolean shotByRadian(int x, int y, double rad) {
        if (this.mShotFreq == 0) {
            return false;
        }
        if (this.mCount % this.mShotFreq != this.mShotFreq - 1) {
            return false;
        }
        switch (this.mShotType) {
            case 0: {
                if (!this.canShot(1)) {
                    return false;
                }
                this.setBullet(x, y, rad);
                return true;
            }
            case 1: {
                return this.twinWay(x, y, rad);
            }
            case 2: {
                return this.threeWay(x, y, rad);
            }
            case 3: {
                return this.fiveWay(x, y, rad);
            }
            case 4: {
                return this.roundShot(x, y, rad);
            }
            case 5: {
                return this.crossShot(x, y, rad);
            }
        }
        return this.customShot(x, y, rad);
    }

    protected boolean shotByDegree(int x, int y, int degree) {
        return this.shotByRadian(x, y, (double)degree * Math.PI / 180.0);
    }

    protected boolean twinWay(int x, int y, double rad) {
        if (!this.canShot(2)) {
            return false;
        }
        int d = this.mShotOption == 0 ? 8 : this.mShotOption;
        double dx = (double)d * Math.sin(rad);
        double dy = (double)(-d) * Math.cos(rad);
        this.setBullet(x + (int)dx, y + (int)dy, rad);
        dx = (double)(-d) * Math.sin(rad);
        dy = (double)d * Math.cos(rad);
        this.setBullet(x + (int)dx, y + (int)dy, rad);
        return true;
    }

    protected boolean threeWay(int x, int y, double rad) {
        return this.nWay(x, y, rad, 3, 0.5235987755982988);
    }

    protected boolean fiveWay(int x, int y, double rad) {
        return this.nWay(x, y, rad, 5, 0.5235987755982988);
    }

    protected boolean roundShot(int x, int y, double rad) {
        return this.nWay(x, y, rad, 8, 0.7853981633974483);
    }

    protected boolean crossShot(int x, int y, double rad) {
        return this.nWay(x, y, rad, 4, 1.5707963267948966);
    }

    protected boolean nWay(int x, int y, double rad, int num, double drad) {
        int i;
        if (!this.canShot(num)) {
            return false;
        }
        int nPair = num - 1 >> 1;
        this.setBullet(x, y, rad);
        for (i = 0; i < nPair; ++i) {
            this.setBullet(x, y, rad + drad * (double)(i + 1));
            this.setBullet(x, y, rad - drad * (double)(i + 1));
        }
        if (num % 2 == 0) {
            this.setBullet(x, y, rad + drad * (double)(i + 1));
        }
        return true;
    }

    protected boolean customShot(int x, int y, double rad) {
        return false;
    }

    protected boolean setBullet(int x, int y, double rad) {
        GameCharacter bullet = this.getBulletByType(x, y, rad, this.mBulletSpeed, this.mBulletType, this, this.mBulletOption);
        if (bullet == null) {
            return false;
        }
        this.mBullets.add(bullet);
        return true;
    }

    protected GameCharacter getBulletByType(int x, int y, double rad, double speed, int type, GameCharacter shooter, int option) {
        return null;
    }

    public boolean setBullet(GameCharacter bullet) {
        if (bullet == null) {
            return false;
        }
        this.mBullets.add(bullet);
        return true;
    }

    public boolean setBulletToFront(int x, int y, double rad) {
        return this.setBulletToFront(this.getBulletByType(x, y, rad, this.mBulletSpeed, this.mBulletType, this, this.mBulletOption));
    }

    public boolean setBulletToFront(GameCharacter bullet) {
        if (bullet == null) {
            return false;
        }
        this.mBullets.add(0, bullet);
        return true;
    }

    public GameCharacter removeBullet(GameCharacter bullet) {
        return this.mBullets.remove(bullet);
    }

    public void dieBullets() {
        for (int i = this.mBullets.size() - 1; 0 <= i; --i) {
            GameCharacter bullet = this.mBullets.get(i);
            if (bullet == null) continue;
            bullet.die();
        }
    }

    @Override
    public void paint(SKMGraphics g) {
        super.paint(g);
        this.paintBullet(g);
    }

    public void paintBullet(SKMGraphics g) {
        for (int i = this.mBullets.size() - 1; 0 <= i; --i) {
            GameCharacter bullet = this.mBullets.get(i);
            if (bullet == null) continue;
            bullet.paint(g);
        }
    }

    public void clearBullets() {
        for (int i = this.mBullets.size() - 1; 0 <= i; --i) {
            GameCharacter bullet = this.mBullets.get(i);
            if (bullet == null) continue;
            bullet.kill();
        }
        this.mBullets.clear();
    }

    @Override
    public void finalize() {
        this.clearBullets();
        super.finalize();
    }
}

