/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.effect;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public class KirakiraEffect
extends Effect {
    private double mScale;
    private SKMColor mColor;

    public KirakiraEffect(double x, double y, SKMColor color) {
        super(x, y);
        this.mColor = color;
        this.mScale = 10.0;
        this.mLifeCount = 20;
    }

    public void setScale(double scale) {
        this.mScale = 10.0 * scale;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int[][] starXys = new int[][]{{-4, -1, 0, 1, 4, 1, 0, -1}, {0, -1, -6, -1, 0, 1, 6, 1}};
        int c = this.mLifeCount <= 0 ? SKMUtil.toInt(this.mScale) : SKMUtil.toInt(this.mScale * (double)(this.mLifeCount - this.mCount) / (double)this.mLifeCount);
        for (int i = 0; i < starXys[0].length; ++i) {
            starXys[0][i] = this.mDrawX + SKMUtil.toInt(c * starXys[0][i]);
            starXys[1][i] = this.mDrawY + SKMUtil.toInt(c * starXys[1][i]);
        }
        g.setColor(this.mColor);
        g.fillPolygon(starXys);
    }
}

