/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.image.RGBImageFilter;

public final class ChangeFilter
extends RGBImageFilter {
    private int mOldColor;
    private int mNewColor;
    private int[] mOldColors;
    private int[] mNewColors;

    public ChangeFilter(int oldColor, int newColor) {
        this.canFilterIndexColorModel = true;
        this.mOldColor = oldColor;
        this.mNewColor = newColor;
    }

    public ChangeFilter(int[] oldColors, int[] newColors) {
        this.canFilterIndexColorModel = true;
        if (oldColors != null && newColors != null && oldColors.length == newColors.length) {
            this.mOldColors = oldColors;
            this.mNewColors = newColors;
        }
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        if (this.mOldColors == null) {
            if (rgb == this.mOldColor) {
                return this.mNewColor;
            }
        } else {
            for (int i = this.mOldColors.length - 1; 0 <= i; --i) {
                if (this.mOldColors[i] != rgb) continue;
                return this.mNewColors[i];
            }
        }
        return rgb;
    }
}

