/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import jp.ne.sk_mine.util.andr_applet.SKMStringFuncs;
import jp.ne.sk_mine.util.sound.Player;
import jp.ne.sk_mine.util.sound.WavePlayer;

public class SoundPlayer
extends Player {
    private WavePlayer wavePlayer_ = new WavePlayer();
    private String basePath_;

    public void setBasePath(String path) {
        this.basePath_ = path;
    }

    public String getBasePath() {
        return this.basePath_;
    }

    @Override
    public boolean loadFromList(String listFilename) {
        if (this.basePath_ != null && listFilename.indexOf(this.basePath_) != 0) {
            return this.loadFromList(this.basePath_ + listFilename, this.basePath_);
        }
        return super.loadFromList(listFilename);
    }

    @Override
    public boolean load(String name, String resourceName) {
        String extension = SKMStringFuncs.getExtensionLowerCase(resourceName);
        if (extension.equals("wav") || extension.equals("au")) {
            return this.wavePlayer_.load(name, resourceName);
        }
        return false;
    }

    @Override
    public boolean load(String name, String resourceName, int loopStartPos) {
        return this.load(name, resourceName);
    }

    @Override
    public void preload() {
        this.wavePlayer_.preload();
    }

    @Override
    public void preload(String name) {
        if (this.wavePlayer_.hasName(name)) {
            this.wavePlayer_.preload(name);
        }
    }

    @Override
    public boolean hasName(String name) {
        return this.wavePlayer_.hasName(name);
    }

    @Override
    public boolean isPlayable() {
        return this.wavePlayer_.isPlayable();
    }

    @Override
    public void setPlayable(boolean f) {
        this.wavePlayer_.setPlayable(f);
    }

    @Override
    public boolean isEnabled() {
        return this.isPlayable();
    }

    @Override
    public void setEnabled(boolean f) {
        this.setPlayable(f);
    }

    @Override
    public void play(String name, boolean isLoop, Player.PlayMode playMode) {
        if (this.wavePlayer_.hasName(name)) {
            this.wavePlayer_.play(name, isLoop, playMode);
        }
    }

    @Override
    public void stop(String name) {
        if (this.wavePlayer_.hasName(name)) {
            this.wavePlayer_.stop(name);
        }
    }

    @Override
    public void stopAll() {
        this.wavePlayer_.stopAll();
    }

    @Override
    public void finalize() {
        this.wavePlayer_.finalize();
    }
}

