/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKMMath;

public final class SKMMineUtil {
    public static final int NAME_MAX = 16;
    public static final int PASSWORD_MAX = 16;
    public static final int DIR_NONE = 0;
    public static final int DIR_UP = 1;
    public static final int DIR_RIGHT = 2;
    public static final int DIR_DOWN = 4;
    public static final int DIR_LEFT = 8;
    public static final int DIR_UP_RIGHT = 3;
    public static final int DIR_DOWN_RIGHT = 6;
    public static final int DIR_DOWN_LEFT = 12;
    public static final int DIR_UP_LEFT = 9;
    public static final char[] INVALID_LETTERS = new char[]{',', '.', '+', '*', '\"', '\'', '`', '\\', '<', '\t'};

    public static boolean includesInvalidLetter(String string) {
        for (int i = INVALID_LETTERS.length - 1; i >= 0; --i) {
            if (string.indexOf(INVALID_LETTERS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInputString(String name) {
        if (SKMMineUtil.includesInvalidLetter(name)) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ' || name.charAt(i) == '\t') continue;
            return true;
        }
        return false;
    }

    public static String getValidString(String string) {
        return SKMMineUtil.getValidString(string, '\u0000');
    }

    public static String getValidString(String string, char replaceLetter) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int j = 0;
            for (j = 0; j < INVALID_LETTERS.length && c != INVALID_LETTERS[j]; ++j) {
            }
            if (j == INVALID_LETTERS.length) {
                buf.append(c);
                continue;
            }
            if (replaceLetter == '\u0000') continue;
            buf.append(replaceLetter);
        }
        return buf.toString();
    }

    public static String getInvalidLetters() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < INVALID_LETTERS.length; ++i) {
            if (INVALID_LETTERS[i] == '\t') {
                buf.append("(tab)");
                continue;
            }
            buf.append(INVALID_LETTERS[i]);
        }
        return buf.toString();
    }

    public static String encryptSimple(String str) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            buf.append((char)(str.charAt(i) + 3));
        }
        return buf.toString();
    }

    public static String decryptSimple(String encryptedStr) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < encryptedStr.length(); ++i) {
            buf.append((char)(encryptedStr.charAt(i) - 3));
        }
        return buf.toString();
    }

    public static boolean isUpOn(int dir) {
        return (dir & 1) != 0;
    }

    public static boolean isDownOn(int dir) {
        return (dir & 4) != 0;
    }

    public static boolean isLeftOn(int dir) {
        return (dir & 8) != 0;
    }

    public static boolean isRightOn(int dir) {
        return (dir & 2) != 0;
    }

    public static double getRadFromDir(int dir) {
        if (dir == 2) {
            return 0.0;
        }
        if (dir == 6) {
            return 0.7853981633974483;
        }
        if (dir == 4) {
            return 1.5707963267948966;
        }
        if (dir == 12) {
            return 2.356194490192345;
        }
        if (dir == 8) {
            return Math.PI;
        }
        if (dir == 9) {
            return 3.9269908169872414;
        }
        if (dir == 1) {
            return 4.71238898038469;
        }
        if (dir == 3) {
            return 5.497787143782138;
        }
        return 0.0;
    }

    public static int getOppositeDir(int dir) {
        if (dir == 1) {
            return 4;
        }
        if (dir == 3) {
            return 12;
        }
        if (dir == 2) {
            return 8;
        }
        if (dir == 6) {
            return 9;
        }
        if (dir == 4) {
            return 1;
        }
        if (dir == 12) {
            return 3;
        }
        if (dir == 8) {
            return 2;
        }
        if (dir == 9) {
            return 6;
        }
        return 0;
    }

    public static int getDirFromCellDiffs(int dCellX, int dCellY, boolean isEightDirs) {
        double dRad;
        int[] dirs;
        double rad = SKMMath.getRad(0.0, 0.0, dCellX, dCellY);
        if (rad < 0.0) {
            rad += Math.PI * 2;
        }
        if (isEightDirs) {
            dirs = new int[]{2, 6, 4, 12, 8, 9, 1, 3};
            dRad = 0.7853981633974483;
        } else {
            dirs = new int[]{2, 4, 8, 1};
            dRad = 1.5707963267948966;
        }
        for (int i = 0; i < dirs.length; ++i) {
            double checkRad = (double)i * dRad;
            if (!(checkRad - dRad / 2.0 <= rad) || !(rad < checkRad + dRad / 2.0)) continue;
            return dirs[i];
        }
        return 0;
    }

    public static int getRotatedDir(int dir, int n) {
        if (dir == 0 || n == 0) {
            return dir;
        }
        if (0 < n) {
            for (int i = n - 1; 0 <= i; --i) {
                dir = SKMMineUtil.getClockwiseDir(dir);
            }
        } else {
            for (int i = n - 1; 0 <= i; --i) {
                dir = SKMMineUtil.getCounterClockwiseDir(dir);
            }
        }
        return dir;
    }

    public static int getClockwiseDir(int dir) {
        if (dir == 1) {
            return 3;
        }
        if (dir == 3) {
            return 2;
        }
        if (dir == 2) {
            return 6;
        }
        if (dir == 6) {
            return 4;
        }
        if (dir == 4) {
            return 12;
        }
        if (dir == 12) {
            return 8;
        }
        if (dir == 8) {
            return 9;
        }
        if (dir == 9) {
            return 1;
        }
        return 0;
    }

    public static int getCounterClockwiseDir(int dir) {
        if (dir == 1) {
            return 9;
        }
        if (dir == 9) {
            return 8;
        }
        if (dir == 8) {
            return 12;
        }
        if (dir == 12) {
            return 4;
        }
        if (dir == 4) {
            return 6;
        }
        if (dir == 6) {
            return 2;
        }
        if (dir == 2) {
            return 3;
        }
        if (dir == 3) {
            return 1;
        }
        return 0;
    }

    public static int[] getCellDiffs(int dir) {
        if (dir == 1) {
            return new int[]{0, -1};
        }
        if (dir == 3) {
            return new int[]{1, -1};
        }
        if (dir == 2) {
            return new int[]{1, 0};
        }
        if (dir == 6) {
            return new int[]{1, 1};
        }
        if (dir == 4) {
            return new int[]{0, 1};
        }
        if (dir == 12) {
            return new int[]{-1, 1};
        }
        if (dir == 8) {
            return new int[]{-1, 0};
        }
        if (dir == 9) {
            return new int[]{-1, -1};
        }
        return new int[]{0, 0};
    }

    private SKMMineUtil() {
    }
}

