/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMLinearGradient;

public class CButton
extends SKMButton {
    public static final SKMFont sFont = new SKMFont(SKMFont.SERIF, SKMFont.BOLD, 18);
    public static final SKMColor sMouseOverColor = new SKMColor(240, 170, 120);
    public static final SKMColor sFrameColor = new SKMColor(140, 140, 140);
    protected boolean mIsDrawBackground;
    protected SKMColor mTopColor;
    protected SKMColor mBottomColor;

    @Deprecated
    public CButton(String text, int centerX, int centerY, SKMGraphics g) {
        this(text, centerX, centerY, sFont);
    }

    public CButton(String text) {
        this(text, -100, -100, sFont);
    }

    public CButton(String text, int centerX, int centerY) {
        this(text, centerX, centerY, sFont);
    }

    public CButton(String text, SKMFont font) {
        this(text, -100, -100, font);
    }

    public CButton(String text, int centerX, int centerY, SKMFont font) {
        super(text, centerX, centerY, true, font, SKM.getGraphics());
        this.setPadSize(20, 10);
        this.setTextColor(SKMColor.BLACK);
        this.setDrawFrame(true);
        this.setFrameColor(sFrameColor);
        this.setFrameColorOnMouseOver(sMouseOverColor);
        this.mIsDrawBackground = true;
        this.mTopColor = new SKMColor(255, 240, 240);
        this.mBottomColor = new SKMColor(180, 180, 180);
    }

    public CButton(SKMImage normalImage) {
        this(normalImage, 0, 0);
    }

    public CButton(SKMImage normalImage, int centerX, int centerY) {
        super(normalImage, centerX, centerY, true);
        this.setPadSize(0, 0);
        this.setFrameColor(sFrameColor);
        this.setFrameColorOnMouseOver(sMouseOverColor);
        this.mTopColor = new SKMColor(255, 240, 240);
        this.mBottomColor = new SKMColor(180, 180, 180);
    }

    public void setBackgroundColors(SKMColor topColor, SKMColor bottomColor) {
        this.mTopColor = topColor;
        this.mBottomColor = bottomColor;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.mTopColor != null) {
            this.mTopColor = new SKMColor(this.mTopColor.getRed(), this.mTopColor.getGreen(), this.mTopColor.getBlue(), alpha);
        }
        if (this.mBottomColor != null) {
            this.mBottomColor = new SKMColor(this.mBottomColor.getRed(), this.mBottomColor.getGreen(), this.mBottomColor.getBlue(), alpha);
        }
    }

    public void setDrawBackground(boolean f) {
        this.mIsDrawBackground = f;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mIsDrawBackground) {
            this.paintBackground(g);
        }
        super.myPaint(g);
    }

    protected void paintBackground(SKMGraphics g) {
        SKMColor topColor = this.mTopColor;
        SKMColor bottomColor = this.mBottomColor;
        if (this.mIsPressed || !this.mIsEnabled) {
            topColor = topColor.darker();
            bottomColor = bottomColor.darker();
        }
        SKMLinearGradient lg = new SKMLinearGradient((float)this.mX, (float)(this.mY - this.mPadH), topColor, (float)this.mX, this.mY + this.mHeight + 2 * this.mPadH, bottomColor);
        g.setGradient(lg);
        g.fillRoundRect(this.mX - this.mPadW, this.mY - this.mPadH, this.mWidth + 2 * this.mPadW, this.mHeight + 2 * this.mPadH, 6, 6);
        g.setGradient(null);
    }
}

