#include <cstdlib>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm> // std::sort
#include <string>
#include <conio.h> // _getch()gp邽߂ɕKv(Windows̂)
#include <cctype> // std::tolower

std::string replaceAll(const std::string& str, const std::string& from, const std::string& to);
long long factorial(long long n);
bool select_all(long long n);

int par_count;

int main(int argc, char* argv[]) {
	bool help_flag = false;
	bool random_flag = false;
	bool com_flag = false;
	int max_count = -1;
	long long max_order_index;
	long long max_operator_index;
	int** order_array;
	int** operator_array;

	for (int i = 1; i < argc; ++i) {
		// argv[i]char*^Ȃ̂ŁAstd::stringɕϊĂreplaceAllg
		std::string argStr = argv[i];
		for (auto& c : argStr) {
			c = static_cast<char>(std::tolower(static_cast<unsigned char>(c)));
		}
		if ("/h" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/") || "/?" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/") || "/help" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/")) {
			help_flag = true;
		} else if ("/r" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/") || "/rand" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/") || "/random" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/")) {
			random_flag = true;
		}
		else if ("/c" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/") || "/com" == replaceAll(replaceAll(argStr, "--", "-"), "-", "/")) {
			com_flag = true;
		} else {
			try {
				max_count = std::stoi(argStr);
			} catch (const std::invalid_argument&) {
				std::cout << "Invalid option or argument: " << argStr << std::endl;
				std::cout << "\nPlease press any key.\a\n " << std::endl;
				_getch(); // ͂GR[obNɎ擾
				std::exit(EXIT_FAILURE);
			}
		}
	}

	std::cout
		<< "\n\"Complete the formula C++\"    in C++\n\n" 
		<< "This program completes all the formulas when you input several parameters and one answer.\n"
		<< std::endl;

	if (help_flag) {
		std::cout 
			<< "Options:\n"
			<< "  /h, /help, /?       : [help mode]   Display this help message.\n"
			<< "  /r, /rand, /random  : [random mode] Randomly shuffle the order of parameters.\n"
			<< "  /c, /com            : [com mode]    Make the operator suitable for the computer.\n\n"
			<< "Arguments:\n"
			<< "  max_count           : An integer to set the Maximum number of candidates.\n\n"
			<< "Examples:\n"
			<< "  program_name /r 10  : Enable random mode with max_count set to 10.\n"
			<< "  program_name /c     : Enable com mode.\n"
			<< std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		std::exit(EXIT_SUCCESS);
	}

	std::string line;
	std::vector<long long> numbers;
	long long answer;
	std::cout
		<< "Please enter the numbers separated by spaces.\n"
		<< "num1 num2 num3 ... ans:"
		<< std::endl;
	std::getline(std::cin, line); // W͂1sǂݍ
	std::cout << std::endl;
	std::istringstream iss(line);
	std::string input;
	long long number;
	while (iss >> input) {
		try {
			number = std::stoll(input);
		} catch (const std::invalid_argument&) {
			std::cout << "Invalid number: " << input << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			std::exit(EXIT_FAILURE);
		} catch (const std::out_of_range&) {
			std::cout << "The number " << input << " is too large or too small." << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			std::exit(EXIT_FAILURE);
		} catch (...) {
			std::cout << "An unexpected error occurred while processing the number: " << input << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			std::exit(EXIT_FAILURE);
		}
		numbers.push_back(number);
	}
	if (3 > numbers.size()) {
		std::cout << "You must enter at least three numbers (including the answer)." << std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		std::exit(EXIT_FAILURE);
	}
	answer = numbers.back(); // Ō̗vf𓚂ƂĎ擾
	numbers.pop_back(); // xN^[폜
	if (random_flag) {
		std::sort(numbers.begin(), numbers.end());
	}
	par_count = numbers.size();

	long long min_item_number = long long(0);
	long long max_item_number = long long(0);
	for (int i = 0; i < par_count; ++i) {
		try {
			min_item_number *= long long(par_count + 1);
			min_item_number += long long(i + 1);
		} catch (const std::overflow_error&) {
			std::cout << "Too many numbers." << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			std::exit(EXIT_FAILURE);
		}
	}
	if (random_flag) {
		for (int i = par_count - 1; i >= 0; --i) {
			try {
				max_item_number *= long long(par_count + 1);
				max_item_number += long long(par_count);
			} catch (const std::overflow_error&) {
				std::cout << "Too many numbers." << std::endl;
				std::cout << "Please press any key.\a " << std::endl;
				_getch(); // ͂GR[obNɎ擾
				std::exit(EXIT_FAILURE);
			}
		}
	}
	else {
		max_item_number = min_item_number;
	}
	std::cout << std::endl;

	try {
		max_order_index = factorial(par_count - 1);
	} catch (const std::overflow_error&) {
		std::cout << "Too many numbers." << std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		std::exit(EXIT_FAILURE);
	}
	try {
		order_array = new int* [max_order_index];
	} catch (const std::bad_alloc&) {
		std::cout << "Too many numbers." << std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		std::exit(EXIT_FAILURE);
	}
	for (long long i = 0; i < max_order_index; ++i) {
		try
		{
			order_array[i] = new int[par_count - 1];

		} catch (const std::exception&) {
			std::cout << "Too many numbers." << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			for (long long j = 0; j < i; ++j) {
				delete[] order_array[j];
			}
			delete[] order_array;
			std::exit(EXIT_FAILURE);
		}
	}
	for (int i = 0; i < par_count - 1; ++i) {
		long long order_index = long long(0);
		long long l_max = factorial(long long(par_count - 2 - i));
		for (long long j = 0; j < max_order_index / long long(par_count - 1 - i) / l_max; ++j) {
			for (int k = 0; k < par_count - 1 - i; ++k) {
				for (int l = 0; l < l_max; ++l) {
					order_array[order_index][i] = k;
					++order_index;
				}
			}
		}
	}
	std::cout << "Array 1 creation OK." << std::endl;
/*
	for (long long index = 0; index < max_order_index; ++index) {
		std::cout << index << "\t";
		for (int i = 0; i < par_count - 1; ++i) {
			std::cout << order_array[index][i] << " ";
		}
		std::cout << std::endl;
	}
	std::cout << std::endl;
*/

	try {
		max_operator_index = long long(pow(4, par_count - 1));
	} catch (const std::overflow_error&) {
		std::cout << "Too many numbers." << std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		for (long long i = 0; i < par_count - 1; ++i) {
			delete[] order_array[i];
		}
		delete[] order_array;
		std::exit(EXIT_FAILURE);
	}
	try {
		operator_array = new int* [max_operator_index];
	} catch (const std::bad_alloc&) {
		std::cout << "Too many numbers." << std::endl;
		std::cout << "Please press any key.\a " << std::endl;
		_getch(); // ͂GR[obNɎ擾
		for (long long i = 0; i < par_count - 1; ++i) {
			delete[] order_array[i];
		}
		delete[] order_array;
		std::exit(EXIT_FAILURE);
	}
	for (long long i = 0; i < max_operator_index; ++i) {
		try
		{
			operator_array[i] = new int[par_count - 1];

		} catch (const std::exception&) {
			std::cout << "Too many numbers." << std::endl;
			std::cout << "Please press any key.\a " << std::endl;
			_getch(); // ͂GR[obNɎ擾
			for (long long j = 0; j < i; ++j) {
				delete[] operator_array[j];
			}
			delete[] operator_array;
			for (long long k = 0; k < par_count - 1; ++k) {
				delete[] order_array[k];
			}
			delete[] order_array;
			std::exit(EXIT_FAILURE);
		}
	}
	for (int i = 0; i < par_count - 1; ++i) {
		long long operator_index = long long(0);
		long long l_max = long long(pow(4, par_count - 2 - i));
		long long times = long long(pow(4, i));
		for (long long j = 0; j < times; ++j) {
			for (int k = 0; k < 4; ++k) {
				for (int l = 0; l < l_max; ++l) {
					operator_array[operator_index][i] = k;
					++operator_index;
				}
			}
		}
	}
	std::cout << "Array 2 creation OK." << std::endl;
/*
	for (long long index = 0; index < max_operator_index; ++index) {
		std::cout << index << "\t";
		for (int i = 0; i < par_count - 1; ++i) {
			std::cout << operator_array[index][i] << " ";
		}
		std::cout << std::endl;
	}
	std::cout << std::endl;
*/

	std::cout << std::endl;
	std::cout << "Calculation started ****************" << std::endl;
	std::string par_list_str = ",";
	for (long long order_number = min_item_number; order_number <= max_item_number; ++order_number) {
		if (0 == max_count) {
			break;
		}
		if (!select_all(order_number)) {
			continue;
		}
		int* par = new int[par_count];
		int* operator_number = new int[par_count - 1];
		std::string* cal_str = new std::string[par_count];
		long double* cal_value = new long double[par_count];
		bool* addition_or_subtraction = new bool[par_count];
		bool* division = new bool[par_count];
		
		long long n = order_number;
		std::string par_str = "";
		std::string ans_str;
		for (int i = par_count - 1; i >= 0; --i) {
			int m = int(n % long long(par_count + 1));
			n /= long long(par_count + 1);
			par[i] = numbers[m - 1];
			par_str += std::to_string(numbers[m - 1]) + " ";
		}
		if (par_list_str.find("," + par_str + ",") != std::string::npos) {
			continue;
		} else {
			par_list_str += par_str + ",";
			ans_str = ",";
		}
		for (long long order_index = 0; order_index < max_order_index; ++order_index) {
			if (0 == max_count) {
				break;
			}
			for (long long operator_index = 0; operator_index < max_operator_index; ++operator_index) {
				if (0 == max_count) {
					break;
				}
				for (int i = 0; i < par_count - 1; ++i) {
					operator_number[i] = operator_array[operator_index][i];
				}
				for (int i = 0; i < par_count; ++i) {
					cal_value[i] = long double(par[i]);
					if (0 > par[i]) {
						cal_str[i] = "(" + std::to_string(par[i]) + ")";
					} else {
						cal_str[i] = std::to_string(par[i]);
					}
					addition_or_subtraction[i] = false;
					division[i] = false;
				}
				int count = par_count;
				for (int order = 0; order < par_count - 1; ++order) {
					if (0 == max_count) {
						break;
					}
					int point = order_array[order_index][order];
					if (0 == operator_number[point]) {
						cal_str[point] += "+" + cal_str[point + 1];
						try {
							cal_value[point] += cal_value[point + 1];
						} catch (const std::overflow_error&) {
							break;
						}
						addition_or_subtraction[point] = true;
						division[point] = false;
					} else if (1 == operator_number[point]) {
						if (addition_or_subtraction[point + 1]) {
							cal_str[point + 1] = "(" + cal_str[point + 1] + ")";
						}
						cal_str[point] += "-" + cal_str[point + 1];
						try {
							cal_value[point] -= cal_value[point + 1];
						} catch (const std::overflow_error&) {
							break;
						}
						addition_or_subtraction[point] = true;
						division[point] = false;
					} else if (2 == operator_number[point]) {
						if (addition_or_subtraction[point]) {
							cal_str[point] = "(" + cal_str[point] + ")";
						}
						if (addition_or_subtraction[point + 1]) {
							cal_str[point + 1] = "(" + cal_str[point + 1] + ")";
						}
						if (com_flag) {
							cal_str[point] += "*" + cal_str[point + 1];
						} else {
							cal_str[point] += "~" + cal_str[point + 1];
						}
						try {
							cal_value[point] *= cal_value[point + 1];
						} catch (const std::overflow_error&) {
							break;
						}
						addition_or_subtraction[point] = false;
						division[point] = false;
					} else {
						if (addition_or_subtraction[point]) {
							cal_str[point] = "(" + cal_str[point] + ")";
						}
						if (addition_or_subtraction[point + 1]) {
							cal_str[point + 1] = "(" + cal_str[point + 1] + ")";
						}
						if (division[point + 1]) {
							cal_str[point + 1] = "(" + cal_str[point + 1] + ")";
						}
						if (com_flag) {
							cal_str[point] += "/" + cal_str[point + 1];
						} else {
							cal_str[point] += "" + cal_str[point + 1];
						}
						try {
							cal_value[point] /= cal_value[point + 1];
						} catch (const std::overflow_error&) {
							break;
						} catch (...) {
							break;
						}
						addition_or_subtraction[point] = false;
						division[point] = true;
					}
					--count;
					for (int i = point + 1; i < count; ++i) {
						cal_str[i] = cal_str[i + 1];
						cal_value[i] = cal_value[i + 1];
						addition_or_subtraction[i] = addition_or_subtraction[i + 1];
						division[i] = division[i + 1];
					}
					for (int i = point; i < count - 1; ++i) {
						operator_number[i] = operator_number[i + 1];
					}
				}
				if (cal_value[0] == long double(answer) && 1 == count) {
					if (ans_str.find("," + cal_str[0] + ",") == std::string::npos) {
						ans_str += cal_str[0] + ",";
						std::cout << cal_str[0] << " = " << answer << std::endl;
						if (0 < max_count) {
							--max_count;
						}
					}
				}
			}
		}
	}
	std::cout << "Calculation complete ****************" << std::endl;
	std::cout << std::endl;

	for (long long i = 0; i < par_count - 1; ++i) {
		delete[] order_array[i];
	}
	delete[] order_array;
	for (long long i = 0; i < par_count - 1; ++i) {
		delete[] operator_array[i];
	}
	delete[] operator_array;
	std::cout << "Please press any key.\a " << std::endl;
	_getch(); // ͂GR[obNɎ擾
	return 0; // vO̐I
}

std::string replaceAll(const std::string& str, const std::string& from, const std::string& to) {
	std::string result = str;
	size_t pos = 0;
	while ((pos = result.find(from, pos)) != std::string::npos) {
		result.replace(pos, from.length(), to);
		pos += to.length(); // ̈ʒuɐi
	}
	return result;
}

long long factorial(long long n) {
	if (n <= 1) return long long(1);
	return n * factorial(n - 1);
}

bool select_all(long long n) {
    bool* selected = new bool[par_count];
    bool result = true;
    int m;
    for (int i = 0; i < par_count; ++i) {
        selected[i] = false;
    }
    for (int i = par_count - 1; i >= 0; --i) {
        m = int(n % long long(par_count + 1));
        n /= long long(par_count + 1);
        for (int j = 0; j < par_count; ++j) {
            if (m == j + 1) {
                selected[j] = true;
                break;
            }
        }
    }
	for (int i = 0; i < par_count; ++i) {
		if (!selected[i]) {
			result = false;
			break;
		}
	}
    delete[] selected;    // Kvɉ selected ̃ǉ
    return result;
}