/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.ButtonCallback;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMButton
extends SKMUI {
    protected static final SKMFont sBaseFont = new SKMFont(14);
    protected static SKMColor sDisabledColor = new SKMColor(0, 0, 0, 150);
    protected static boolean sIsUseDarkCover = false;
    protected boolean mIsMouseOverEnabled;
    protected boolean mIsMouseOver;
    protected boolean mIsDownOnPressed;
    protected boolean mIsDrawFrame;
    protected boolean mIsTextRounded;
    protected boolean mIsTextCentering;
    protected boolean mIsUseDarkCover;
    protected boolean mIsCenteringImage;
    protected boolean mIsReverseImageHorizontal;
    protected boolean mIsReverseImageVertical;
    protected int mCenterX;
    protected int mCenterY;
    protected int mPadW;
    protected int mPadH;
    protected int mPressedDY;
    protected float mFrameWidth;
    protected String mText;
    protected String mValue;
    protected String[] mTexts;
    protected SKMColor mTextColor;
    protected SKMColor mDisabledTextColor;
    protected SKMColor mTextRoundColor;
    protected SKMColor mFrameColor;
    protected SKMColor mFrameColorOnMouseOver;
    protected SKMFont mFont;
    protected SKMImage mImage;
    protected SKMImage mPressedImage;
    protected SKMImage mDisabledImage;
    protected ButtonCallback mCallback;

    public static void setDisabledColor(SKMColor color) {
        sDisabledColor = color;
    }

    public static void setDefaultUseDarkCover(boolean f) {
        sIsUseDarkCover = f;
    }

    public static int setSameWidth(int minWidth, SKMArray buttons) {
        SKMButton[] array = new SKMButton[buttons.size()];
        for (int i = 0; i < buttons.size(); ++i) {
            array[i] = (SKMButton)buttons.get(i);
        }
        return SKMButton.setSameWidth(minWidth, array);
    }

    public static int setSameWidth(int minWidth, SKMButton ... buttons) {
        int i;
        int width = buttons[0].mWidth;
        for (i = 1; i < buttons.length; ++i) {
            if (buttons[i] == null || width >= buttons[i].mWidth) continue;
            width = buttons[i].mWidth;
        }
        if (width < minWidth) {
            width = minWidth;
        }
        for (i = 0; i < buttons.length; ++i) {
            if (buttons[i] == null) continue;
            buttons[i].mWidth = width;
        }
        return width;
    }

    public SKMButton(String text) {
        this(text, -100, -100, false, sBaseFont, SKM.getGraphics());
    }

    public SKMButton(String text, int x, int y, boolean isCenterCoord, SKMFont font) {
        this(text, x, y, isCenterCoord, font == null ? sBaseFont : font, SKM.getGraphics());
    }

    public SKMButton(String text, int x, int y, boolean isCenterCoord, SKMFont font, SKMGraphics g) {
        if (font == null) {
            font = sBaseFont;
        }
        this.mFont = font;
        this.init(text, x, y, 0, 0, isCenterCoord);
    }

    public SKMButton(String text, int x, int y, int w, int h, boolean isCenterCoord) {
        this.init(text, x, y, w, h, isCenterCoord);
    }

    public SKMButton(SKMImage image) {
        this(image, -100, -100, false);
    }

    public SKMButton(SKMImage image, int x, int y, boolean isCenterCoord) {
        int w = 0;
        int h = 0;
        if (image != null) {
            w = image.getWidth();
            h = image.getHeight();
        }
        this.init(image, x, y, w, h, isCenterCoord);
    }

    public SKMButton(SKMImage image, int x, int y, int w, int h, boolean isCenterCoord) {
        this.init(image, x, y, w, h, isCenterCoord);
    }

    public SKMButton(String text, SKMImage image, int x, int y, boolean isCenterCoord) {
        this.setText(text);
        int w = 0;
        int h = 0;
        if (image != null) {
            w = image.getWidth();
            h = image.getHeight();
        }
        this.init(image, x, y, w, h, isCenterCoord);
    }

    public SKMButton(String text, SKMImage image, int x, int y, int w, int h, boolean isCenterCoord) {
        this.setText(text);
        this.init(image, x, y, w, h, isCenterCoord);
    }

    protected void init(String text, int x, int y, int w, int h, boolean isCenterCoord) {
        this.setText(text);
        this.initBase(x, y, w, h, isCenterCoord);
    }

    protected void init(SKMImage image, int x, int y, int w, int h, boolean isCenterCoord) {
        this.mImage = image;
        this.initBase(x, y, w, h, isCenterCoord);
    }

    protected void initBase(int x, int y, int w, int h, boolean isCenterCoord) {
        if (w != 0 && h != 0 || this.mFont == null) {
            this.mWidth = w;
            this.mHeight = h;
        } else {
            this.setFont(this.mFont);
        }
        if (isCenterCoord) {
            this.setCenterXY(x, y);
        } else {
            this.setXY(x, y);
        }
        this.mIsVisible = true;
        this.mIsEnabled = true;
        this.mIsMouseOverEnabled = true;
        this.mIsTextCentering = true;
        this.mIsUseDarkCover = sIsUseDarkCover;
        this.mTextColor = SKMColor.BLACK;
        this.mDisabledTextColor = SKMColor.BLACK;
        this.mTextRoundColor = SKMColor.WHITE;
        this.mFrameColor = new SKMColor(140, 140, 140);
        this.mFrameColorOnMouseOver = SKMColor.ORANGE;
        this.mPressedDY = 2;
        this.mFrameWidth = 2.0f;
    }

    @Override
    public void setX(int x) {
        super.setX(x + this.mPadW);
        this.mCenterX = x + this.mPadW + this.mWidth / 2;
    }

    @Override
    public int getX() {
        return this.mX - this.mPadW;
    }

    @Override
    public void setY(int y) {
        super.setY(y + this.mPadH);
        this.mCenterY = y + this.mPadH + this.mHeight / 2;
    }

    @Override
    public int getY() {
        return this.mY - this.mPadH;
    }

    @Override
    public void setXY(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void setCenterXY(int x, int y) {
        this.mX = x - this.mWidth / 2;
        this.mY = y - this.mHeight / 2;
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public int getCenterX() {
        return this.mCenterX;
    }

    public int getCenterY() {
        return this.mCenterY;
    }

    public int getCoreWidth() {
        return this.mWidth;
    }

    public int getCoreHeight() {
        return this.mHeight;
    }

    public void setPadWidth(int w) {
        this.mPadW = w;
    }

    public int getPadWidth() {
        return this.mPadW;
    }

    public void setPadHeight(int h) {
        this.mPadH = h;
    }

    public int getPadHeight() {
        return this.mPadH;
    }

    public void setPadSize(int w, int h) {
        this.setPadWidth(w);
        this.setPadHeight(h);
    }

    @Override
    public int getWidth() {
        return this.mWidth + 2 * this.mPadW;
    }

    @Override
    public int getHeight() {
        return this.mHeight + 2 * this.mPadH;
    }

    @Override
    public boolean setVisible(boolean f) {
        boolean ret = super.setVisible(f);
        if (f) {
            this.mIsMouseOver = false;
            this.mIsPressed = false;
        }
        return ret;
    }

    public void setMouseOverEnabled(boolean f) {
        this.mIsMouseOverEnabled = f;
    }

    public boolean isMouseOverEnabled() {
        return this.mIsMouseOverEnabled;
    }

    public boolean setMouseOver(boolean f) {
        boolean ret;
        if (!this.mIsMouseOverEnabled) {
            return false;
        }
        boolean bl = ret = this.mIsVisible && f != this.mIsMouseOver;
        if (this.mIsVisible) {
            this.mIsMouseOver = f;
        }
        return ret;
    }

    public boolean isMouseOver() {
        return this.mIsMouseOver;
    }

    public void setCenteringText(boolean f) {
        this.mIsTextCentering = f;
    }

    public void setFont(SKMFont font) {
        this.mFont = font;
        SKMGraphics g = new SKMGraphics(null, SKM.getGraphics().getGraphics());
        g.setFont(this.mFont);
        this.mWidth = g.stringWidth(this.mText);
        this.mHeight = g.stringHeight();
    }

    public SKMFont getFont() {
        return this.mFont;
    }

    @Deprecated
    public SKMFont getSKMFont() {
        return this.mFont;
    }

    public void setTextColor(SKMColor color) {
        this.mTextColor = color;
    }

    public SKMColor getTextColor() {
        return this.mTextColor;
    }

    @Deprecated
    public SKMColor getTextSKMColor() {
        return this.mTextColor;
    }

    public void setDisabledTextColor(SKMColor color) {
        this.mDisabledTextColor = color;
    }

    public SKMColor getDisabledTextColor() {
        return this.mDisabledTextColor;
    }

    public void setUseDarkCover(boolean f) {
        this.mIsUseDarkCover = f;
    }

    public void setCenteringImage(boolean f) {
        this.mIsCenteringImage = f;
    }

    public void setReverseImageHorizontal(boolean f) {
        this.mIsReverseImageHorizontal = f;
    }

    public void setReverseImageVertical(boolean f) {
        this.mIsReverseImageVertical = f;
    }

    public void setText(String text) {
        this.mText = text;
        this.mTexts = text.split("\n");
    }

    public String getText() {
        return this.mText;
    }

    public void setFrameWidth(float width) {
        this.mFrameWidth = width;
    }

    public void setFrameColor(SKMColor color) {
        this.mFrameColor = color;
    }

    public SKMColor getFrameColor() {
        return this.mFrameColor;
    }

    @Deprecated
    public SKMColor getFrameSKMColor() {
        return this.mFrameColor;
    }

    public void setFrameColorOnMouseOver(SKMColor color) {
        this.mFrameColorOnMouseOver = color;
    }

    @Deprecated
    public void setFrameSKMColorOnMouseOver(SKMColor color) {
        this.mFrameColorOnMouseOver = color;
    }

    public SKMColor getFrameColorOnMouseOver() {
        return this.mFrameColorOnMouseOver;
    }

    @Deprecated
    public SKMColor getFrameSKMColorOnMouseOver() {
        return this.mFrameColorOnMouseOver;
    }

    public void setImage(SKMImage image) {
        this.mImage = image;
    }

    public void setDownOnPressed(boolean f) {
        this.mIsDownOnPressed = f;
    }

    public void setPressedDY(int dy) {
        this.mPressedDY = dy;
    }

    public void setPressedImage(SKMImage image) {
        this.mPressedImage = image;
    }

    public void setDisabledImage(SKMImage image) {
        this.mDisabledImage = image;
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public String getValue() {
        return this.mValue;
    }

    @Override
    public boolean isHit(double mx, double my, boolean isPress, boolean isJudgeOnly) {
        boolean ret;
        if (isPress && !this.mIsVisibleInApp) {
            return false;
        }
        boolean bl = ret = (isJudgeOnly || this.mIsEnabled && this.mIsVisible) && (double)(this.mX - this.mPadW) <= (mx -= (double)this.mOffsetX) && mx <= (double)(this.mX + this.mWidth + this.mPadW) && (double)(this.mY - this.mPadH) <= (my -= (double)this.mOffsetY) && my <= (double)(this.mY + this.mHeight + this.mPadH);
        if (!isJudgeOnly && isPress) {
            this.setPressed(ret);
        }
        return ret;
    }

    public void setDrawFrame(boolean f) {
        this.mIsDrawFrame = f;
    }

    public void setTextRounded(boolean f) {
        this.mIsTextRounded = f;
    }

    public void setTextRoundColor(SKMColor color) {
        this.mTextRoundColor = color;
    }

    public void setButtonCallback(ButtonCallback cb) {
        this.mCallback = cb;
    }

    public void pressed() {
        if (this.mCallback != null) {
            this.mCallback.pressed();
        }
    }

    public void setAlpha(int alpha) {
        if (this.mTextColor != null) {
            this.setTextColor(new SKMColor(this.mTextColor.getRed(), this.mTextColor.getGreen(), this.mTextColor.getBlue(), alpha));
        }
        if (this.mDisabledTextColor != null) {
            this.setDisabledTextColor(new SKMColor(this.mDisabledTextColor.getRed(), this.mDisabledTextColor.getGreen(), this.mDisabledTextColor.getBlue(), alpha));
        }
        if (this.mTextRoundColor != null) {
            this.setTextRoundColor(new SKMColor(this.mTextRoundColor.getRed(), this.mTextRoundColor.getGreen(), this.mTextRoundColor.getBlue(), alpha));
        }
        if (this.mFrameColor != null) {
            this.setFrameColor(new SKMColor(this.mFrameColor.getRed(), this.mFrameColor.getGreen(), this.mFrameColor.getBlue(), alpha));
        }
        if (this.mFrameColorOnMouseOver != null) {
            this.setFrameColorOnMouseOver(new SKMColor(this.mFrameColorOnMouseOver.getRed(), this.mFrameColorOnMouseOver.getGreen(), this.mFrameColorOnMouseOver.getBlue(), alpha));
        }
        if (this.mImage != null) {
            this.mImage.setAlpha(alpha);
        }
        if (this.mPressedImage != null) {
            this.mPressedImage.setAlpha(alpha);
        }
        if (this.mDisabledImage != null) {
            this.mDisabledImage.setAlpha(alpha);
        }
    }

    @Override
    public void paint(SKMGraphics g) {
        if (!this.mIsVisible || !this.mIsVisibleInApp) {
            return;
        }
        boolean isPressed = this.mIsPressed;
        if (this.mIsDownOnPressed && isPressed) {
            this.mY += this.mPressedDY;
        }
        this.myPaint(g);
        if (this.mIsDownOnPressed && isPressed) {
            this.mY -= this.mPressedDY;
        }
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        boolean isOffsetSet;
        boolean bl = isOffsetSet = this.mOffsetX != 0 || this.mOffsetY != 0;
        if (isOffsetSet) {
            g.saveTransform();
            g.translate(this.mOffsetX, this.mOffsetY);
        }
        if (this.mImage != null) {
            if (!this.mIsEnabled && this.mDisabledImage != null) {
                if (this.mIsCenteringImage) {
                    g.drawCenteringImage(this.mDisabledImage, this.mCenterX, this.mCenterY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                } else {
                    g.drawImage(this.mDisabledImage, this.mX, this.mY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                }
            } else if (this.mIsPressed && this.mPressedImage != null) {
                if (this.mIsCenteringImage) {
                    g.drawCenteringImage(this.mPressedImage, this.mCenterX, this.mCenterY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                } else {
                    g.drawImage(this.mPressedImage, this.mX, this.mY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                }
            } else {
                if (this.mIsCenteringImage) {
                    g.drawCenteringImage(this.mImage, this.mCenterX, this.mCenterY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                } else {
                    g.drawImage(this.mImage, this.mX, this.mY, this.mIsReverseImageHorizontal, this.mIsReverseImageVertical);
                }
                if (this.mIsUseDarkCover && !this.mIsDrawFrame && (!this.mIsEnabled || this.mIsPressed)) {
                    g.setColor(sDisabledColor);
                    g.fillRect(this.mX, this.mY, this.mWidth, this.mHeight);
                }
            }
        }
        if (this.mText != null) {
            if (this.mFont != null) {
                g.setFont(this.mFont);
            }
            if (this.mIsEnabled) {
                if (this.mTextColor != null) {
                    g.setColor(this.mTextColor);
                }
            } else if (this.mDisabledTextColor != null) {
                g.setColor(this.mDisabledTextColor);
            }
            this.paintText(g);
        }
        if (this.mIsDrawFrame) {
            this.paintRoundFrame(g);
        }
        if (isOffsetSet) {
            g.restoreTransform();
        }
    }

    protected void paintText(SKMGraphics g) {
        if (this.mTexts == null) {
            if (this.mText != null) {
                this.mTexts = this.mText.split("\n");
            } else {
                return;
            }
        }
        int lineH = SKMUtil.toInt(1.3 * (double)this.mFont.getSize());
        int baseCx = this.mX;
        int topCy = this.mY + this.mHeight / 2 - SKMUtil.toInt(this.mTexts.length / 2) * lineH / 2;
        if (this.mIsTextCentering) {
            if (this.mIsTextRounded) {
                for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                    g.drawCenteringRoundedString(this.mTexts[i], baseCx + this.mWidth / 2, topCy + i * lineH, this.mTextColor, this.mTextRoundColor);
                }
            } else {
                for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                    g.drawCenteringString(this.mTexts[i], baseCx + this.mWidth / 2, topCy + i * lineH);
                }
            }
        } else if (this.mIsTextRounded) {
            for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                g.drawCenteringRoundedString(this.mTexts[i], baseCx + g.stringWidth(this.mTexts[i]) / 2, topCy + i * lineH, this.mTextColor, this.mTextRoundColor);
            }
        } else {
            for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                g.drawCenteringString(this.mTexts[i], baseCx + g.stringWidth(this.mText) / 2, topCy + i * lineH);
            }
        }
    }

    protected void paintRoundFrame(SKMGraphics g) {
        int hw = SKMUtil.toInt(this.mFrameWidth / 2.0f);
        if (this.mIsUseDarkCover && (!this.mIsEnabled || this.mIsPressed)) {
            g.setColor(sDisabledColor);
            g.fillRoundRect(this.mX - this.mPadW + hw, this.mY - this.mPadH + hw, this.mWidth + 2 * this.mPadW - 2 * hw, this.mHeight + 2 * this.mPadH - 2 * hw, 6, 6);
        }
        g.saveStroke();
        g.setStroke(this.mFrameWidth);
        g.setColor(this.mIsMouseOver ? this.mFrameColorOnMouseOver : this.mFrameColor);
        g.drawRoundRect(this.mX - this.mPadW + hw, this.mY - this.mPadH + hw, this.mWidth + 2 * this.mPadW - 2 * hw, this.mHeight + 2 * this.mPadH - 2 * hw, 6, 6);
        g.restoreStroke();
    }
}

