/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMLinearGradient;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMSlider
extends SKMUI {
    private final int mBarWidth = 16;
    private final int mMinMaxBarWidth = 4;
    private boolean mIsPaintMinMaxBar;
    private int mMinPosition;
    private int mMaxPosition;
    private int mBarPosition;
    private double mMinValue;
    private double mMaxValue;
    private double mValue;
    private SKMImage mMinIcon;
    private SKMImage mMaxIcon;

    public SKMSlider(double minValue, double maxValue, double value) {
        this.mMinValue = minValue;
        this.mMaxValue = maxValue;
        this.mMinPosition = 12;
        this.setValue(value);
    }

    public void setIcons(SKMImage minIcon, SKMImage maxIcon) {
        this.mMinIcon = minIcon;
        this.mMaxIcon = maxIcon;
        this.mMinPosition = minIcon.getWidth() + 8;
        this.mMaxPosition = this.mWidth - maxIcon.getWidth() - 8;
    }

    @Override
    public void setWidth(int w) {
        super.setWidth(w);
        this.mMaxPosition = this.mMaxIcon == null ? w - 4 - 8 : this.mWidth - this.mMaxIcon.getWidth() - 8;
        this.setValue(this.mValue);
    }

    @Override
    public void setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public void setValue(double value) {
        if (value < this.mMinValue) {
            value = this.mMinValue;
        }
        if (this.mMaxValue < value) {
            value = this.mMaxValue;
        }
        this.mValue = value;
        this.mBarPosition = SKMUtil.toInt((double)(this.mMaxPosition - this.mMinPosition) * (this.mValue - this.mMinValue) / (this.mMaxValue - this.mMinValue)) + this.mMinPosition;
    }

    public double getValue() {
        return this.mValue;
    }

    public void setMinValue(double value) {
        this.mMinValue = value;
        this.setValue(this.mValue);
    }

    public void setMaxValue(double value) {
        this.mMaxValue = value;
        this.setValue(this.mValue);
    }

    public void setBarPosition(double mx, double my) {
        if ((mx -= (double)this.mX) < (double)this.mMinPosition) {
            mx = this.mMinPosition;
        } else if ((double)this.mMaxPosition < mx) {
            mx = this.mMaxPosition;
        }
        this.setValue((mx - (double)this.mMinPosition) * (this.mMaxValue - this.mMinValue) / (double)(this.mMaxPosition - this.mMinPosition) + this.mMinValue);
    }

    @Override
    public boolean isHit(double mx, double my) {
        boolean ret;
        if (!this.mIsVisible || !this.mIsEnabled) {
            return false;
        }
        int padding = 10;
        this.mIsPressed = ret = (double)(this.mX + this.mBarPosition - 8 - 10) <= mx && mx <= (double)(this.mX + this.mBarPosition + 8 + 10) && (double)(this.mY + 3 - 10) <= my && my <= (double)(this.mY + this.mHeight - 6 + 10);
        return ret;
    }

    public boolean isHitWholeSlider(double mx, double my) {
        if (!this.mIsVisible || !this.mIsEnabled) {
            return false;
        }
        return (double)this.mX <= mx && mx <= (double)(this.mX + this.mWidth) && (double)this.mY <= my && my <= (double)(this.mY + this.mHeight);
    }

    @Override
    public void paint(SKMGraphics g) {
        if (!this.mIsVisible) {
            return;
        }
        int guideLeftX = this.mX + this.mMinPosition - 8;
        int guideTopY = this.mY + 6;
        int guideW = this.mMaxPosition - this.mMinPosition + 16;
        int guideH = this.mHeight - 12;
        int[][] barXys = new int[][]{{guideLeftX, guideLeftX + guideW, guideLeftX + guideW}, {guideTopY + guideH / 2, guideTopY, guideTopY + guideH}};
        g.setColor(new SKMColor(80, 60, 60));
        g.fillPolygon(barXys);
        if (this.mMinIcon != null) {
            g.drawImage(this.mMinIcon, this.mX, this.mY + (this.mHeight - this.mMinIcon.getHeight()) / 2);
        } else if (this.mIsPaintMinMaxBar) {
            g.fillRect(this.mX, this.mY, 4, this.mHeight);
        }
        if (this.mMaxIcon != null) {
            g.drawImage(this.mMaxIcon, this.mX + this.mWidth - this.mMaxIcon.getWidth(), this.mY + (this.mHeight - this.mMaxIcon.getHeight()) / 2);
        } else if (this.mIsPaintMinMaxBar) {
            g.fillRect(this.mX + this.mWidth - 4, this.mY, 4, this.mHeight);
        }
        SKMColor upColor = new SKMColor(255, 230, 220);
        SKMColor downColor = new SKMColor(140, 130, 110);
        if (this.mIsPressed || !this.mIsEnabled) {
            upColor = upColor.darker();
            downColor = downColor.darker();
        }
        SKMLinearGradient lg = new SKMLinearGradient((float)this.mX, (float)this.mY, upColor, (float)this.mX, this.mY + this.mHeight, downColor);
        g.setGradient(lg);
        g.fillRect(this.mX + this.mBarPosition - 8 + 1, this.mY + 3 + 1, 14, this.mHeight - 6 - 2);
        g.setGradient(null);
        g.setColor(SKMColor.GRAY);
        g.saveStroke();
        g.setStroke(2.0f);
        g.drawRoundRect(this.mX + this.mBarPosition - 8, this.mY + 3, 16, this.mHeight - 6, 6, 6);
        g.restoreStroke();
    }
}

