/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class DirectionButton
extends SKMButton {
    public static final int TYPE_8DIR = 0;
    public static final int TYPE_4DIR = 1;
    public static final int TYPE_ANALOG = 2;
    private int mType;
    private int mDir;
    private double mRad;
    private SKMColor mOnColor;
    private SKMColor mOffColor;

    public DirectionButton(int x, int y) {
        this(x, y, 100, 0);
    }

    public DirectionButton(int x, int y, int size) {
        this(x, y, size, 0);
    }

    public DirectionButton(int x, int y, int size, int type) {
        super("", x, y, false, null);
        this.mWidth = size;
        this.mHeight = size;
        this.mType = type;
        this.mOnColor = new SKMColor(150, 150, 150, 100);
        this.mOffColor = new SKMColor(255, 255, 255, 100);
    }

    public void setType(int type) {
        this.mType = type;
        this.mDir = 0;
        this.mRad = 0.0;
    }

    public void setColor(SKMColor onColor, SKMColor offColor) {
        this.mOnColor = onColor;
        this.mOffColor = offColor;
    }

    @Override
    public boolean isHit(double x, double y, boolean isPress, boolean isJudgeOnly) {
        boolean ret = super.isHit(x, y, isPress, isJudgeOnly);
        if (ret) {
            if (this.mType == 0 || this.mType == 1) {
                this.mDir = this.calcDir(x, y);
            } else if (this.mType == 2) {
                this.mRad = this.calcRad(x, y);
            }
        }
        return ret;
    }

    public void setDirPressed(int dir) {
        if (this.mIsVisible) {
            this.mIsPressed = true;
            this.mDir = dir;
        }
    }

    public int calcDir(double x, double y) {
        double rad = Math.atan2(y - (double)(this.mY + this.mHeight / 2), x - (double)(this.mX + this.mWidth / 2));
        int ret = 0;
        if (this.mType == 0) {
            double dRad = 0.7853981633974483;
            double offsetRad = 0.39269908169872414;
            ret = -0.39269908169872414 < rad && rad <= 0.39269908169872414 ? 2 : (0.39269908169872414 < rad && rad <= 1.1780972450961724 ? 6 : (1.1780972450961724 < rad && rad <= 1.9634954084936207 ? 4 : (1.9634954084936207 < rad && rad <= 2.748893571891069 ? 12 : (-2.748893571891069 < rad && rad <= -1.9634954084936207 ? 9 : (-1.9634954084936207 < rad && rad <= -1.1780972450961724 ? 1 : (-1.1780972450961724 < rad && rad <= -0.39269908169872414 ? 3 : 8))))));
        } else if (this.mType == 1) {
            double dRad = 1.5707963267948966;
            double offsetRad = 0.7853981633974483;
            ret = 0.7853981633974483 < rad && rad <= 2.356194490192345 ? 4 : (-0.7853981633974483 < rad && rad <= 0.7853981633974483 ? 2 : (-2.356194490192345 < rad && rad <= -0.7853981633974483 ? 1 : 8));
        }
        this.mDir = ret;
        return ret;
    }

    public double calcRad(double x, double y) {
        this.mRad = Math.atan2(-this.mHeight, -this.mWidth);
        return this.mRad;
    }

    public int getDir() {
        return this.mDir;
    }

    public double getRad() {
        return this.mRad;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        g.setColor(this.mOffColor);
        g.drawOval(this.mX, this.mY, this.mWidth, this.mHeight);
        int baseX = this.mWidth / 2 - 3;
        int sizeW = SKMUtil.toInt((double)this.mWidth * 0.25);
        int sizeH = SKMUtil.toInt((double)this.mHeight * 0.18);
        int[][] triangleXys = new int[][]{{baseX, baseX - sizeW, baseX - sizeW}, {0, sizeH, -sizeH}};
        int centerX = this.mX + this.mWidth / 2;
        int centerY = this.mY + this.mHeight / 2;
        int i = 0;
        while (i < triangleXys[0].length) {
            int[] nArray = triangleXys[0];
            int n = i;
            nArray[n] = nArray[n] + centerX;
            int[] nArray2 = triangleXys[1];
            int n2 = i++;
            nArray2[n2] = nArray2[n2] + centerY;
        }
        int[] dirs = new int[]{2, 4, 8, 1};
        boolean isPressed = this.mIsPressed && this.mType != 2;
        for (int i2 = 0; i2 < 4; ++i2) {
            g.saveTransform();
            g.rotate((double)i2 * Math.PI / 2.0, centerX, centerY);
            g.setColor(isPressed && (dirs[i2] & this.mDir) != 0 ? this.mOnColor : this.mOffColor);
            g.fillPolygon(triangleXys[0], triangleXys[1]);
            g.setColor(this.mOffColor);
            g.drawPolygon(triangleXys[0], triangleXys[1]);
            g.restoreTransform();
        }
    }
}

