/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public class Toast
extends Effect {
    private int mFadeCount;
    private int mShowCount;
    private int mFadeOutStartCount;
    private int mAlpha;
    private int mDAlpha;
    private double mDy;
    private String mText;
    private SKMColor mTextColor;
    private SKMFont mTextFont;
    private SKMImage mBgImage;

    public Toast(String text, double centerX, double centerY, SKMImage bgImage) {
        super(centerX, centerY);
        this.mText = text;
        this.mBgImage = bgImage;
        this.mFadeCount = 18;
        this.mDAlpha = SKMUtil.toInt(255 / this.mFadeCount);
        this.mShowCount = 90;
        this.mDy = 1.5;
        this.mFadeOutStartCount = this.mFadeCount + this.mShowCount;
        this.setY(centerY + this.mDy * (double)this.mFadeCount);
        this.mTextColor = SKMColor.WHITE;
        this.mTextFont = new SKMFont(SKMFont.BOLD, 24);
        this.mBgImage.setAlpha(0);
    }

    public void setTextColor(SKMColor color) {
        this.mTextColor = color;
    }

    public void setTextFont(SKMFont font) {
        this.mTextFont = font;
    }

    @Override
    protected void myMove() {
        if (this.mCount < this.mFadeCount) {
            this.setY((double)this.mY - this.mDy);
            this.mAlpha = this.mDAlpha * this.mCount;
        } else if (this.mFadeOutStartCount < this.mCount) {
            this.setY((double)this.mY + this.mDy);
            this.mAlpha = 255 - this.mDAlpha * (this.mCount - this.mFadeOutStartCount);
            if (this.mAlpha <= 0) {
                this.kill();
                return;
            }
        }
        this.mBgImage.setAlpha(this.mAlpha);
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        g.setFont(this.mTextFont);
        g.drawCenteringImage(this.mBgImage, this.mDrawX, this.mDrawY);
        g.setColor(new SKMColor(this.mTextColor.getRed(), this.mTextColor.getGreen(), this.mTextColor.getBlue(), this.mAlpha));
        g.drawCenteringString(this.mText, this.mDrawX, this.mDrawY);
    }
}

