/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import jp.ne.sk_mine.util.ui.LimitDocument;

public class ExJTextField
extends JTextField {
    private LimitDocument mDoc;
    private String mHint;

    public ExJTextField(int col) {
        super(col);
        this.init();
    }

    public ExJTextField(String text) {
        super(text);
        this.init();
    }

    public ExJTextField(String text, int col) {
        super(text, col);
        this.init();
    }

    private final void init() {
        this.mDoc = new LimitDocument(this);
        this.mHint = "";
        try {
            this.mDoc.insertString(0, this.getText(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDocument(this.mDoc);
        this.setCaretPosition(this.getText().length());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ExJTextField.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ExJTextField.this.repaint();
            }
        });
    }

    public int getMaxLength() {
        return this.mDoc.getMaxLength();
    }

    public void setMaxLength(int max) {
        this.mDoc.setMaxLength(max);
    }

    public void setHint(String hint) {
        this.mHint = hint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().length() != 0 || this.mHint.length() == 0) {
            return;
        }
        Font preFont = g.getFont();
        Color preColor = g.getColor();
        g.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        g.setColor(Color.LIGHT_GRAY);
        Insets insets = this.getBorder().getBorderInsets(this);
        int h = g.getFontMetrics().getAscent();
        g.drawString(this.mHint, insets.left, insets.top + h);
        g.setColor(preColor);
        g.setFont(preFont);
    }
}

