/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.image.RGBImageFilter;

public final class AlphaFilter
extends RGBImageFilter {
    private final int alphaColor_;
    private final int alpha_;

    public AlphaFilter(int alphaColor) {
        this(alphaColor, 0);
    }

    public AlphaFilter(int alphaColor, int alpha) {
        this.canFilterIndexColorModel = true;
        this.alphaColor_ = alphaColor;
        this.alpha_ = alpha;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int color = rgb & 0xFFFFFF;
        int alphaColor = this.alphaColor_ & 0xFFFFFF;
        if ((rgb & 0xFF000000) == 0) {
            return rgb;
        }
        if (this.alphaColor_ == -1 || color == alphaColor) {
            rgb = (this.alpha_ << 24) + color;
        }
        return rgb;
    }
}

