/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class ImageLoader {
    private static ImageLoader sInstance;
    private static Map<String, Image> sFilenameCache;
    private boolean mIsUseCache;
    private Component component_;

    public static ImageLoader getInstance() {
        if (sInstance == null) {
            sInstance = new ImageLoader();
        }
        return sInstance;
    }

    private ImageLoader() {
    }

    public void setComponent(Component component) {
        this.component_ = component;
    }

    public void setApplet(Component applet) {
        this.setComponent(applet);
    }

    public void setUseCache(boolean f) {
        this.mIsUseCache = f;
    }

    public boolean isUseCache() {
        return this.mIsUseCache;
    }

    public boolean isCached(String filename) {
        return sFilenameCache.containsKey(filename);
    }

    public Image getCache(String filename) {
        if (this.isCached(filename)) {
            return sFilenameCache.get(filename);
        }
        return null;
    }

    public void cache(String filename, Image image) {
        if (!this.mIsUseCache || filename.startsWith("-")) {
            return;
        }
        if (this.isCached(filename)) {
            sFilenameCache.get(filename).flush();
        }
        sFilenameCache.put(filename, image);
    }

    public final Image loadImage(String name) {
        return this.loadImage(name, this.mIsUseCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image loadImage(String name, boolean isUseCache) {
        if (isUseCache && sFilenameCache.containsKey(name)) {
            return sFilenameCache.get(name);
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(name);
        if (in == null) {
            try {
                in = new File(name).toURI().toURL().openStream();
            }
            catch (Exception ee) {
                System.err.println("Error in MApplet.loadImage(): \"" + name + "\" " + ee.getMessage());
                return null;
            }
        }
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[in.available()];
            while ((n = in.read(buffer)) != -1) {
                byteArray.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Image image = null;
            return image;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArray != null) {
                try {
                    byteArray.close();
                }
                catch (IOException iOException) {}
            }
        }
        Image img = Toolkit.getDefaultToolkit().createImage(byteArray.toByteArray());
        try {
            this.waitImageLoading(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isUseCache && img != null) {
            this.cache(name, img);
        }
        return img;
    }

    public final Image loadImage(String fileName, int x, int y, int w, int h) {
        String partKey = this.getPartKey(fileName, x, y, w, h);
        if (this.mIsUseCache && sFilenameCache.containsKey(partKey)) {
            return sFilenameCache.get(partKey);
        }
        Image wholeImage = this.loadImage(fileName, false);
        if (x == 0 && y == 0 && wholeImage.getWidth(null) == w && wholeImage.getHeight(null) == h) {
            if (this.mIsUseCache) {
                this.cache(partKey, wholeImage);
            }
            return wholeImage;
        }
        Image subImage = this.cropImage(wholeImage, x, y, w, h);
        wholeImage.flush();
        if (this.mIsUseCache) {
            this.cache(partKey, subImage);
        }
        return subImage;
    }

    public final Image cropImage(Image image, int x, int y, int w, int h) {
        Image subImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(x, y, w, h)));
        try {
            this.waitImageLoading(subImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return subImage;
    }

    public final Image[][] loadImages(String filename, int x, int y, int w, int h, int xNum, int yNum, Image[][] images) {
        Image wholeImage = this.loadImage(filename, false);
        if (xNum == -1) {
            xNum = wholeImage.getWidth(this.component_) / w;
        }
        if (yNum == -1) {
            yNum = wholeImage.getHeight(this.component_) / h;
        }
        if (images == null) {
            images = new Image[yNum][xNum];
        }
        for (int j = 0; j < yNum && j < images.length; ++j) {
            for (int i = 0; i < xNum && i < images[j].length; ++i) {
                String partKey = this.getPartKey(filename, x + i * w, y + j * h, w, h);
                if (this.mIsUseCache && sFilenameCache.containsKey(partKey)) {
                    images[j][i] = sFilenameCache.get(partKey);
                    continue;
                }
                images[j][i] = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(wholeImage.getSource(), new CropImageFilter(x + i * w, y + j * h, w, h)));
                if (!this.mIsUseCache) continue;
                this.cache(partKey, images[j][i]);
            }
        }
        try {
            this.waitImageLoading(images);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wholeImage.flush();
        return images;
    }

    public Image[][] loadImages(String filename, int x, int y, int w, int h, Image[][] images) {
        return this.loadImages(filename, x, y, w, h, -1, -1, images);
    }

    public Image[][] loadImages(String filename, int x, int y, int w, int h) {
        return this.loadImages(filename, x, y, w, h, -1, -1, null);
    }

    public String getPartKey(String filename, int x, int y, int w, int h) {
        StringBuilder buf = new StringBuilder();
        buf.append(filename);
        buf.append("_");
        buf.append(x);
        buf.append("_");
        buf.append(y);
        buf.append("_");
        buf.append(w);
        buf.append("_");
        buf.append(h);
        return buf.toString();
    }

    public void waitImageLoading(Image image) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.component_);
        mt.addImage(image, 0);
        mt.waitForAll();
    }

    public final void waitImageLoading(Image[] images) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.component_);
        for (int i = 0; i < images.length; ++i) {
            mt.addImage(images[i], 0);
        }
        mt.waitForAll();
    }

    public final void waitImageLoading(Image[][] images) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.component_);
        for (int i = 0; i < images.length; ++i) {
            for (int j = 0; j < images[i].length; ++j) {
                mt.addImage(images[i][j], 0);
            }
        }
        mt.waitForAll();
    }

    public static void finalizeAll() {
        for (Image image : sFilenameCache.values()) {
            if (image == null) continue;
            image.flush();
        }
        sFilenameCache.clear();
    }

    static {
        sFilenameCache = new HashMap<String, Image>();
    }
}

