﻿// OutputSender.cs
// 出力ファイルをLAN経由で送信するテンプレート集
// 対象：システム管理者、C#学習者
// すべてコメントアウト済み。環境に応じて有効化・改変してください。

using System;
using System.IO;
using System.Net;
using System.Net.Mail;
using System.Net.Sockets;
using System.Text;

public static class OutputSender
{
    // ファイル名にPC名とタイムスタンプを付加して一意化
    public static string GenerateFileName(string prefix = "ObservePC", string extension = ".txt")
    {
        string clientId = Environment.MachineName;
        string timestamp = DateTime.Now.ToString("yyyyMMdd_HHmmss");
        return $"{prefix}_{clientId}_{timestamp}{extension}";
    }

    // SMB共有フォルダへのコピー
    /*
    public static void SendToSharedFolder(string fileName)
    {
        try
        {
            string remoteFileName = GenerateFileName();
            string remotePath = @"\\ServerName\Share\ObservePC\" + remoteFileName;
            File.Copy(fileName, remotePath, true);
            Console.WriteLine("SMBコピー完了");
        }
        catch (Exception ex)
        {
            Console.WriteLine("SMBコピーエラー: " + ex.Message);
        }
    }
    */

    // HTTP POST送信
    /*
    public static void SendToHttpServer(string fileName)
    {
        try
        {
            using var client = new WebClient();
            client.Headers.Add("Content-Type", "text/plain");
            string remoteFileName = GenerateFileName();
            string url = $"http://yourserver.local/api/upload?filename={remoteFileName}";
            client.UploadFile(url, "POST", fileName);
            Console.WriteLine("HTTP送信完了");
        }
        catch (Exception ex)
        {
            Console.WriteLine("HTTP送信エラー: " + ex.Message);
        }
    }
    */

    // FTPアップロード
    /*
    public static void SendToFtpServer(string fileName)
    {
        try
        {
            string remoteFileName = GenerateFileName();
            string ftpUrl = $"ftp://yourserver.local/uploads/{remoteFileName}";
            var request = (FtpWebRequest)WebRequest.Create(ftpUrl);
            request.Method = WebRequestMethods.Ftp.UploadFile;
            request.Credentials = new NetworkCredential("username", "password");

            byte[] fileContents = File.ReadAllBytes(fileName);
            request.ContentLength = fileContents.Length;

            using Stream requestStream = request.GetRequestStream();
            requestStream.Write(fileContents, 0, fileContents.Length);

            using var response = (FtpWebResponse)request.GetResponse();
            Console.WriteLine("FTPアップロード完了: " + response.StatusDescription);
        }
        catch (Exception ex)
        {
            Console.WriteLine("FTPアップロードエラー: " + ex.Message);
        }
    }
    */

    // Syslog送信（UDP 514）
    /*
    public static void SendToSyslog(string fileName)
    {
        try
        {
            string clientId = Environment.MachineName;
            string timestamp = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            string message = $"ObservePC report from {clientId} at {timestamp}\n" + File.ReadAllText(fileName);

            using var client = new UdpClient();
            byte[] data = Encoding.UTF8.GetBytes(message);
            client.Send(data, data.Length, "syslog.server.local", 514);

            Console.WriteLine("Syslog送信完了");
        }
        catch (Exception ex)
        {
            Console.WriteLine("Syslog送信エラー: " + ex.Message);
        }
    }
    */

    // SMTP送信（LAN内・ポート25・認証なし）
    /*
    public static void SendViaSmtp_LAN(string fileName)
    {
        try
        {
            string smtp_IP = "192.168.1.100"; // SMTPサーバのIPまたはホスト名
            int smtp_Port = 25;
            string from_Address = "observepc@local";
            string to_Address = "admin@local";
            string subject = "ObservePC Report";
            string body = "ObservePCの出力ファイルを添付します。";

            var mail = new MailMessage(from_Address, to_Address, subject, body);
            mail.Attachments.Add(new Attachment(fileName));

            var smtp = new SmtpClient(smtp_IP, smtp_Port)
            {
                DeliveryMethod = SmtpDeliveryMethod.Network,
                EnableSsl = false,
                UseDefaultCredentials = true
            };

            smtp.Send(mail);
            Console.WriteLine("SMTP送信完了（ポート25・認証なし）");
        }
        catch (Exception ex)
        {
            Console.WriteLine("SMTP送信エラー: " + ex.Message);
        }
    }
    */

//SMTP(WAN環境想定。587ポート認証あり)
/*
    public static void SendViaSmtp(string fileName)
	{
	    try
    	{
        // === 設定項目（環境に応じて変更） ===
        string smtp_IP = ""; // SMTPサーバアドレス（例: smtp.example.com）
        int smtp_Port = 587; // ポート番号（例: 587, 465）
        string smtp_User = ""; // SMTPユーザー名
        string smtp_Pass = ""; // SMTPパスワード
        string from_Address = "sender@example.com"; // 送信元メールアドレス
        string to_Address = "receiver@example.com"; // 送信先メールアドレス
        string subject = "ObservePC Report";
        string body = "ObservePCの出力ファイルを添付します。";

        // === メール作成 ===
        var mail = new System.Net.Mail.MailMessage(from_Address, to_Address, subject, body);
        mail.Attachments.Add(new System.Net.Mail.Attachment(fileName));

        // === SMTPクライアント設定 ===
        var smtp = new System.Net.Mail.SmtpClient(smtp_IP, smtp_Port)
        {
            Credentials = new NetworkCredential(smtp_User, smtp_Pass),
            EnableSsl = true // 必要に応じて false に変更
        };

        smtp.Send(mail);
        Console.WriteLine("SMTP送信完了");
    }
    catch (Exception ex)
    {
        Console.WriteLine("SMTP送信エラー: " + ex.Message);
    }
}
*/
}



