/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMStringBuilder;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.event.SameAttributeWord;

class MessageLine {
    private int mCurrentWordIndex;
    private int mHeight;
    private SKMArray<SameAttributeWord> mWords = new SKMArray();

    public MessageLine(String line, int startX, int startY, int areaX, int areaY, int areaWidth, int areaHeight, int rightOffset, SKMColor color, SKMColor roundColor, SKMFont font, boolean isLeftMarginAfterNewlineEnabled, boolean isCenteringMessageX, boolean isCenteringMessageY) {
        String marginLetter;
        SKMGraphics g = SKM.getGraphics();
        g.setFont(font);
        boolean isNewlineWordUnit = SKM.getManager().hasLangSpaces();
        SKMStringBuilder buf = new SKMStringBuilder();
        int x = this.getStartX(line, startX, areaWidth, isCenteringMessageX, g);
        int y = this.getStartY(line, startY, areaHeight, isCenteringMessageY, g);
        boolean isZennkaku = SKM.getManager().isZennkaku();
        String string = marginLetter = isZennkaku ? "\u3000" : " ";
        while (line.length() != 0) {
            boolean isNextNewline = false;
            if ((line = this.getReplacedString(line)).startsWith("$color(")) {
                int closeIndex = line.indexOf(")");
                String[] params = line.substring("$color(".length(), closeIndex).split(",");
                if (params.length == 3) {
                    color = new SKMColor(Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]));
                } else if (params.length == 4) {
                    color = new SKMColor(Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2], Integer.parseInt(params[3])));
                }
                line = line.substring(closeIndex + 1);
                if (buf.length() == 0) continue;
                this.addNewWord(buf, x, y, color, roundColor, font);
                buf = new SKMStringBuilder();
                continue;
            }
            if (line.startsWith("$font(")) {
                int closeIndex = line.indexOf(")");
                String[] params = line.substring("$font(".length(), closeIndex).split(",");
                if (params.length == 1) {
                    font = new SKMFont(Integer.parseInt(params[0]));
                    g.setFont(font);
                }
                line = line.substring(closeIndex + 1);
                if (buf.length() == 0) continue;
                this.addNewWord(buf, x, y, color, roundColor, font);
                buf = new SKMStringBuilder();
                continue;
            }
            if (line.charAt(0) == ' ') {
                x += g.stringWidth(" ");
                if (isZennkaku) {
                    buf.append("\u3000");
                }
                line = line.substring(1);
                continue;
            }
            if (isNewlineWordUnit) {
                int spaceIndex = line.indexOf(" ");
                int newlineIndex = line.indexOf("\n");
                int commandIndex = -1;
                int dollarIndex = line.indexOf("$");
                if (dollarIndex != -1) break;
                if (line.substring(dollarIndex + 1).startsWith("color(") || line.substring(dollarIndex + 1).startsWith("font(")) {
                    commandIndex = dollarIndex;
                }
                String word = null;
                if (spaceIndex == -1 && newlineIndex == -1 && commandIndex == -1) {
                    word = line;
                    line = "";
                } else {
                    int index = 10000;
                    if (spaceIndex != -1 && spaceIndex < index) {
                        index = spaceIndex;
                    }
                    if (newlineIndex != -1 && newlineIndex < index) {
                        index = newlineIndex;
                    }
                    if (commandIndex != -1 && commandIndex < index) {
                        index = commandIndex;
                    }
                    if (index == spaceIndex) {
                        word = line.substring(0, spaceIndex);
                        line = line.substring(spaceIndex);
                    } else if (index == newlineIndex) {
                        word = line.substring(0, newlineIndex);
                        line = line.substring(newlineIndex + 1);
                        isNextNewline = true;
                    } else if (index == commandIndex) {
                        word = line.substring(0, commandIndex);
                        line = line.substring(commandIndex);
                    }
                    if (!isNextNewline) {
                        if (line.matches("^[,\\.\u3001\uff0c\u3002][\\\"\u201d\u2019\u300d\u300f\uff09\\)\u226b].*")) {
                            word = word + line.substring(0, 2);
                            line = line.substring(2);
                        } else if (line.matches("^[,\\.\u3001\uff0c\u3002].*") && !line.matches("^\\.\\.\\..*")) {
                            word = word + line.substring(0, 1);
                            line = line.substring(1);
                        }
                    }
                }
                if (areaWidth - rightOffset < x + g.stringWidth(word)) {
                    x = this.getStartX(line, startX, areaWidth, isCenteringMessageX, g);
                    if (!isCenteringMessageX && line.length() != 0 && this.isLeftMarginEnabled(isLeftMarginAfterNewlineEnabled, line.substring(0, 1))) {
                        x += g.stringWidth(marginLetter);
                    }
                    y += this.getLineHeight(g);
                }
                this.mWords.add(new SameAttributeWord(word, x, y, color, roundColor, font));
                x += g.stringWidth(word);
                if (!isNextNewline) continue;
                x = this.getStartX(line, startX, areaWidth, isCenteringMessageX, g);
                if (!isCenteringMessageX && line.length() != 0 && this.isLeftMarginEnabled(isLeftMarginAfterNewlineEnabled, line.substring(0, 1))) {
                    x += g.stringWidth(marginLetter);
                }
                y += this.getLineHeight(g);
                continue;
            }
            if (line.charAt(0) == '\n') {
                if (buf.length() != 0) {
                    this.addNewWord(buf, x, y, color, roundColor, font);
                    buf = new SKMStringBuilder();
                }
                x = this.getStartX(1 < line.length() ? line.substring(1) : "", startX, areaWidth, isCenteringMessageX, g);
                if (!isCenteringMessageX && 2 <= line.length() && this.isLeftMarginEnabled(isLeftMarginAfterNewlineEnabled, line.substring(1, 2))) {
                    x += g.stringWidth(marginLetter);
                }
                y += this.getLineHeight(g);
            } else {
                String letter = line.substring(0, 1);
                if (areaWidth - rightOffset < x + g.stringWidth(buf.toString() + letter) && !this.isNoNewlineLetter(letter)) {
                    if (buf.length() != 0) {
                        if (line.matches("^[,\\.\u3001\uff0c\u3002][\\\"\u201d\u2019\u300d\u300f\uff09\\)\u226b].*")) {
                            buf.append(line.substring(0, 2));
                            line = line.substring(2);
                            letter = line.substring(0, 1);
                        } else if (line.matches("^[,\\.\u3001\uff0c\u3002].*")) {
                            buf.append(line.substring(0, 1));
                            line = line.substring(1);
                            letter = line.substring(0, 1);
                        }
                        this.addNewWord(buf, x, y, color, roundColor, font);
                        buf = new SKMStringBuilder();
                    }
                    x = this.getStartX(line, startX, areaWidth, isCenteringMessageX, g);
                    if (!isCenteringMessageX && 2 <= line.length() && this.isLeftMarginEnabled(isLeftMarginAfterNewlineEnabled, line.substring(1, 2))) {
                        x += g.stringWidth(marginLetter);
                    }
                    y += this.getLineHeight(g);
                }
                buf.append(letter);
            }
            line = line.substring(1);
        }
        if (buf.length() != 0) {
            this.addNewWord(buf, x, y, color, roundColor, font);
            buf = new SKMStringBuilder();
        }
        this.mHeight = y + font.getSize();
    }

    private String getReplacedString(String line) {
        SKMI18N i18n = SKM.getI18N();
        SKMI18N i18nCommon = SKM.getI18NCommon();
        while (line.contains("$message(")) {
            int startIndex = line.indexOf("$message(");
            int closeIndex = startIndex + line.substring(startIndex).indexOf(")");
            String param = line.substring(startIndex + "$message(".length(), closeIndex);
            String message = i18n.getReplacedString(param, i18n);
            if (message.equals("")) {
                message = i18nCommon.getReplacedString(param, i18n);
            }
            line = line.replaceAll("\\$message\\(" + param + "\\)", message);
        }
        return line;
    }

    private int getStartX(String line, int defaultStartX, int areaWidth, boolean isCentering, SKMGraphics g) {
        if (isCentering) {
            String[] tokens = (line = this.getReplacedString(line)).startsWith("\n") ? line.substring(1).split("\n") : line.split("\n");
            return (areaWidth - g.stringWidth(tokens[0])) / 2;
        }
        return defaultStartX;
    }

    private int getStartY(String line, int defaultStartY, int areaHeight, boolean isCentering, SKMGraphics g) {
        if (isCentering) {
            String[] tokens = line.startsWith("\n") ? line.substring(1).split("\n") : line.split("\n");
            int lineHeight = this.getLineHeight(g);
            return (areaHeight + defaultStartY - tokens.length * lineHeight) / 2 + SKMUtil.toInt((lineHeight - g.stringHeight()) / 2);
        }
        return defaultStartY;
    }

    private final boolean isLeftMarginEnabled(boolean isEnabledDefault, String nextLetter) {
        return isEnabledDefault && !nextLetter.equals("") && !nextLetter.equals("\u300c") && !nextLetter.equals("\"");
    }

    private final boolean isNoNewlineLetter(String letter) {
        return letter.equals(",") || letter.equals(".") || letter.equals("\u3001") || letter.equals("\uff0c") || letter.equals("\u3002") || letter.equals("\u300d") || letter.equals("\u300f") || letter.equals("\uff09") || letter.equals("\u226b") || letter.equals("\u2019") || letter.equals("\u201d") || letter.equals("!") || letter.equals("\uff01") || letter.equals("?") || letter.equals("\uff1f") || letter.equals("-") || letter.equals("\u2015");
    }

    private final void addNewWord(SKMStringBuilder buf, int x, int y, SKMColor color, SKMColor roundColor, SKMFont font) {
        this.mWords.add(new SameAttributeWord(buf.toString(), x, y, color, roundColor, font));
    }

    private final int getLineHeight(SKMGraphics g) {
        return SKMUtil.toInt(1.3 * (double)g.stringHeight());
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean update(boolean isShowAtOnce) {
        if (this.mWords.size() == this.mCurrentWordIndex) {
            return false;
        }
        if (isShowAtOnce) {
            this.mCurrentWordIndex = this.mWords.size();
            for (int i = 0; i < this.mCurrentWordIndex; ++i) {
                this.mWords.get(i).update(true);
            }
        } else if (!this.mWords.get(this.mCurrentWordIndex).update(isShowAtOnce)) {
            ++this.mCurrentWordIndex;
        }
        return true;
    }

    public void paint(SKMGraphics g) {
        for (int i = 0; i < this.mWords.size(); ++i) {
            SameAttributeWord word = this.mWords.get(i);
            word.paint(g);
        }
    }
}

