/** cpuid.cpp
 * CPȔ\
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-06-01.shtm
*/

//  ==============================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <sstream>
#include <string>
#include <fstream>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"			// 쐬
#define APPNAME		"cpuid"				// AvP[V
#define APPNAMEJP	"CPU"			// AvP[Vi{j
#define APPVERSION	"1.3.10"			// o[W
#define APPYEAR		"2020-2025"			// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-06-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		512

// ݂̃C^[tFCX
static HINSTANCE hInst;

// eEBhE
static HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"cpuid.txt"

// ProcessorListt@C
#define FNAME	"processorList.xml"

#define SIZE_PROCESSORINFO	500		// i[

// ProcessorInfoNX
class ProcessorInfo {
public:
	unsigned int level = 0;
	unsigned int type = 0;
	unsigned int number = 0;
	unsigned int model = 0;
	unsigned int family = 0;
	unsigned int stepping = 0;
	string vendor = "";
	string architecture = "";
};

// ʊi[p
unique_ptr<ProcessorInfo> ProcessorList[SIZE_PROCESSORINFO] = {};

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃Cu𗘗pĂ܂D
@MinGWig++j^Boost C++Cu
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * AvP[VEEBhEʒuǂݍށD
 * @param	Ȃ
 * @return	Ȃ
 */
void loadAppPosition(void) {
	hParent_X = 0;
	hParent_Y = 0;
	ptree pt;

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	return;
}

/**
 * AvP[VEEBhEʒuۑD
 * @param	Ȃ
 * @return	Ȃ
 */
void saveAppPosition(void) {
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", (string)to_string(hParent_X));
	child1.add("<xmlattr>.type", "wx");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child2.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

// GUI =================================================================
/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// _CAOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// eLXgEt@C֏o =================================================
/**
 * CPUTXTt@Cɕۑ
 * @param	const char* fname	ۑt@C
 * @param	char* cpu			CPU
 * @return	Ȃ
*/
void __saveTXT(const char* fname, char* cpu) {
	ofstream outputfile(fname);

	outputfile << cpu << endl;

	if (outputfile.bad()) {
		ErrorMessage = "eLXgt@C݃G[";
	}
	outputfile.close();
}

/**
 * CPUTXTt@Cɕۑ
 * @param	char* cpu  CPU
 * @return	Ȃ
*/
void saveTXT(char* cpu) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveTXT(fname, cpu);
}

// CPU񃊃Xg擾E}b`O ===========================================
/**
 * CPU񃊃Xg擾
 * @param  char *fname CPU񃊃Xgt@C
 * @return int 擾񐔁^(-1)F擾s
*/
int getProcessorList(const char *fname, char *date) {
	int cnt = -1;

	try {
		// XMLt@Cǂݍ
		boost::property_tree::ptree pt;
		boost::property_tree::xml_parser::read_xml(fname, pt);

		// XML
		boost::optional<std::string> str = pt.get_optional<std::string>("processorList.date");
		strncpy(date, str->c_str(), SIZE_BUFF);

		for (auto it : pt.get_child("processorList")) {
			cnt++;
			ProcessorList[cnt] = make_unique<ProcessorInfo>();
			// x_
			if (optional<string> vendor = it.second.get_optional<string>("vendor")) {
				ProcessorList[cnt]->vendor = vendor.value();
			}
			// t@~[
			if (optional<string> family = it.second.get_optional<string>("family")) {
				ProcessorList[cnt]->family = strtol(family->c_str(), NULL, 16);
			}
			// f
			if (optional<string> model = it.second.get_optional<string>("model")) {
				ProcessorList[cnt]->model = strtol(model->c_str(), NULL, 16);
			}
			// A[LeN`
			if (optional<string> architecture = it.second.get_optional<string>("architecture")) {
				ProcessorList[cnt]->architecture = architecture.value();
			}
		}
	// G[
	} catch (boost::property_tree::xml_parser_error& e) {
		ErrorMessage = "G[F" + (string)e.what();
	}

	return cnt;
}

/**
 * SystemInfǒʂCPU񃊃Xg}b`OCPU擾
 * @param   ProcessorInfo cpuinfo ʂi[
 * @return  bool TRUEF擾^FALSEF擾s
*/
bool getProcessorInfo(ProcessorInfo &cpuinfo) {
	// CPU擾
	SYSTEM_INFO systemInfo;
	GetSystemInfo(&systemInfo);
	cpuinfo.level  = (unsigned int)systemInfo.wProcessorLevel;
	cpuinfo.type   = (unsigned int)systemInfo.dwProcessorType;
	cpuinfo.number = (unsigned int)systemInfo.dwNumberOfProcessors;
	cpuinfo.model  = (unsigned int)(systemInfo.wProcessorRevision >> 8);
	cpuinfo.stepping = (unsigned int)(systemInfo.wProcessorRevision & 0x00FF);
	cpuinfo.vendor = "unknown";
	cpuinfo.architecture = "unknown";

	// CPU񃊃Xgƃ}b`O
	bool res = false;
	for (int i = 0; i < SIZE_PROCESSORINFO; i++) {
		if (ProcessorList[i] == nullptr)	break;
		if ((ProcessorList[i]->family == cpuinfo.level) && (ProcessorList[i]->model == cpuinfo.model)) {
			cpuinfo.vendor = ProcessorList[i]->vendor;
			cpuinfo.architecture = ProcessorList[i]->architecture;
			res = true;
			break;
		}
	}
	return res;
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	ProcessorInfo cpuinfo;
	static char cpu[SIZE_BUFF + 1], date[SIZE_BUFF + 1];

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		// AvP[VEEBhËʒuǂݍ
		loadAppPosition();
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		// CPU擾
		getProcessorList(FNAME, date);
		if (ErrorMessage != "") {
			setStrEditBox(hDlg, IDC_TEXT_CPUID, ErrorMessage);
		} else {
			getProcessorInfo(cpuinfo);
			// CPUieLXgj
			snprintf(cpu, SIZE_BUFF, "%s %s, %d processor(s)\nlevel %d  model %d  stepping %d", cpuinfo.vendor.c_str(), cpuinfo.architecture.c_str(), cpuinfo.number, cpuinfo.level, cpuinfo.model, cpuinfo.stepping);
			setStrEditBox(hDlg, IDC_TEXT_CPUID, cpu);
			setStrEditBox(hDlg, IDC_TEXT_ONLINE, date);
		}
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTXT(cpu);
			if (ErrorMessage != "") {
				setStrEditBox(hDlg, IDC_TEXT_CPUID, ErrorMessage);
			}
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(cpu);
			break;
		// vOI
		case IDM_QUIT:
			// AvP[VEEBhËʒuۑ
			saveAppPosition();
			EndDialog(hParent, 0);
			return 0;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		// AvP[VEEBhËʒuۑ
		saveAppPosition();
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 1.3.10 2025/10/11 CPUXgXVCgpCuXV
 * @version 1.3.9  2025/06/21 CPUXgXVCgpCuXV
 * @version 1.3.8  2025/03/01 CPUXgXVCgpCuXV
 * @version 1.3.7  2024/07/14 CPUXgXVCgpCuXV
 * @version 1.3.6  2024/07/14 CPUXgXVCgpCuXV
 * @version 1.3.5  2024/02/17 CPUXgXVCgpCuXV
 * @version 1.3.4  2023/10/08 gpCuo[WAbvCAvP[VEEBhËʒuۑ
 * @version 1.3.3  2023/05/28 gpCuo[WAbv
 * @version 1.3.2  2023/02/26 gpCuo[WAbv
 * @version 1.3.1  2022/10/31 gpCuo[WAbvCCPUXgXV
 * @version 1.3    2022/07/14 gpCuo[WAbvCCPUXgXV
 * @version 1.2    2020/09/05 CXg[[Cwvt@CCj[ǉ
 * @version 1.1    2020/08/24 XML Boost C++ LibrariesɕύX
 * @version 1.0    2020/08/01 
*/
