/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class SKMStringFuncs {
    public static String getFilledString(long num, int n, char pad) {
        int keta = 0;
        long tmp = num;
        for (int i = 0; i < n; ++i) {
            ++keta;
            if ((tmp /= 10L) == 0L) break;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = n; keta < i; --i) {
            sb.append(pad);
        }
        sb.append(num);
        return sb.toString();
    }

    public static String getFilledString(String str, int n, char pad) {
        int keta = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = n; keta < i; --i) {
            sb.append(pad);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String getExtension(String filename) {
        int lastDotIndex = filename.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return filename.substring(lastDotIndex + 1);
    }

    public static String getExtensionLowerCase(String filename) {
        String extension = SKMStringFuncs.getExtension(filename);
        if (extension == null) {
            return "";
        }
        return extension.toLowerCase();
    }

    public static String join(String delimiter, String[] values) {
        if (values.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            buf.append(delimiter);
            buf.append(values[i]);
        }
        return buf.toString();
    }

    public static String join(String delimiter, int[] values) {
        if (values.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            buf.append(delimiter);
            buf.append(values[i]);
        }
        return buf.toString();
    }

    public static String join(String delimiter, SKMArray<?> values) {
        if (values.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(values.get(0));
        for (int i = 1; i < values.size(); ++i) {
            buf.append(delimiter);
            buf.append(values.get(i));
        }
        return buf.toString();
    }

    public static SKMArray<String> getCutString(String string, int len, SKMFont font) {
        SKMArray<String> ret;
        block47: {
            SKMGraphics g;
            block49: {
                block48: {
                    boolean isSeparatedSpace;
                    ret = new SKMArray<String>();
                    if (string.length() <= 2) {
                        ret.add(string);
                        return ret;
                    }
                    g = SKM.getGraphics();
                    g.setFont(font);
                    if (g.stringWidth(string) <= len) {
                        String[] tokens = string.split("\n");
                        for (int i = 0; i < tokens.length; ++i) {
                            ret.add(tokens[i]);
                        }
                        return ret;
                    }
                    boolean bl = isSeparatedSpace = !SKM.getManager().isZennkaku();
                    if (!isSeparatedSpace) break block49;
                    while (true) {
                        boolean isNewLineFound = false;
                        boolean isSpaceFound = false;
                        int checkedLen = 0;
                        int lastSpaceIndex = -1;
                        while (string.length() != 0 && string.charAt(0) == '\n') {
                            ret.add("");
                            string = string.substring(1);
                        }
                        for (int i = 1; i < string.length(); ++i) {
                            int endIndex;
                            int nextIndex;
                            char c = string.charAt(i);
                            checkedLen += g.stringWidth("" + c);
                            if (c == '\n') {
                                nextIndex = i + 1;
                                if (string.length() <= nextIndex) {
                                    ret.add(string.substring(0, i));
                                    string = "";
                                } else {
                                    endIndex = i;
                                    ret.add(string.substring(0, endIndex));
                                    string = string.substring(nextIndex);
                                    if (g.stringWidth(string) <= len) break;
                                }
                                isNewLineFound = true;
                                break;
                            }
                            if (c == ' ') {
                                lastSpaceIndex = i;
                                continue;
                            }
                            if (len >= checkedLen || lastSpaceIndex == -1) continue;
                            nextIndex = lastSpaceIndex + 1;
                            if (string.length() <= nextIndex) {
                                ret.add(string.substring(0, lastSpaceIndex));
                                string = "";
                            } else {
                                endIndex = lastSpaceIndex;
                                ret.add(string.substring(0, endIndex));
                                string = string.substring(nextIndex);
                                if (g.stringWidth(string) <= len) break;
                            }
                            isSpaceFound = true;
                            break;
                        }
                        if (isNewLineFound || string.indexOf(10) != -1) continue;
                        if (g.stringWidth(string) <= len) {
                            ret.add(string);
                            break block47;
                        }
                        if (!isSpaceFound) break block48;
                        if (string.length() == 0) break;
                    }
                    break block47;
                }
                ret.add(string);
                break block47;
            }
            while (true) {
                int linefeedIndex;
                if ((linefeedIndex = string.indexOf(10)) != -1 && g.stringWidth(string.substring(0, linefeedIndex)) <= len) {
                    ret.add(string.substring(0, linefeedIndex));
                    string = string.substring(linefeedIndex + 1);
                    continue;
                }
                if (g.stringWidth(string) <= len) {
                    ret.add(string);
                    break;
                }
                int cutIndex = string.length() - 1;
                for (int i = 1; i < string.length(); ++i) {
                    if (len >= g.stringWidth(string.substring(0, i))) continue;
                    cutIndex = i - 1;
                    break;
                }
                String cutString = string.substring(0, cutIndex);
                String checkString = string = string.substring(cutIndex);
                int newlineIndex = checkString.indexOf("\n");
                if (newlineIndex != -1) {
                    checkString = checkString.substring(0, newlineIndex);
                }
                if (checkString.matches("^^\u2026\u2026\n.*")) {
                    cutString = cutString + string.substring(0, 2);
                    string = string.substring(3);
                } else if (checkString.matches("^\u2026\u2026\u300d\n.*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(4);
                } else if (checkString.matches("^\u2026\u2026\u3002\n.*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(4);
                } else if (checkString.matches("^\u2026\u2026\u3002\u300d\n.*")) {
                    cutString = cutString + string.substring(0, 4);
                    string = string.substring(5);
                } else if (checkString.matches("^\u2026\u2026\u300d.*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(3);
                } else if (checkString.matches("^\u2026\u2026\u3002.*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(3);
                } else if (checkString.matches("^\u2026\u2026.*")) {
                    cutString = cutString + string.substring(0, 2);
                    string = string.substring(2);
                } else if (checkString.matches("^\\.\\.\\.\n.*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(4);
                } else if (checkString.matches("^\\.\\.\\.[\"\u300d\u201d]\n.*")) {
                    cutString = cutString + string.substring(0, 4);
                    string = string.substring(5);
                } else if (checkString.matches("^\\.\\.\\.[\"\u300d\u201d].*")) {
                    cutString = cutString + string.substring(0, 4);
                    string = string.substring(4);
                } else if (checkString.matches("^\\.\\.\\..*")) {
                    cutString = cutString + string.substring(0, 3);
                    string = string.substring(3);
                } else if (checkString.matches("^[\u3002\u3001\uff0e\uff0c\\., !\uff01?\uff1f\"][\u300d\u300f\u2019\u201d\u226b]\n.*")) {
                    cutString = cutString + string.substring(0, 2);
                    string = string.substring(3);
                } else if (checkString.matches("^[\u3002\u3001\uff0e\uff0c\\., !\uff01?\uff1f\"][\u300d\u300f\u2019\u201d\u226b].*")) {
                    cutString = cutString + string.substring(0, 2);
                    string = string.substring(2);
                } else if (checkString.matches("^[\u3002\u3001\uff0e\uff0c\\., !\uff01?\uff1f\"\u300d\u300f\u2019\u201d\u226b]\n.*")) {
                    cutString = cutString + string.charAt(0);
                    string = string.substring(2);
                } else if (checkString.matches("^[\u3002\u3001\uff0e\uff0c\\., !\uff01?\uff1f\"\u300d\u300f\u2019\u201d\u226b].*")) {
                    cutString = cutString + string.charAt(0);
                    string = string.substring(1);
                }
                ret.add(cutString);
            }
        }
        return ret;
    }

    public static String getKakkoString(String string, int kakkoType) {
        boolean isZennkaku = SKM.getManager().isZennkaku();
        if (kakkoType == 0) {
            if (isZennkaku) {
                return "\uff08" + string + "\uff09";
            }
            return "(" + string + ")";
        }
        if (kakkoType == 1) {
            if (isZennkaku) {
                return "\uff3b" + string + "\uff3d";
            }
            return "[" + string + "]";
        }
        if (kakkoType == 2) {
            if (isZennkaku) {
                return "\u3010" + string + "\u3011";
            }
            return "[" + string + "]";
        }
        if (kakkoType == 3) {
            if (isZennkaku) {
                return "\uff1c" + string + "\uff1e";
            }
            return "<" + string + ">";
        }
        if (kakkoType == 4) {
            if (isZennkaku) {
                return "\u300c" + string + "\u300d";
            }
            return "\"" + string + "\"";
        }
        if (kakkoType == 5) {
            if (isZennkaku) {
                return "\u300e" + string + "\u300f";
            }
            return "'" + string + "'";
        }
        return string;
    }

    public static String getComma(boolean isSpaceAdded) {
        String lang = SKM.getI18NCommon().getString("lang");
        if (lang.equals("ja")) {
            return "\u3001";
        }
        if (lang.equals("zh") || lang.equals("zh_TW")) {
            return "\uff0c";
        }
        if (isSpaceAdded) {
            return ", ";
        }
        return ",";
    }

    public static String getPeriod(boolean isSpaceAdded) {
        String lang = SKM.getI18NCommon().getString("lang");
        if (lang.equals("ja")) {
            return "\u3002";
        }
        if (lang.equals("zh") || lang.equals("zh_TW")) {
            return "\u3002";
        }
        if (isSpaceAdded) {
            return ". ";
        }
        return ".";
    }

    public static String getColon(boolean isSpaceAdded) {
        if (SKM.getManager().isZennkaku()) {
            return "\uff1a";
        }
        if (isSpaceAdded) {
            return " : ";
        }
        return ":";
    }

    public static int compareTo(String a, String b) {
        return a.compareTo(b);
    }

    private SKMStringFuncs() {
    }
}

