# Ring Launcher System

リングランチャーシステムの実装ファイルです。

## 📁 ファイル構成

### Core Implementation
- **`ring_command_launcher.py`**: 基本的なリングランチャー実装
- **`ring_command_launcher_v2.py`**: 高機能版リングランチャー（設定機能付き）
- **`ring_comment_launcher.py`**: コメント表示機能付きリングランチャー
- **`ring_comment_launcher_enhanced.py`**: 強化版コメントリングランチャー
- **`shortcut_manager.py`**: ショートカット管理とアイコン表示制御

## 🚀 使用方法

### 基本リングランチャー
```python
from ring_launcher.ring_command_launcher import RingCommandLauncher
launcher = RingCommandLauncher()
launcher.show()
```

### 強化版コメントランチャー
```python
from ring_launcher.ring_comment_launcher_enhanced import RingCommentLauncherEnhanced
launcher = RingCommentLauncherEnhanced()
launcher.toggle_comment_mode()
launcher.show_at_cursor()
```

## 🔧 機能

- **円形アイコン配置**: 最大10個のショートカットを円形に配置
- **カスタマイズ可能**: アイコン、絵文字、コマンドを自由に設定
- **コメント表示**: 音声認識やチャット連携でコメント表示
- **アニメーション**: スムーズな表示/非表示効果
- **設定永続化**: config.iniとの連携

## 📋 依存関係

- PyQt5
- HieroNote main application (ui_mainwindow.py)
- config.ini settings