# Utility Files

HieroNoteのユーティリティ・補助機能ファイルです。

## 📁 ファイル構成

### UI Utilities
- **`emoji_dialog.py`**: 絵文字選択ダイアログ
- **`image_viewer.py`**: 画像ビューアー機能

### Integration Utilities
- **`shared_workspace_adapter.py`**: 共有ワークスペースアダプター

## 🚀 使用方法

### 絵文字選択ダイアログ
```python
from utils.emoji_dialog import EmojiDialog
dialog = EmojiDialog()
if dialog.exec_() == QDialog.Accepted:
    selected_emoji = dialog.get_selected_emoji()
```

### 画像ビューアー
```python
from utils.image_viewer import ImageViewer
viewer = ImageViewer("path/to/image.png")
viewer.show()
```

### 共有ワークスペースアダプター
```python
from utils.shared_workspace_adapter import SharedWorkspaceAdapter
adapter = SharedWorkspaceAdapter()
adapter.connect_to_workspace()
```

## 🔧 機能

### 絵文字ダイアログ
- カテゴリ別絵文字表示
- 検索機能
- 最近使用した絵文字
- ショートカット対応

### 画像ビューアー
- 画像の拡大/縮小
- 回転機能
- ファイル情報表示
- 形式変換サポート

### 共有ワークスペースアダプター
- Firebase連携の抽象化
- 接続状態管理
- エラーハンドリング
- 権限管理

## 📋 依存関係

- PyQt5
- Firebase Admin SDK (shared_workspace_adapter)
- Pillow (image_viewer)

## ⚠️ 注意事項

- これらのユーティリティはメインアプリケーションから呼び出されることを想定しています
- 単体実行時は一部機能が制限される場合があります
- Firebase関連機能は適切な認証設定が必要です