/** googlenewswin.cpp
 * Googlej[X
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-08-01.shtm
 *
*/
//  ==============================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <curl/curl.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"googlenewswin"			// AvP[V
#define APPNAMEJP	"Googlej[X"	// AvP[Vi{j
#define APPVERSION	"1.5.9"					// o[W
#define APPYEAR		"2020-2025"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-08-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		5120

// ListViewItem̍ő啶FύXs
#define MAX_LISTVIEWITEM	259

// WtHg
#define FONT_FACE		"MS UI Gothic"

// Googlej[XURL
#define URL_GOOGLENEWS	"https://news.google.com/rss/search?hl=ja&gl=JP&ceid=JP:ja&q="

// ݂̃C^[tFCX
static HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// L[i[p
string Query;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"googlenewswin.csv"

// UserAgent
string UserAgent;

// j[Xi[pNX
#define SIZE_NEWS	500		// i[j[X
class _News {
public:
	wstring title = L"";		// o
	string link = "";			// LN
	string pubdate = "";		// zM
	time_t ti = 0;				// zMitime_t^j
	wstring description = L"";	// LTv
	wstring source = L"";		// fBA
};
unique_ptr<_News> News[SIZE_NEWS] = {};

// \[gp\
struct _stNews {
	wchar_t* title;				// o
	char* pubdate;				// zM
	time_t ti;					// zMitime_t^j
	char* link;					// LN
	wchar_t* source;			// fBA
};
vector<_stNews> Vnews;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGW(g++), Boost C++Cu, cURL, OpenSSLCGooglej[X
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// TuEvO =====================================================
typedef void (WINAPI *RtlGetVersion_FUNC)(OSVERSIONINFOEXW*);

/**
 * Windowso[W擾
 * @param	OSVERSIONINFOEX* os o[Wi[
 * @return	bool TRUE/FALSEȂ
 */
BOOL GetVersion2(OSVERSIONINFOEX* os) {
	HMODULE hMod;
	RtlGetVersion_FUNC func;
#ifdef UNICODE
	OSVERSIONINFOEXW* osw = os;
#else
	OSVERSIONINFOEXW o;
	OSVERSIONINFOEXW* osw = &o;
#endif

	hMod = LoadLibrary(TEXT("ntdll.dll"));
	if (hMod) {
		func = (RtlGetVersion_FUNC)GetProcAddress(hMod, "RtlGetVersion");
		if (func == 0) {
			FreeLibrary(hMod);
			return FALSE;
		}
		ZeroMemory(osw, sizeof(*osw));
		osw->dwOSVersionInfoSize = sizeof(*osw);
		func(osw);
#ifndef UNICODE
		os->dwBuildNumber = osw->dwBuildNumber;
		os->dwMajorVersion = osw->dwMajorVersion;
		os->dwMinorVersion = osw->dwMinorVersion;
		os->dwPlatformId = osw->dwPlatformId;
		os->dwOSVersionInfoSize = sizeof(*os);
//		DWORD sz = sizeof(os->szCSDVersion);
		WCHAR* src = osw->szCSDVersion;
		unsigned char* dtc = (unsigned char*)os->szCSDVersion;
		while (*src) {
			*dtc++ = (unsigned char)*src++;
		}
		*dtc = '\0';
#endif

	} else {
		return FALSE;
	}
	FreeLibrary(hMod);

return TRUE;
}

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
*/
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR)GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * eLXgER[hϊFSJISwstringiWindows APIgpj
 * @param  string src SJISeLXg
 * @return string ϊeLXg
*/
std::wstring __sjis_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');

	if (::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _SW(s)	__sjis_wstring(s)

/**
 * eLXgER[hϊFwstringSJISiWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiSJISj
*/
std::string __wstring_sjis(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');
	if (::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WS(s)	__wstring_sjis(s)

/**
 * eLXgER[hϊFUTF-8wstringiWindows APIgpj
 * @param  string src UTF-8eLXg
 * @return string ϊeLXg
*/
wstring __utf8_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');
	if (::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _UW(s)	__utf8_wstring(s)

/**
 * eLXgER[hϊFwstringUTF-8iWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string __wstring_utf8(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');

	if (::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WU(s)	__wstring_utf8(s)

/**
 * eLXgER[hϊFSJISUTF-8iWindows APIgpj
 * @param  wstring src SJISeLXg
 * @return string ϊeLXgiUTF-8j
*/
string sjis_utf8(std::string src) {
	wstring const wide = __sjis_wstring(src);
	return __wstring_utf8(wide);
}

/**
 * eLXgER[hϊFUTF-8SJISiWindows APIgpj
 * @param  wstring src UTF-8eLXg
 * @return string ϊeLXgiUTF-8j
*/
string utf8_sjis(std::string src) {
	wstring const wide = __utf8_wstring(src);
	return __wstring_sjis(wide);
}
/**
 * EW[JԂɕϊ
 * @param  char* gmt   EWij  jFri, 14 Aug 2020 08:46:35
 * @param  char* local [JԂi[    j2020-08-14 17:46
 * @return Ȃ
*/
time_t gmt2local(char* gmt, char* local) {
	tm t0, t1;
	time_t dt;

	std::istringstream ss((char *)gmt);
	ss >> std::get_time(&t0, "%a, %d %b %Y %H:%M:%S");
	dt = mktime(&t0) - timezone;
	localtime_s(&t1, &dt);
	strftime(local, SIZE_BUFF, "%Y-%m-%d %H:%M", &t1);

	return dt;
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	hParent_X = 0;
	hParent_Y = 0;
	Query     = "";
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "query") {
					Query = utf8_sjis((string)it.second.data());
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * IvV̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", sjis_utf8(Query));
	child1.add("<xmlattr>.type", "query");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg,
					WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// t@Co͏ =======================================================
/**
 * ʂCSVt@Cɕۑ
 * @param	const char *fname ۑt@C
 * @return	Ȃ
*/
void __saveCSV(const char *fname) {
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "^Cg" << "\",";
	outputfile << "\"" << "fBA" << "\",";
	outputfile << "\"" << "zM" << "\",";
	outputfile << "\"" << "LURL" << "\"" << endl;

	// f[^{
	for (int i = 0; i < SIZE_NEWS; i++) {
		if (News[i] != NULL) {
			outputfile << "\"" << _WS(News[i]->title) << "\",";
			outputfile << "\"" << _WS(News[i]->source) << "\",";
			outputfile << "\"" << News[i]->pubdate.c_str() << "\",";
			outputfile << "\"" << News[i]->link.c_str() << "\"" << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ʂCSVt@Cɕۑ
 * @param	Ȃ
 * @return	Ȃ
*/
void saveCSV(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

// Googlej[X ===================================================
/**
 * Googlej[XURL𐶐iRSS2.0ój
 * @param	char* query L[
 * @param	char* url   URLi[
 * @param	size_t sz   url̃TCY
 * @return	Ȃ
*/
void getURL_GoogleNewsSearch(char* query, char* url, size_t sz) {
	const string google = URL_GOOGLENEWS;

	static char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1];

	strncpy(buff1, sjis_utf8((string)query).c_str(), SIZE_BUFF);

	CURL *curl = curl_easy_init();
	strncpy(buff2, curl_easy_escape(curl, (const char *)buff1, strlen(buff1)), SIZE_BUFF);

	string ss = google + (string)buff2;
	strncpy(url, ss.c_str(), sz);

	curl_easy_cleanup(curl);
}

size_t callBackFunk(char* ptr, size_t size, size_t nmemb, string* stream) {
	int realsize = size * nmemb;
	stream->append(ptr, realsize);
	return realsize;
}

/**
 * ʂzɊi[
 * @param	char* query L[[h
 * @param	int   $i    JE^
 * @return	int ʂ̌
*/
int searchNews(char* query) {
	// 
	for (int i = 0; i < SIZE_NEWS; i++) {
		News[i].reset();
		News[i] = NULL;
	}

	// cURLɂ錋ʎ擾
	CURL *curl;
	CURLcode res = (CURLcode)0;
	curl = curl_easy_init();
	string chunk;
	char url[SIZE_BUFF + 1];
	getURL_GoogleNewsSearch(query, (char *)url, SIZE_BUFF);

	// cURLɂGooglej[X
	if (curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, UserAgent.c_str());
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, callBackFunk);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, (string*)&chunk);
		res = curl_easy_perform(curl);
		curl_easy_cleanup(curl);
	}
    if (res != CURLE_OK) {
		ErrorMessage = "GoogleG[";		// cURLG[
		return (-1);
	}

	// XMLǂݍ
	std::stringstream ss;
	ss << chunk;
	ptree pt;
	xml_parser::read_xml(ss, pt);

	// XML
	ptree tree;
	char buff[SIZE_BUFF + 1];
	wstring title2;
	int cnt = -1;
	for (auto it : pt.get_child("rss.channel")) {
		// itemȊO͓ǂݔ΂
		if (it.first != "item")		continue;
		cnt++;
		News[cnt] = make_unique<_News>();

		// o
		if (optional<string>title = it.second.get_optional<string>("title")) {
			News[cnt]->title = _UW(title.value());
		}
		// LN
		if (optional<string>link = it.second.get_optional<string>("link")) {
			News[cnt]->link = link.value();
		}
		// zM
		if (optional<string>pubdate = it.second.get_optional<string>("pubDate")) {
			News[cnt]->ti = gmt2local((char*)pubdate->c_str(), buff);
			News[cnt]->pubdate = (string)buff;
		}
		// LTv
		if (optional<string>description = it.second.get_optional<string>("description")) {
			News[cnt]->description = _UW(description.value());
		}
		// fBA
		if (optional<string>source = it.second.get_optional<string>("source")) {
			News[cnt]->source = _UW(source.value());
		}
	}
	chunk.clear();

	return cnt;
}

// L\[gpID
enum {
	SORT_TITLE_ASC,
	SORT_TITLE_DEC,
	SORT_MEDIA_ASC,
	SORT_MEDIA_DEC,
	SORT_PUBDATE_ASC,
	SORT_PUBDATE_DEC,
	SORT_NONE
};

// L\[gpID
enum {
	SORT_ASC,
	SORT_DEC
};

/**
 * L\[gp̔r֐F^Cgij
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpTitleAsc(const _stNews& left, const _stNews& right) {
	return wcscmp(left.title, right.title) < 0;
}

/**
 * L\[gp̔r֐F^Cgi~j
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpTitleDec(const _stNews& left, const _stNews& right) {
	return wcscmp(left.title, right.title) >= 0;
}

/**
 * L\[gp̔r֐FfBAij
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpMediaAsc(const _stNews& left, const _stNews& right) {
	return wcscmp(left.source, right.source) < 0;
}

/**
 * L\[gp̔r֐FfBAi~j
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpMediaDec(const _stNews& left, const _stNews& right) {
	return wcscmp(left.source, right.source) >= 0;
}

/**
 * L\[gp̔r֐FzMij
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpPubDateAsc(const _stNews& left, const _stNews& right) {
	return left.ti < right.ti;
}

/**
 * L\[gp̔r֐FzMi~j
 * @param	const _stNews& left, right
 * @return	r
*/
bool __cmpPubDateDec(const _stNews& left, const _stNews& right) {
	return left.ti >= right.ti;
}

/**
 * \[gpϐɑ
 * @param	const _stNews& left, right
 * @return	r
*/
_stNews __push_stNews(unique_ptr<_News> &ptr) {
	_stNews s;
	s.title		= (wchar_t*)ptr->title.c_str();
	s.source	= (wchar_t*)ptr->source.c_str();
	s.pubdate	= (char*)ptr->pubdate.c_str();
	s.ti		= (time_t)ptr->ti;
	s.link		= (char*)ptr->link.c_str();
	return s;
}

/**
 * j[XL̃\[g
 * @param	int c  \[g
 * @return	Ȃ
*/
void sortNews(int c) {
	struct {
		int id;
		bool (*fn)(const _stNews& left, const _stNews& right);
} table[] = {
	{ SORT_TITLE_ASC,	__cmpTitleAsc },
	{ SORT_TITLE_DEC,	__cmpTitleDec },
	{ SORT_MEDIA_ASC,	__cmpMediaAsc },
	{ SORT_MEDIA_DEC,	__cmpMediaDec },
	{ SORT_PUBDATE_ASC,	__cmpPubDateAsc },
	{ SORT_PUBDATE_DEC,	__cmpPubDateDec }
};
	int i;
	bool (*fn)(const _stNews& left, const _stNews& right) = NULL;

	// \[gpz̏
	Vnews.clear();
	Vnews.shrink_to_fit();

	// j[XL\[gpz
	for (i = 0; i < SIZE_NEWS; i++) {
		if (News[i] != NULL) {
			Vnews.push_back(__push_stNews(News[i]));
		}
	}

	// \[gp֐̑I
	for (i = 0; i < (int)(sizeof(table) / sizeof(*table)); i++) {
		if (c == table[i].id) {
			fn = table[i].fn;
			break;
		}
	}

	// \[gs
	if (fn != NULL) {
		stable_sort(Vnews.begin(), Vnews.end(), fn);
	}
}

// Xgr[̗
enum {
	COL_TITLE,
	COL_SOURCE,
	COL_PUBDATE,
	COL_LINK
};

/**
 * j[Xꗗ̃t[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;
	lvcol.fmt = LVCFMT_LEFT;

	lvcol.cx = 500;
	lvcol.pszText = (char *)"^Cg";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_TITLE, (WPARAM)&lvcol);
	lvcol.cx = 150;
	lvcol.pszText = (char *)"fBA";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_SOURCE, (WPARAM)&lvcol);
	lvcol.cx = 150;
	lvcol.pszText = (char *)"zM";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_PUBDATE, (WPARAM)&lvcol);
	lvcol.cx = 0;
	lvcol.pszText = (char *)"URL";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LINK, (WPARAM)&lvcol);

	// r\
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * j[Xꗗ쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;

	// 
	for (int i = 0; i < SIZE_NEWS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0,(WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < SIZE_NEWS; i++) {
		if (News[i] == NULL)	break;
		// ^Cg
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_TITLE;
		item.pszText = (LPSTR)_WS(Vnews[i].title).substr(0, MAX_LISTVIEWITEM).c_str();
		SendMessage(hWnd, LVM_INSERTITEMA, 0,(WPARAM)&item);
		// fBA
		item.iSubItem = COL_SOURCE;
		item.pszText = (LPSTR)_WS(Vnews[i].source).substr(0, MAX_LISTVIEWITEM).c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// zM
		item.iSubItem = COL_PUBDATE;
		item.pszText = (LPSTR)Vnews[i].pubdate;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// N
		item.iSubItem = COL_LINK;
		item.pszText = (LPSTR)Vnews[i].link;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	char *str;
	LVITEM item;
	LV_HITTESTINFO lvinfo;
	NM_LISTVIEW *pNMLV;
	TCHAR buff[SIZE_BUFF + 1];
	static int subsort[100];

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM) hIcon);
		ErrorMessage = "";
		// IvVǂݍ
		loadParameter();
		setStrEditBox(hDlg, IDC_EDIT_QUERY, Query);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_NEWS));
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDM_EXEC:
		case IDC_BUTTON_SEARCH:
			ErrorMessage = "";
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			Query = getStrEditBox(hDlg, IDC_EDIT_QUERY);
			// Googlej[X
			searchNews((char *)Query.c_str());
			sortNews(SORT_NONE);
			// ꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_NEWS));
			setStrEditBox(hDlg, IDC_TEXT_ERROR, ErrorMessage);
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV();
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
			setClipboardData(getStrEditBox(hParent, IDC_EDIT_QUERY));
			break;
		// \t
		case IDM_PASTE:
			str = getClipboardData();
			if (str != NULL) {
				setStrEditBox(hParent, IDC_EDIT_QUERY, str);
			}
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_QUERY, "");
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			saveParameter();
			EndDialog(hParent, 0);
			return 0;
		default:
			return 1;
	}
	break;

	// ʒm
	case WM_NOTIFY:
		switch(((LPNMHDR)lParam)->idFrom) {
		case IDC_LISTVIEW_NEWS:
			switch (((LPNMLISTVIEW)lParam)->hdr.code) {
			// ꗗ̃xNbN
			case LVN_COLUMNCLICK:
				pNMLV = (NM_LISTVIEW *)lParam;
				if (subsort[pNMLV->iSubItem] == SORT_ASC) {
					subsort[pNMLV->iSubItem] = SORT_DEC;
				} else {
					subsort[pNMLV->iSubItem] = SORT_ASC;
				}
				// j[XL̕בւ
				sortNews(pNMLV->iSubItem * 2 + subsort[pNMLV->iSubItem]);
				// ꗗ\
				makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_NEWS));
				break;
			// j[Xꗗ1sI
			case LVN_ITEMCHANGED:
			// j[Xꗗ1s_uNbN
			// case NM_DBLCLK:
				GetCursorPos((LPPOINT)&lvinfo.pt);
				ScreenToClient(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo.pt);
				ListView_HitTest(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo);
				if ((lvinfo.flags & LVHT_ONITEM) != 0) {
					item.mask = TVIF_HANDLE | TVIF_TEXT;
					item.iItem = lvinfo.iItem;
					item.iSubItem = COL_LINK;
					item.pszText = buff;
					item.cchTextMax = SIZE_BUFF;
					ListView_GetItem(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &item);
					// uEUN
					ShellExecute(hParent, _T("open"), _T(buff), NULL, NULL, SW_RESTORE);
				}
				break;
			default:
				break;
		}
		break;
	default:
		break;
	}
	break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		saveParameter();
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 1.5.9  2025/10/18 gpCuXV
 * @version 1.5.8  2025/07/05 gpCuXV
 * @version 1.5.7  2025/03/01 gpCuXV
 * @version 1.5.6  2024/11/16 gpCuXV
 * @version 1.5.5  2024/07/14 gpCuXV
 * @version 1.5.4  2024/03/06 gpCuXV
 * @version 1.5.3  2023/10/14 gpCuXV
 * @version 1.5.2  2023/06/10 gpCuXV
 * @version 1.5.1  2023/03/05 gpCuXV
 * @version 1.5.0  2022/11/05 ݒNA@\CgpCuXV
 * @version 1.4    2022/07/23 EBhEʒuEL[ۑCgpCuXV
 * @version 1.3    2022/04/29 UserAgentǉClibcurlEOpenSSLŐVłɍXV
 * @version 1.2    2020/09/05 f[^\string/wstringɕύX
 * @version 1.1    2020/08/29 iconv, Libxml2Boost C++CuŒu
 * @version 1.0    2020/08/15 
*/
