/*
 * Decompiled with CFR 0.152.
 */
package active;

import util.DJ;

public abstract class Activator {
    public static final String IDENTITY = "active.Identity";
    public static final String STEP = "active.Step";
    public static final String SIGMOID = "active.Sigmoid";
    public static final String RELU = "active.ReLU";
    public static final String SOFTMAX = "active.SoftMax";

    public abstract void function(double[] var1, double[] var2);

    public abstract void function(double[][] var1, double[][] var2);

    public void derivative(double[] u, double[] y, double[] dudy) {
        int i = 0;
        while (i < u.length) {
            dudy[i] = 0.0;
            ++i;
        }
    }

    public void derivative(double[][] u, double[][] y, double[][] dudy) {
        int i = 0;
        while (i < u.length) {
            int j = 0;
            while (j < u[0].length) {
                dudy[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void derivative(double[] u, double[] y, double[] c, double[] dudy) {
        int i = 0;
        while (i < u.length) {
            dudy[i] = 0.0;
            ++i;
        }
    }

    public void derivative(double[][] u, double[][] y, double[][] c, double[][] dudy) {
        int i = 0;
        while (i < u.length) {
            int j = 0;
            while (j < u[0].length) {
                dudy[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public static final Activator createActivator(String activatorName) {
        Activator activator = null;
        try {
            Class<?> activatorClass = Class.forName(activatorName);
            activator = (Activator)activatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            DJ._print("Activator.Function(): ReflectiveOperationException.");
            DJ._print("Activator.Function(): Failed to get an Activator.");
        }
        return activator;
    }
}

