/*
 * Decompiled with CFR 0.152.
 */
package active;

import active.Activator;

public class Sigmoid
extends Activator {
    @Override
    public void function(double[] u, double[] y) {
        int length = u.length;
        int i = 0;
        while (i < length) {
            y[i] = 1.0 / (1.0 + Math.exp(-u[i]));
            ++i;
        }
    }

    @Override
    public void function(double[][] u, double[][] y) {
        int i = 0;
        while (i < u.length) {
            int j = 0;
            while (j < u[0].length) {
                y[i][j] = 1.0 / (1.0 + Math.exp(-u[i][j]));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void derivative(double[] u, double[] y, double[] dydu) {
        int i = 0;
        while (i < u.length) {
            dydu[i] = (1.0 - y[i]) * y[i];
            ++i;
        }
    }

    @Override
    public void derivative(double[][] u, double[][] y, double[][] dydu) {
        int i = 0;
        while (i < u.length) {
            int j = 0;
            while (j < u[0].length) {
                dydu[i][j] = (1.0 - y[i][j]) * y[i][j];
                ++j;
            }
            ++i;
        }
    }

    private double sigmoid(double u) {
        double y = 1.0 / (1.0 + Math.exp(-u));
        return y;
    }
}

