/*
 * Decompiled with CFR 0.152.
 */
package active;

import active.Activator;

public class SoftMax
extends Activator {
    @Override
    public void function(double[] u, double[] y) {
        int length = u.length;
        double sum = 0.0;
        double[] expU = new double[length];
        int i = 0;
        while (i < length) {
            expU[i] = Math.exp(u[i]);
            sum += expU[i];
            ++i;
        }
        i = 0;
        while (i < length) {
            y[i] = expU[i] / sum;
            ++i;
        }
    }

    @Override
    public void function(double[][] u, double[][] y) {
        int j;
        int row = u.length;
        int col = u[0].length;
        double sum = 0.0;
        double[][] expU = new double[row][col];
        int i = 0;
        while (i < row) {
            j = 0;
            while (j < col) {
                expU[i][j] = Math.exp(u[i][j]);
                sum += expU[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < row) {
            j = 0;
            while (j < col) {
                y[i][j] = expU[i][j] / sum;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void derivative(double[] u, double[] y, double[] dydu) {
        int length = u.length;
        int i = 0;
        while (i < length) {
            dydu[i] = 1.0;
            ++i;
        }
    }

    @Override
    public void derivative(double[][] u, double[][] y, double[][] dudy) {
        int row = u.length;
        int col = u[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                dudy[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
    }
}

